/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.api.IMultiBlock;
import com.github.tartaricacid.touhoulittlemaid.api.task.FarmHandler;
import com.github.tartaricacid.touhoulittlemaid.api.task.FeedHandler;
import com.github.tartaricacid.touhoulittlemaid.api.util.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.api.util.ItemDefinition;
import com.google.common.base.Optional;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LittleMaidAPI {
    private static ILittleMaidAPI INSTANCE = null;

    public static void setInstance(ILittleMaidAPI instance) {
        INSTANCE = instance;
    }

    @Nullable
    public static IMaidBauble registerBauble(ItemDefinition item, IMaidBauble bauble) {
        return INSTANCE.registerBauble(item, bauble);
    }

    @Nullable
    public static IMaidBauble getBauble(ItemDefinition item) {
        return INSTANCE.getBauble(item);
    }

    @Nullable
    public static IMaidBauble getBauble(ItemStack item) {
        return INSTANCE.getBauble(item);
    }

    @Nonnull
    public static int getBaubleSlotInMaid(AbstractEntityMaid maid, IMaidBauble bauble) {
        return INSTANCE.getBaubleSlotInMaid(maid, bauble);
    }

    public static void registerTask(IMaidTask task) {
        INSTANCE.registerTask(task);
    }

    public static Optional<IMaidTask> findTask(ResourceLocation uid) {
        return INSTANCE.findTask(uid);
    }

    public static List<IMaidTask> getTasks() {
        return INSTANCE.getTasks();
    }

    public static IMaidTask getIdleTask() {
        return INSTANCE.getIdleTask();
    }

    public static void registerFarmHandler(FarmHandler handler) {
        INSTANCE.registerFarmHandler(handler);
    }

    public static List<FarmHandler> getFarmHandlers() {
        return INSTANCE.getFarmHandlers();
    }

    public static void registerFeedHandler(FeedHandler handler) {
        INSTANCE.registerFeedHandler(handler);
    }

    public static List<FeedHandler> getFeedHandlers() {
        return INSTANCE.getFeedHandlers();
    }

    public static void registerMultiBlock(IMultiBlock multiBlock) {
        INSTANCE.registerMultiBlock(multiBlock);
    }

    public static List<IMultiBlock> getMultiBlockList() {
        return INSTANCE.getMultiBlockList();
    }

    public static interface ILittleMaidAPI {
        public IMaidBauble registerBauble(ItemDefinition var1, IMaidBauble var2);

        public IMaidBauble getBauble(ItemDefinition var1);

        default public IMaidBauble getBauble(ItemStack item) {
            return this.getBauble(ItemDefinition.of(item));
        }

        default public int getBaubleSlotInMaid(AbstractEntityMaid maid, IMaidBauble bauble) {
            BaubleItemHandler handler = maid.getBaubleInv();
            if (handler != null) {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    IMaidBauble baubleIn = handler.getBaubleInSlot(i);
                    if (baubleIn != bauble) continue;
                    return i;
                }
            }
            return -1;
        }

        public void registerTask(IMaidTask var1);

        public Optional<IMaidTask> findTask(ResourceLocation var1);

        public List<IMaidTask> getTasks();

        public IMaidTask getIdleTask();

        public void registerFarmHandler(FarmHandler var1);

        public List<FarmHandler> getFarmHandlers();

        public void registerFeedHandler(FeedHandler var1);

        public List<FeedHandler> getFeedHandlers();

        public void registerMultiBlock(IMultiBlock var1);

        public List<IMultiBlock> getMultiBlockList();
    }
}

