/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.bauble;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidAPI;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NimbleFabricBauble
implements IMaidBauble {
    private static final int MAX_RETRY = 16;

    public NimbleFabricBauble() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingDamage(LivingAttackEvent event) {
        AbstractEntityMaid maid;
        int slot;
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (entity instanceof AbstractEntityMaid && source instanceof EntityDamageSourceIndirect && (slot = LittleMaidAPI.getBaubleSlotInMaid(maid = (AbstractEntityMaid)entity, this)) >= 0) {
            event.setCanceled(true);
            ItemStack stack = maid.getBaubleInv().getStackInSlot(slot);
            stack.func_77972_a(1, (EntityLivingBase)maid);
            maid.getBaubleInv().setStackInSlot(slot, stack);
            for (int i = 0; i < 16; ++i) {
                if (!this.teleportRandomly(maid)) continue;
                return;
            }
        }
    }

    private boolean teleportRandomly(AbstractEntityMaid maid) {
        double x = maid.field_70165_t + (maid.field_70170_p.field_73012_v.nextDouble() - 0.5) * 16.0;
        double y = maid.field_70163_u + (double)(maid.field_70170_p.field_73012_v.nextInt(64) - 8);
        double z = maid.field_70161_v + (maid.field_70170_p.field_73012_v.nextDouble() - 0.5) * 16.0;
        return this.teleportTo(maid, x, y, z);
    }

    private boolean teleportTo(AbstractEntityMaid maid, double x, double y, double z) {
        boolean teleportIsSuccess = maid.func_184595_k(x, y, z);
        if (teleportIsSuccess) {
            maid.field_70170_p.func_184148_a(null, maid.field_70169_q, maid.field_70167_r, maid.field_70166_s, SoundEvents.field_187534_aX, maid.func_184176_by(), 1.0f, 1.0f);
            maid.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return teleportIsSuccess;
    }
}

