/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.bauble;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import com.github.tartaricacid.touhoulittlemaid.util.BytesBooleansConvert;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class WirelessIOBauble
implements IMaidBauble {
    public static final int MAX_DISTANCE = 16;

    @Nonnull
    public static ItemStack insertItemStacked(IItemHandler inventory, @Nonnull ItemStack stack, boolean simulate, @Nullable boolean[] slotConfig) {
        int i;
        if (inventory == null || stack.func_190926_b()) {
            return stack;
        }
        if (!stack.func_77985_e()) {
            return WirelessIOBauble.insertItem(inventory, stack, simulate, slotConfig);
        }
        int sizeInventory = inventory.getSlots();
        for (i = 0; i < sizeInventory; ++i) {
            ItemStack slot = inventory.getStackInSlot(i);
            if ((slotConfig == null || i >= slotConfig.length || !slotConfig[i]) && WirelessIOBauble.canItemStacksStackRelaxed(slot, stack) && (stack = inventory.insertItem(i, stack, simulate)).func_190926_b()) break;
        }
        if (!stack.func_190926_b()) {
            for (i = 0; i < sizeInventory && (slotConfig != null && i < slotConfig.length && slotConfig[i] || !inventory.getStackInSlot(i).func_190926_b() || !(stack = inventory.insertItem(i, stack, simulate)).func_190926_b()); ++i) {
            }
        }
        return stack;
    }

    public static ItemStack insertItem(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate, @Nullable boolean[] slotConfig) {
        if (dest == null || stack.func_190926_b()) {
            return stack;
        }
        for (int i = 0; i < dest.getSlots(); ++i) {
            if (slotConfig != null && i < slotConfig.length && slotConfig[i] || !(stack = dest.insertItem(i, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static boolean canItemStacksStackRelaxed(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.func_190926_b() || b.func_190926_b() || a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (!a.func_77985_e()) {
            return false;
        }
        if (a.func_77981_g() && a.func_77960_j() != b.func_77960_j()) {
            return false;
        }
        if (a.func_77942_o() != b.func_77942_o()) {
            return false;
        }
        return (!a.func_77942_o() || Objects.equals(a.func_77978_p(), Objects.requireNonNull(b.func_77978_p()))) && a.areCapsCompatible(b);
    }

    @Override
    public void onTick(AbstractEntityMaid entityMaid, ItemStack baubleItem) {
        if (entityMaid.field_70173_aa % 100 == 0) {
            BlockPos bindingPos = ItemWirelessIO.getBindingPos(baubleItem);
            if (bindingPos == null) {
                return;
            }
            if (entityMaid.func_174831_c(bindingPos) > 256.0) {
                return;
            }
            TileEntity te = entityMaid.field_70170_p.func_175625_s(bindingPos);
            if (!(te instanceof TileEntityChest)) {
                return;
            }
            TileEntityChest chest = (TileEntityChest)te;
            if (chest.func_174893_q_()) {
                return;
            }
            IItemHandler chestInv = (IItemHandler)chest.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (chestInv == null) {
                return;
            }
            IItemHandlerModifiable maidInv = entityMaid.getAvailableInv(false);
            boolean isInput = ItemWirelessIO.isInputMode(baubleItem);
            boolean isBlacklist = ItemWirelessIO.isBlacklist(baubleItem);
            byte[] slotConfigTmp = ItemWirelessIO.getSlotConfig(baubleItem);
            if (slotConfigTmp != null) {
                slotConfigTmp[maidInv.getSlots() - 2] = slotConfigTmp[45];
                slotConfigTmp[maidInv.getSlots() - 1] = slotConfigTmp[46];
            }
            boolean[] slotConfigData = BytesBooleansConvert.bytes2Booleans(slotConfigTmp);
            ItemStackHandler filterList = ItemWirelessIO.getFilterList(baubleItem);
            if (isInput) {
                this.maidToChest((IItemHandler)maidInv, chestInv, isBlacklist, (IItemHandler)filterList, slotConfigData);
            } else {
                this.chestToMaid(chestInv, (IItemHandler)maidInv, isBlacklist, (IItemHandler)filterList, slotConfigData);
            }
        }
    }

    private void maidToChest(IItemHandler maid, IItemHandler chest, boolean isBlacklist, IItemHandler filterList, boolean[] slotConfig) {
        for (int i = 0; i < maid.getSlots(); ++i) {
            ItemStack after;
            int afterCount;
            int beforeCount;
            if (slotConfig != null && i < slotConfig.length && slotConfig[i]) continue;
            ItemStack maidInvItem = maid.getStackInSlot(i);
            boolean allowMove = isBlacklist;
            for (int j = 0; j < filterList.getSlots(); ++j) {
                ItemStack filterItem = filterList.getStackInSlot(j);
                boolean isEqual = maidInvItem.func_185136_b(filterItem);
                if (!isEqual) continue;
                allowMove = !isBlacklist;
                break;
            }
            if (!allowMove || (beforeCount = maidInvItem.func_190916_E()) == (afterCount = (after = ItemHandlerHelper.insertItemStacked((IItemHandler)chest, (ItemStack)maidInvItem.func_77946_l(), (boolean)false)).func_190916_E())) continue;
            maid.extractItem(i, beforeCount - afterCount, false);
        }
    }

    private void chestToMaid(IItemHandler chest, IItemHandler maid, boolean isBlacklist, IItemHandler filterList, boolean[] slotConfig) {
        for (int i = 0; i < chest.getSlots(); ++i) {
            ItemStack after;
            int afterCount;
            int beforeCount;
            ItemStack chestInvStack = chest.getStackInSlot(i);
            boolean allowMove = isBlacklist;
            for (int j = 0; j < filterList.getSlots(); ++j) {
                ItemStack filterItem = filterList.getStackInSlot(j);
                boolean isEqual = chestInvStack.func_185136_b(filterItem);
                if (!isEqual) continue;
                allowMove = !isBlacklist;
                break;
            }
            if (!allowMove || (beforeCount = chestInvStack.func_190916_E()) == (afterCount = (after = WirelessIOBauble.insertItemStacked(maid, chestInvStack.func_77946_l(), false, slotConfig)).func_190916_E())) continue;
            chest.extractItem(i, beforeCount - afterCount, false);
        }
    }
}

