/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.api.event.AltarCraftEvent;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerSerializer;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipesManager;
import com.github.tartaricacid.touhoulittlemaid.init.MaidSoundEvent;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityAltar;
import com.github.tartaricacid.touhoulittlemaid.util.DelayedTask;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockAltar
extends Block {
    public BlockAltar() {
        super(Material.field_151576_e);
        this.func_149663_c("touhou_little_maid.altar");
        this.func_149711_c(1.0f);
        this.func_149752_b(2000.0f);
        this.setRegistryName("altar");
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityAltar();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityAltar && hand == EnumHand.MAIN_HAND) {
            TileEntityAltar altar = (TileEntityAltar)tileEntity;
            if (playerIn.func_70093_af() || playerIn.func_184614_ca().func_190926_b()) {
                this.applyTakeOutLogic(worldIn, pos, altar, playerIn);
            } else {
                this.applyPlaceAndCraftLogic(worldIn, altar, playerIn);
            }
            altar.refresh();
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    private void applyTakeOutLogic(World world, BlockPos pos, TileEntityAltar altar, EntityPlayer player) {
        if (altar.isCanPlaceItem() && !altar.handler.getStackInSlot(0).func_190926_b()) {
            Block.func_180635_a((World)world, (BlockPos)pos.func_177982_a(0, 1, 0), (ItemStack)altar.handler.extractItem(0, 1, false));
            this.applyCraftingLogic(world, altar, player);
        }
    }

    private void applyPlaceAndCraftLogic(World world, TileEntityAltar altar, EntityPlayer playerIn) {
        if (altar.isCanPlaceItem() && altar.handler.getStackInSlot(0).func_190926_b() && !playerIn.func_184614_ca().func_190926_b()) {
            altar.handler.setStackInSlot(0, ItemHandlerHelper.copyStackWithSize((ItemStack)playerIn.func_184614_ca(), (int)1));
            if (!playerIn.func_184812_l_()) {
                playerIn.func_184614_ca().func_190918_g(1);
            }
            this.applyCraftingLogic(world, altar, playerIn);
        }
    }

    private void applyCraftingLogic(World world, TileEntityAltar altar, EntityPlayer playerIn) {
        ArrayList inputStackList = Lists.newArrayList();
        for (BlockPos pos : altar.getCanPlaceItemPosList()) {
            ItemStack stack;
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof TileEntityAltar) || (stack = ((TileEntityAltar)tileEntity).handler.getStackInSlot(0)).func_190926_b()) continue;
            inputStackList.add(stack);
        }
        if (!inputStackList.isEmpty()) {
            AltarRecipe altarRecipe = AltarRecipesManager.instance().getMatchRecipe(inputStackList);
            PowerHandler power = (PowerHandler)playerIn.getCapability(PowerSerializer.POWER_CAP, null);
            if (altarRecipe != null && power != null && !MinecraftForge.EVENT_BUS.post((Event)new AltarCraftEvent(world, playerIn, power, altarRecipe, inputStackList, altar))) {
                this.spawnResultEntity(world, playerIn, power, altarRecipe, inputStackList, altar);
            }
        }
    }

    private void spawnResultEntity(World world, EntityPlayer playerIn, PowerHandler power, AltarRecipe altarRecipe, List<ItemStack> inputStackList, TileEntityAltar altar) {
        if (power.get() >= altarRecipe.getPowerCost()) {
            BlockPos centrePos = this.getCentrePos(altar.getBlockPosList(), altar.func_174877_v());
            this.addDelayedSpawnLogic(world, altarRecipe, centrePos, inputStackList);
            this.setAllAltarItemForEmpty(world, altar);
            power.min(altarRecipe.getPowerCost());
            this.spawnParticleInCentre(world, centrePos);
            world.func_184134_a((double)centrePos.func_177958_n(), (double)centrePos.func_177956_o(), (double)centrePos.func_177952_p(), MaidSoundEvent.ALTAR_CRAFT, SoundCategory.VOICE, 1.0f, 1.0f, false);
        } else if (!world.field_72995_K) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.altar.not_enough_power", new Object[0]));
        }
    }

    private void addDelayedSpawnLogic(World world, AltarRecipe altarRecipe, BlockPos centrePos, List<ItemStack> inputStackList) {
        DelayedTask.add(() -> {
            if (!world.field_72995_K) {
                Entity entity = altarRecipe.getOutputEntity(world, centrePos, inputStackList);
                if (entity instanceof EntityLightningBolt) {
                    world.func_72942_c(entity);
                } else {
                    world.func_72838_d(entity);
                }
            }
        }, 3);
    }

    private void setAllAltarItemForEmpty(World world, TileEntityAltar altar) {
        for (BlockPos pos : altar.getCanPlaceItemPosList()) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof TileEntityAltar)) continue;
            ((TileEntityAltar)tileEntity).handler.setStackInSlot(0, ItemStack.field_190927_a);
            ((TileEntityAltar)tileEntity).refresh();
            this.spawnParticleInCentre(world, tileEntity.func_174877_v());
        }
    }

    private void spawnParticleInCentre(World world, BlockPos centrePos) {
        boolean width = true;
        boolean height = true;
        for (int i = 0; i < 5; ++i) {
            double xSpeed = RANDOM.nextGaussian() * 0.02;
            double ySpeed = RANDOM.nextGaussian() * 0.02;
            double zSpeed = RANDOM.nextGaussian() * 0.02;
            world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (double)centrePos.func_177958_n() + (double)(RANDOM.nextFloat() * (float)width * 2.0f) - (double)width - xSpeed * 10.0, (double)centrePos.func_177956_o() + (double)(RANDOM.nextFloat() * (float)height) - ySpeed * 10.0, (double)centrePos.func_177952_p() + (double)(RANDOM.nextFloat() * (float)width * 2.0f) - (double)width - zSpeed * 10.0, xSpeed, ySpeed, zSpeed, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)centrePos.func_177958_n() + (double)(RANDOM.nextFloat() * (float)width * 2.0f) - (double)width - xSpeed * 10.0, (double)centrePos.func_177956_o() + (double)(RANDOM.nextFloat() * (float)height) - ySpeed * 10.0, (double)centrePos.func_177952_p() + (double)(RANDOM.nextFloat() * (float)width * 2.0f) - (double)width - zSpeed * 10.0, xSpeed, ySpeed, zSpeed, new int[0]);
        }
    }

    private BlockPos getCentrePos(List<BlockPos> posList, BlockPos posClick) {
        int x = 0;
        int y = posClick.func_177956_o() - 2;
        int z = 0;
        for (BlockPos pos : posList) {
            if (pos.func_177956_o() != y) continue;
            x += pos.func_177958_n();
            z += pos.func_177952_p();
        }
        return new BlockPos(x / 8, y, z / 8);
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileEntity;
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityAltar && !((TileEntityAltar)tileEntity).handler.getStackInSlot(0).func_190926_b()) {
            Block.func_180635_a((World)worldIn, (BlockPos)pos.func_177982_a(0, 1, 0), (ItemStack)((TileEntityAltar)tileEntity).handler.getStackInSlot(0));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tileEntity;
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityAltar) {
            this.restoreStorageBlock(worldIn, pos, ((TileEntityAltar)tileEntity).getBlockPosList());
            if (!player.func_184812_l_()) {
                this.dropStorageBlock(worldIn, pos, (TileEntityAltar)tileEntity);
            }
        }
    }

    private void restoreStorageBlock(World worldIn, BlockPos currentPos, List<BlockPos> posList) {
        for (BlockPos storagePos : posList) {
            TileEntity tileEntity;
            if (storagePos.equals((Object)currentPos) || !((tileEntity = worldIn.func_175625_s(storagePos)) instanceof TileEntityAltar)) continue;
            worldIn.func_175656_a(storagePos, ((TileEntityAltar)tileEntity).getBlockState());
        }
    }

    private void dropStorageBlock(World worldIn, BlockPos pos, TileEntityAltar tileEntityAltar) {
        Block block = tileEntityAltar.getBlockState().func_177230_c();
        Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Item.func_150898_a((Block)block), 1, block.func_176201_c(tileEntityAltar.getBlockState())));
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityAltar) {
            IBlockState blockState = ((TileEntityAltar)tileEntity).getBlockState();
            return blockState.func_177230_c().func_185473_a(world, pos, blockState);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityAltar) {
            this.addBlockDestroyEffects(world, pos, ((TileEntityAltar)tileEntity).getBlockState(), manager);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        TileEntity tileEntity = world.func_175625_s(target.func_178782_a());
        if (tileEntity instanceof TileEntityAltar) {
            this.addBlockHitEffects(world, target.func_178782_a(), target.field_178784_b, ((TileEntityAltar)tileEntity).getBlockState(), manager);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockDestroyEffects(World world, BlockPos pos, IBlockState state, ParticleManager manager) {
        if (!state.func_177230_c().isAir(state, (IBlockAccess)world, pos) && !state.func_177230_c().addDestroyEffects(world, pos, manager)) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, new int[]{Block.func_176210_f((IBlockState)state)});
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockHitEffects(World world, BlockPos pos, EnumFacing side, IBlockState iblockstate, ParticleManager manager) {
        Random rand = Block.RANDOM;
        if (iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            AxisAlignedBB axisalignedbb = iblockstate.func_185900_c((IBlockAccess)world, pos);
            double d0 = (double)i + rand.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
            double d1 = (double)j + rand.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
            double d2 = (double)k + rand.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
            if (side == EnumFacing.DOWN) {
                d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
            }
            if (side == EnumFacing.UP) {
                d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
            }
            if (side == EnumFacing.NORTH) {
                d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
            }
            if (side == EnumFacing.SOUTH) {
                d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
            }
            if (side == EnumFacing.WEST) {
                d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
            }
            if (side == EnumFacing.EAST) {
                d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
            }
            manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

