/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGarageKit;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGarageKit
extends Block {
    public static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    private static final String DEFAULT_ENTITY_ID = "touhou_little_maid:entity.passive.maid";
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    private static final NBTTagCompound DEFAULT_DATA = new NBTTagCompound();

    public BlockGarageKit() {
        super(Material.field_151571_B);
        this.func_149663_c("touhou_little_maid.garage_kit");
        this.func_149711_c(0.5f);
        this.setRegistryName("garage_kit");
        this.func_149647_a(MaidItems.GARAGE_KIT_TABS);
    }

    public static NBTTagCompound getEntityData(ItemStack stack) {
        if (!BlockGarageKit.getTagCompoundSafe(stack).func_74775_l(NBT.MAID_DATA.getName()).func_82582_d()) {
            return BlockGarageKit.getTagCompoundSafe(stack).func_74775_l(NBT.MAID_DATA.getName());
        }
        return DEFAULT_DATA;
    }

    private static NBTTagCompound getTagCompoundSafe(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    private static ItemStack getItemStackFromBlock(World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityGarageKit) {
            TileEntityGarageKit kit = (TileEntityGarageKit)te;
            return BlockGarageKit.getItemStackWithData(kit.getEntityId(), kit.getModelId(), kit.getMaidData());
        }
        return BlockGarageKit.getItemStackWithData(DEFAULT_ENTITY_ID, DEFAULT_MODEL_ID, DEFAULT_DATA);
    }

    public static ItemStack getItemStackWithData(String entityId, String modelId, NBTTagCompound entityData) {
        ItemStack stack = new ItemStack(Item.func_150898_a((Block)MaidBlocks.GARAGE_KIT));
        NBTTagCompound data = BlockGarageKit.getTagCompoundSafe(stack);
        data.func_74778_a(NBT.ENTITY_ID.getName(), entityId);
        if (modelId != null) {
            data.func_74778_a(NBT.MODEL_ID.getName(), modelId);
        }
        if (!entityData.func_82582_d()) {
            data.func_74782_a(NBT.MAID_DATA.getName(), (NBTBase)entityData);
        }
        return stack;
    }

    public static String getEntityId(ItemStack stack) {
        if (!BlockGarageKit.getTagCompoundSafe(stack).func_74779_i(NBT.ENTITY_ID.getName()).isEmpty()) {
            return BlockGarageKit.getTagCompoundSafe(stack).func_74779_i(NBT.ENTITY_ID.getName());
        }
        return DEFAULT_ENTITY_ID;
    }

    public static String getModelId(ItemStack stack) {
        if (!BlockGarageKit.getTagCompoundSafe(stack).func_74779_i(NBT.MODEL_ID.getName()).isEmpty()) {
            return BlockGarageKit.getTagCompoundSafe(stack).func_74779_i(NBT.MODEL_ID.getName());
        }
        return DEFAULT_MODEL_ID;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return BlockGarageKit.getItemStackFromBlock(world, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BLOCK_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        if (GeneralConfig.MISC_CONFIG.fastRendering) {
            items.add((Object)BlockGarageKit.getItemStackWithData(DEFAULT_ENTITY_ID, DEFAULT_MODEL_ID, DEFAULT_DATA));
        } else {
            for (String modelId : CustomResourcesLoader.MAID_MODEL.getModelIdSet()) {
                items.add((Object)BlockGarageKit.getItemStackWithData(DEFAULT_ENTITY_ID, modelId, DEFAULT_DATA));
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        BlockGarageKit.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)BlockGarageKit.getItemStackFromBlock(worldIn, pos));
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityGarageKit();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityGarageKit) {
            ((TileEntityGarageKit)te).setData(BlockGarageKit.getEntityId(stack), placer.func_174811_aO().func_176734_d(), BlockGarageKit.getModelId(stack), BlockGarageKit.getEntityData(stack));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String entityId = BlockGarageKit.getEntityId(stack);
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.garage_kit.entity_id.desc", (Object[])new Object[]{I18n.func_135052_a((String)("entity." + EntityList.func_191302_a((ResourceLocation)new ResourceLocation(entityId)) + ".name"), (Object[])new Object[0])}));
        if (entityId.equals(DEFAULT_ENTITY_ID)) {
            CustomResourcesLoader.MAID_MODEL.getInfo(BlockGarageKit.getModelId(stack)).ifPresent(info -> tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.garage_kit.name.desc", (Object[])new Object[]{ParseI18n.parse(info.getName())})));
        }
        if (flagIn.func_194127_a() && GuiScreen.func_146272_n() && stack.func_77942_o()) {
            tooltip.add(stack.func_77978_p().toString());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K || stack.func_77973_b() != Items.field_151063_bx) {
            return false;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileEntityGarageKit)) {
            return false;
        }
        ResourceLocation id = ItemMonsterPlacer.func_190908_h((ItemStack)stack);
        if (id == null || !EntityList.field_75627_a.containsKey(id)) {
            return false;
        }
        TileEntityGarageKit garageKit = (TileEntityGarageKit)tile;
        Entity entity = EntityList.func_188429_b((ResourceLocation)id, (World)worldIn);
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_180482_a(worldIn.func_175649_E(pos), null);
            if (entity instanceof EntityMaid) {
                boolean playerCanChangeModel;
                boolean bl = playerCanChangeModel = playerIn.func_184812_l_() || !GeneralConfig.MAID_CONFIG.maidCannotChangeModel;
                if (playerCanChangeModel) {
                    garageKit.setData(id.toString(), garageKit.getFacing(), ((EntityMaid)entity).getModelId(), new NBTTagCompound());
                }
                return true;
            }
        }
        garageKit.setData(id.toString(), garageKit.getFacing(), null, entity.func_189511_e(new NBTTagCompound()));
        return true;
    }

    public static enum NBT {
        ENTITY_ID("EntityId"),
        FACING("Facing"),
        MODEL_ID("ModelId"),
        MAID_DATA("MaidData");

        private String name;

        private NBT(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

