/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityStatue;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStatue
extends Block {
    public BlockStatue() {
        super(Material.field_151571_B);
        this.func_149663_c("touhou_little_maid.statue");
        this.func_149711_c(1.0f);
        this.func_149752_b(2000.0f);
        this.setRegistryName("statue");
        this.func_149672_a(SoundType.field_185849_b);
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityStatue();
    }

    public void func_176208_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof TileEntityStatue) {
            this.restoreClayBlock(worldIn, pos, (TileEntityStatue)te);
            if (!player.func_184812_l_()) {
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Blocks.field_150435_aG));
            }
        }
    }

    private void restoreClayBlock(@Nonnull World worldIn, @Nonnull BlockPos pos, TileEntityStatue statue) {
        List<BlockPos> posList = statue.getAllBlocks();
        for (BlockPos storagePos : posList) {
            TileEntity tileEntity;
            if (storagePos.equals((Object)pos) || !((tileEntity = worldIn.func_175625_s(storagePos)) instanceof TileEntityStatue)) continue;
            worldIn.func_175656_a(storagePos, Blocks.field_150435_aG.func_176223_P());
        }
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nullable RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return new ItemStack(Blocks.field_150435_aG);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, @Nonnull BlockPos pos, @Nonnull ParticleManager manager) {
        this.addBlockDestroyEffects(world, pos, Blocks.field_150435_aG.func_176223_P(), manager);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, World world, RayTraceResult target, @Nonnull ParticleManager manager) {
        this.addBlockHitEffects(world, target.func_178782_a(), target.field_178784_b, Blocks.field_150435_aG.func_176223_P(), manager);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockDestroyEffects(World world, BlockPos pos, IBlockState state, ParticleManager manager) {
        if (!state.func_177230_c().isAir(state, (IBlockAccess)world, pos) && !state.func_177230_c().addDestroyEffects(world, pos, manager)) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, new int[]{Block.func_176210_f((IBlockState)state)});
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockHitEffects(World world, BlockPos pos, EnumFacing side, IBlockState iblockstate, ParticleManager manager) {
        Random rand = Block.RANDOM;
        if (iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            AxisAlignedBB axisalignedbb = iblockstate.func_185900_c((IBlockAccess)world, pos);
            double d0 = (double)i + rand.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
            double d1 = (double)j + rand.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
            double d2 = (double)k + rand.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
            if (side == EnumFacing.DOWN) {
                d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
            }
            if (side == EnumFacing.UP) {
                d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
            }
            if (side == EnumFacing.NORTH) {
                d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
            }
            if (side == EnumFacing.SOUTH) {
                d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
            }
            if (side == EnumFacing.WEST) {
                d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
            }
            if (side == EnumFacing.EAST) {
                d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
            }
            manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149637_q(@Nonnull IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }
}

