/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityTombstone;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class BlockTombstone
extends BlockHorizontal {
    public BlockTombstone() {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.func_149663_c("touhou_little_maid.tombstone");
        this.setRegistryName("tombstone");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
    }

    public static void spawnAsEntity(World worldIn, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        if (!worldIn.field_72995_K && !stack.func_190926_b() && worldIn.func_82736_K().func_82766_b("doTileDrops") && !worldIn.restoringBlockSnapshots) {
            if (((Boolean)captureDrops.get()).booleanValue()) {
                ((NonNullList)capturedDrops.get()).add((Object)stack);
                return;
            }
            EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
            worldIn.func_72838_d((Entity)entityitem);
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityTombstone();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityTombstone) {
            TileEntityTombstone tombstone = (TileEntityTombstone)te;
            for (int i = 0; i < tombstone.handler.getSlots(); ++i) {
                BlockTombstone.spawnAsEntity(worldIn, pos, tombstone.handler.getStackInSlot(i));
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        worldIn.func_175698_g(pos);
        if (!worldIn.field_72995_K) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.tombstone.on_block_activated", new Object[0]));
        }
        return true;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

