/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation;

import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.InnerAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import javax.script.Bindings;
import javax.script.ScriptException;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class CustomJsAnimationManger {
    private static final Map<ResourceLocation, Object> CUSTOM_ANIMATION_MAP = Maps.newHashMap();

    @Nullable
    public static List<Object> getCustomAnimation(ZipFile zipFile, IModelInfo item) {
        ArrayList animations = Lists.newArrayList();
        if (item.getAnimation() != null && item.getAnimation().size() > 0) {
            for (ResourceLocation res : item.getAnimation()) {
                Object animation = CustomJsAnimationManger.getCustomAnimation(zipFile, res);
                if (animation == null) continue;
                animations.add(animation);
            }
            return animations;
        }
        return null;
    }

    @Nullable
    public static List<Object> getCustomAnimation(IModelInfo item) {
        ArrayList animations = Lists.newArrayList();
        if (item.getAnimation() != null && item.getAnimation().size() > 0) {
            for (ResourceLocation res : item.getAnimation()) {
                Object animation = CustomJsAnimationManger.getCustomAnimation(res);
                if (animation == null) continue;
                animations.add(animation);
            }
            return animations;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Object getCustomAnimation(ZipFile zipFile, @Nullable ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            return null;
        }
        if (CUSTOM_ANIMATION_MAP.containsKey(resourceLocation)) {
            return CUSTOM_ANIMATION_MAP.get(resourceLocation);
        }
        if (InnerAnimation.getInnerAnimation().containsKey(resourceLocation)) {
            return InnerAnimation.getInnerAnimation().get(resourceLocation);
        }
        ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", resourceLocation.func_110624_b(), resourceLocation.func_110623_a()));
        if (entry == null) {
            return null;
        }
        try (InputStream stream = zipFile.getInputStream(entry);){
            Bindings bindings = CommonProxy.NASHORN.createBindings();
            Object scriptObject = CommonProxy.NASHORN.eval(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), bindings);
            CUSTOM_ANIMATION_MAP.put(resourceLocation, scriptObject);
            Object object = scriptObject;
            return object;
        }
        catch (IOException | ScriptException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Object getCustomAnimation(@Nullable ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            return null;
        }
        if (CUSTOM_ANIMATION_MAP.containsKey(resourceLocation)) {
            return CUSTOM_ANIMATION_MAP.get(resourceLocation);
        }
        if (InnerAnimation.getInnerAnimation().containsKey(resourceLocation)) {
            return InnerAnimation.getInnerAnimation().get(resourceLocation);
        }
        InputStream stream = null;
        try {
            Bindings bindings = CommonProxy.NASHORN.createBindings();
            stream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b();
            Object scriptObject = CommonProxy.NASHORN.eval(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), bindings);
            CUSTOM_ANIMATION_MAP.put(resourceLocation, scriptObject);
            Object object = scriptObject;
            IOUtils.closeQuietly((InputStream)stream);
            return object;
        }
        catch (IOException | ScriptException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
        return null;
    }

    public static void clearAll() {
        CUSTOM_ANIMATION_MAP.clear();
    }
}

