/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.script;

import com.github.tartaricacid.touhoulittlemaid.api.animation.IMaidData;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.WorldWrapper;
import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityTrolley;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityMaidVehicle;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityMarisaBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPortableAudio;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.BiomeCacheUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;

public final class EntityMaidWrapper
implements IMaidData {
    private final WorldWrapper world = new WorldWrapper();
    private float swingProgress;
    private boolean isRiding;
    private EntityMaid maid;

    public void setData(EntityMaid maid, float swingProgress, boolean isRiding) {
        this.maid = maid;
        this.swingProgress = swingProgress;
        this.isRiding = isRiding;
        this.world.setData(maid.field_70170_p);
    }

    public void clearData() {
        this.maid = null;
        this.world.clearData();
    }

    @Override
    public WorldWrapper getWorld() {
        return this.world;
    }

    @Override
    public String getTask() {
        return this.maid.getTask().getUid().func_110623_a();
    }

    @Override
    public boolean hasHelmet() {
        return !this.maid.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b();
    }

    @Override
    public String getHelmet() {
        ResourceLocation res = this.maid.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasChestPlate() {
        return !this.maid.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
    }

    @Override
    public String getChestPlate() {
        ResourceLocation res = this.maid.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasLeggings() {
        return !this.maid.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b();
    }

    @Override
    public String getLeggings() {
        ResourceLocation res = this.maid.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasBoots() {
        return !this.maid.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b();
    }

    @Override
    public String getBoots() {
        ResourceLocation res = this.maid.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasItemMainhand() {
        return this.maid.func_184614_ca().func_190926_b();
    }

    @Override
    public String getItemMainhand() {
        ResourceLocation res = this.maid.func_184614_ca().func_77973_b().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasItemOffhand() {
        return this.maid.func_184592_cb().func_190926_b();
    }

    @Override
    public String getItemOffhand() {
        ResourceLocation res = this.maid.func_184592_cb().func_77973_b().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean isBegging() {
        return this.maid.isBegging();
    }

    @Override
    public boolean isSwingingArms() {
        return this.maid.isSwingingArms();
    }

    @Override
    public boolean isRiding() {
        return this.isRiding;
    }

    @Override
    public boolean isSitting() {
        return this.maid.func_70906_o();
    }

    @Override
    public boolean hasBackpack() {
        return this.maid.getBackLevel() != EntityMaid.EnumBackPackLevel.EMPTY;
    }

    @Override
    public int getBackpackLevel() {
        return this.maid.getBackLevel().getLevel();
    }

    @Override
    public boolean hasSasimono() {
        return this.maid.hasSasimono();
    }

    @Override
    public boolean inWater() {
        return this.maid.func_70090_H();
    }

    @Override
    public boolean inRain() {
        return this.maid.field_70170_p.func_175727_C(this.maid.func_180425_c());
    }

    @Override
    public String getAtBiome() {
        ResourceLocation res = BiomeCacheUtil.getCacheBiome((Entity)this.maid).getRegistryName();
        if (res != null) {
            return res.func_110623_a();
        }
        return "";
    }

    @Override
    public String getAtBiomeTemp() {
        return BiomeCacheUtil.getCacheBiome((Entity)this.maid).func_150561_m().name();
    }

    @Override
    public boolean isHoldTrolley() {
        return this.maid.func_184179_bs() instanceof AbstractEntityTrolley;
    }

    @Override
    public boolean isRidingMarisaBroom() {
        return this.maid.func_184179_bs() instanceof EntityMarisaBroom || this.maid.isDebugBroomShow;
    }

    @Override
    public boolean isRidingPlayer() {
        return this.maid.func_184187_bx() instanceof EntityPlayer;
    }

    @Override
    public boolean isHoldVehicle() {
        return this.maid.func_184179_bs() instanceof EntityMaidVehicle;
    }

    @Override
    public boolean isPortableAudioPlay() {
        if (this.maid.func_184179_bs() instanceof EntityPortableAudio) {
            EntityPortableAudio audio = (EntityPortableAudio)this.maid.func_184179_bs();
            return audio.isPlaying();
        }
        return false;
    }

    @Override
    public boolean isSwingLeftHand() {
        return this.maid.field_184622_au == EnumHand.OFF_HAND;
    }

    @Override
    public float getSwingProgress() {
        return this.swingProgress;
    }

    @Override
    public float[] getLeftHandRotation() {
        if (this.maid.func_184179_bs() instanceof EntityMaidVehicle) {
            return ((EntityMaidVehicle)this.maid.func_184179_bs()).getMaidHandRotation(EnumHand.OFF_HAND);
        }
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    @Override
    public float[] getRightHandRotation() {
        if (this.maid.func_184179_bs() instanceof EntityMaidVehicle) {
            return ((EntityMaidVehicle)this.maid.func_184179_bs()).getMaidHandRotation(EnumHand.MAIN_HAND);
        }
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    @Override
    public int getDim() {
        return this.maid.field_71093_bK;
    }

    @Override
    public long getSeed() {
        return Math.abs(this.maid.func_110124_au().getLeastSignificantBits());
    }

    @Override
    public float getHealth() {
        return this.maid.func_110143_aJ();
    }

    @Override
    public float getMaxHealth() {
        return this.maid.func_110138_aP();
    }

    @Override
    public double getArmorValue() {
        return this.maid.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e();
    }

    @Override
    public boolean onHurt() {
        return this.maid.field_70737_aN > 0;
    }

    @Override
    public boolean isSleep() {
        return this.maid.isSleep();
    }

    @Override
    public int getFavorability() {
        return this.maid.getFavorability();
    }

    @Override
    public boolean isOnGround() {
        return this.maid.field_70122_E;
    }
}

