/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.audio.music;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.neteasemusic.NetEaseMusic;
import com.github.tartaricacid.touhoulittlemaid.api.neteasemusic.WebApi;
import com.github.tartaricacid.touhoulittlemaid.client.audio.music.ExtraMusicList;
import com.github.tartaricacid.touhoulittlemaid.client.audio.music.MusicJsonInfo;
import com.github.tartaricacid.touhoulittlemaid.client.audio.music.NetEaseMusicList;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public final class MusicManger {
    public static final WebApi NET_EASE_WEB_API = new NetEaseMusic().getApi();
    private static final Path ROOT_FOLDER = Paths.get(System.getProperty("user.home"), new String[0]).resolve("touhou_little_maid");
    private static final Path LOCAL_MUSIC_LIST_FILE = ROOT_FOLDER.resolve("music_list");
    private static final ResourceLocation MUSIC_JSON = new ResourceLocation("touhou_little_maid", "music.json");
    private static final ThreadPoolExecutor POOL = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private static final MusicJsonInfo DEFAULT_INFO = MusicJsonInfo.getDefaultInstance();
    public static CopyOnWriteArrayList<NetEaseMusicList> MUSIC_LIST_GROUP = Lists.newCopyOnWriteArrayList();

    public static void loadMusicList() {
        MUSIC_LIST_GROUP.clear();
        MusicManger.checkLocalFile();
        try {
            List resourceList = Minecraft.func_71410_x().func_110442_L().func_135056_b(MUSIC_JSON);
            for (IResource resource : resourceList) {
                MusicManger.readSingleJsonFile(resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void checkLocalFile() {
        if (!ROOT_FOLDER.toFile().isDirectory()) {
            try {
                Files.createDirectories(ROOT_FOLDER, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
        }
        if (!LOCAL_MUSIC_LIST_FILE.toFile().isFile()) {
            try {
                LOCAL_MUSIC_LIST_FILE.toFile().createNewFile();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            try {
                List lists = FileUtils.readLines((File)LOCAL_MUSIC_LIST_FILE.toFile(), (Charset)StandardCharsets.UTF_8);
                for (String id : lists) {
                    long i = Long.parseUnsignedLong(id);
                    MusicManger.insertMusicListInfo(i, DEFAULT_INFO);
                }
            }
            catch (IOException | NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    private static void readSingleJsonFile(IResource resource) {
        try (InputStream stream = resource.func_110527_b();){
            List infos = (List)CommonProxy.GSON.fromJson(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), new TypeToken<List<MusicJsonInfo>>(){}.getType());
            for (MusicJsonInfo info : infos) {
                for (long id : info.getContent().getPlayList()) {
                    MusicManger.insertMusicListInfo(id, info);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean insertMusicListInfo(long id, MusicJsonInfo info) {
        for (NetEaseMusicList list : MUSIC_LIST_GROUP) {
            if (id != list.getListId()) continue;
            return false;
        }
        POOL.submit(() -> {
            try {
                TouhouLittleMaid.LOGGER.info("Obtaining {} NetEase cloud music playlist information", (Object)id);
                String rep = NET_EASE_WEB_API.list(id);
                NetEaseMusicList neteaseMusicList = (NetEaseMusicList)CommonProxy.GSON.fromJson(rep, NetEaseMusicList.class);
                if (neteaseMusicList.getCode() != 200) {
                    TouhouLittleMaid.LOGGER.error(rep);
                } else {
                    neteaseMusicList.setMusicJsonInfo(info);
                    neteaseMusicList.getPlayList().deco();
                    neteaseMusicList.setListId(id);
                    int count = neteaseMusicList.getPlayList().getTrackCount();
                    if (count > 0) {
                        MUSIC_LIST_GROUP.add(neteaseMusicList);
                        TouhouLittleMaid.LOGGER.info("{} NetEase cloud music information obtained successfully", (Object)id);
                        Thread.sleep((3L + Math.round(Math.random() * 2.0)) * 1000L);
                        int size = Math.min(neteaseMusicList.getPlayList().getTrackIds().size(), GeneralConfig.MUSIC_CONFIG.musicListCount);
                        if (count < size) {
                            long[] ids = new long[size - count];
                            for (int i = count; i < size; ++i) {
                                ids[i - count] = neteaseMusicList.getPlayList().getTrackIds().get(i).getId();
                            }
                            String extraTrackInfo = NET_EASE_WEB_API.songs(ids);
                            ExtraMusicList extraTracks = (ExtraMusicList)CommonProxy.GSON.fromJson(extraTrackInfo, ExtraMusicList.class);
                            if (extraTracks.getCode() == 200) {
                                neteaseMusicList.getPlayList().getTracks().addAll(extraTracks.getTracks());
                                neteaseMusicList.getPlayList().deco();
                            }
                        }
                    } else {
                        TouhouLittleMaid.LOGGER.info("{} Music list track number is 0", (Object)id);
                    }
                }
                Thread.sleep((15L + Math.round(Math.random() * 15.0)) * 1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return true;
    }

    public static boolean addSingleList(long id) {
        if (MusicManger.insertMusicListInfo(id, DEFAULT_INFO)) {
            try {
                List lines = FileUtils.readLines((File)LOCAL_MUSIC_LIST_FILE.toFile(), (Charset)StandardCharsets.UTF_8);
                lines.add(String.valueOf(id));
                FileUtils.writeLines((File)LOCAL_MUSIC_LIST_FILE.toFile(), (String)StandardCharsets.UTF_8.toString(), (Collection)lines);
                return true;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return false;
    }

    public static boolean removeSingleList(long id) {
        try {
            List lines = FileUtils.readLines((File)LOCAL_MUSIC_LIST_FILE.toFile(), (Charset)StandardCharsets.UTF_8);
            if (lines.remove(String.valueOf(id))) {
                MUSIC_LIST_GROUP.removeIf(netEaseMusicList -> netEaseMusicList.getListId() == id);
                FileUtils.writeLines((File)LOCAL_MUSIC_LIST_FILE.toFile(), (String)StandardCharsets.UTF_8.toString(), (Collection)lines);
                return true;
            }
        }
        catch (IOException | NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static long getTaskCount() {
        return POOL.getTaskCount();
    }

    public static long getCompletedTaskCount() {
        return POOL.getCompletedTaskCount();
    }
}

