/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.audio.music;

import com.github.tartaricacid.touhoulittlemaid.client.audio.music.MusicJsonInfo;
import com.google.common.collect.Lists;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

@SideOnly(value=Side.CLIENT)
public class NetEaseMusicList {
    @SerializedName(value="result", alternate={"playlist"})
    private PlayList playList;
    @SerializedName(value="code")
    private int code;
    @Expose(deserialize=false)
    private long listId;
    @Expose(deserialize=false)
    private MusicJsonInfo musicJsonInfo;

    public PlayList getPlayList() {
        return this.playList;
    }

    public int getCode() {
        return this.code;
    }

    public MusicJsonInfo getMusicJsonInfo() {
        return this.musicJsonInfo;
    }

    public void setMusicJsonInfo(MusicJsonInfo musicJsonInfo) {
        this.musicJsonInfo = musicJsonInfo;
    }

    public long getListId() {
        return this.listId;
    }

    public void setListId(long listId) {
        this.listId = listId;
    }

    public class PlayList {
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="trackCount")
        private int trackCount;
        @SerializedName(value="playCount")
        private int playCount;
        @SerializedName(value="creator")
        private Creator creator;
        @SerializedName(value="createTime")
        private long createTime;
        @SerializedName(value="subscribedCount")
        private int subscribedCount;
        @SerializedName(value="shareCount")
        private int shareCount;
        @SerializedName(value="tags")
        private List<String> tags = Lists.newArrayList();
        @SerializedName(value="description")
        private String description = "";
        @SerializedName(value="tracks")
        private List<Track> tracks;
        @SerializedName(value="trackIds")
        private List<TrackId> trackIds;
        @Expose(deserialize=false)
        private String creatorName;
        @Expose(deserialize=false)
        private String formatCreateTime;
        @Expose(deserialize=false)
        private String tagStr;

        public String getName() {
            return this.name;
        }

        public int getTrackCount() {
            return this.trackCount;
        }

        public int getPlayCount() {
            return this.playCount;
        }

        public String getCreator() {
            return this.creatorName;
        }

        public String getCreateTime() {
            return this.formatCreateTime;
        }

        public int getSubscribedCount() {
            return this.subscribedCount;
        }

        public int getShareCount() {
            return this.shareCount;
        }

        public String getTags() {
            return this.tagStr;
        }

        public String getDescription() {
            return this.description;
        }

        public List<Track> getTracks() {
            return this.tracks;
        }

        public List<TrackId> getTrackIds() {
            return this.trackIds;
        }

        public PlayList deco() {
            this.creatorName = this.creator.nickname;
            this.formatCreateTime = DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd");
            this.tagStr = StringUtils.join(this.tags, (char)'/');
            this.tracks.forEach(Track::deco);
            this.trackCount = this.tracks.size();
            this.description = this.description == null ? "" : this.description;
            return this;
        }

        public class TrackId {
            @SerializedName(value="id")
            private long id;

            public long getId() {
                return this.id;
            }
        }
    }

    private static class Album {
        @SerializedName(value="name")
        private String name;

        private Album() {
        }
    }

    private static class Artist {
        @SerializedName(value="name")
        private String name;

        private Artist() {
        }
    }

    private static class Creator {
        @SerializedName(value="nickname")
        private String nickname;

        private Creator() {
        }
    }

    public static class Track {
        @SerializedName(value="id")
        private long id;
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="artists", alternate={"ar"})
        private List<Artist> artists;
        @SerializedName(value="album", alternate={"al"})
        private Album album;
        @SerializedName(value="duration", alternate={"dt"})
        private int duration;
        @Expose(deserialize=false)
        private String artistStr;
        @Expose(deserialize=false)
        private String albumName;
        @Expose(deserialize=false)
        private String time;
        @Expose(deserialize=false)
        private int timeInTicks;

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getArtists() {
            return this.artistStr;
        }

        public String getAlbum() {
            return this.albumName;
        }

        public String getDuration() {
            return this.time;
        }

        public int getDurationInTicks() {
            return this.timeInTicks;
        }

        public Track deco() {
            ArrayList artistsTmp = Lists.newArrayList();
            this.artists.forEach(artist -> artistsTmp.add(((Artist)artist).name));
            this.artistStr = StringUtils.join((Iterable)artistsTmp, (char)'/');
            this.albumName = this.album.name;
            int min = this.duration / 60000;
            int sec = this.duration % 60000 / 1000;
            String minStr = min <= 9 ? "0" + min : "" + min;
            String secStr = sec <= 9 ? "0" + sec : "" + sec;
            this.time = String.format("%s:%s", minStr, secStr);
            this.timeInTicks = this.duration / 50;
            return this;
        }
    }
}

