/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.item.PerspectiveBakedModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.item.ReplaceableBakedModel;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Side.CLIENT})
public class BakeModelEvent {
    private static List<Pair<ModelResourceLocation, ModelResourceLocation>> PERSPECTIVE_MODEL_LIST = Lists.newArrayList();
    private static List<Triple<ModelResourceLocation, ModelResourceLocation, Supplier<Boolean>>> REPLACEABLE_MODEL_LIST = Lists.newArrayList();

    @SubscribeEvent
    public static void onBakedModel(ModelBakeEvent event) {
        for (Pair<ModelResourceLocation, ModelResourceLocation> pair : PERSPECTIVE_MODEL_LIST) {
            event.getModelRegistry().func_82595_a(pair.getLeft(), (Object)new PerspectiveBakedModel((IBakedModel)event.getModelRegistry().func_82594_a(pair.getLeft()), (IBakedModel)event.getModelRegistry().func_82594_a(pair.getRight())));
        }
        for (Triple triple : REPLACEABLE_MODEL_LIST) {
            event.getModelRegistry().func_82595_a(triple.getLeft(), (Object)new ReplaceableBakedModel((IBakedModel)event.getModelRegistry().func_82594_a(triple.getLeft()), (IBakedModel)event.getModelRegistry().func_82594_a(triple.getMiddle()), (Supplier)triple.getRight()));
        }
    }

    public static void addPerspectiveModel(ModelResourceLocation model2d, ModelResourceLocation model3d) {
        PERSPECTIVE_MODEL_LIST.add((Pair<ModelResourceLocation, ModelResourceLocation>)Pair.of((Object)model2d, (Object)model3d));
    }

    public static void addReplaceableModel(ModelResourceLocation rawModel, ModelResourceLocation replacedModel, Supplier<Boolean> isReplace) {
        REPLACEABLE_MODEL_LIST.add((Triple<ModelResourceLocation, ModelResourceLocation, Supplier<Boolean>>)Triple.of((Object)rawModel, (Object)replacedModel, isReplace));
    }
}

