/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemKappaCompass;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Side.CLIENT})
public class KappaCompassRenderEvent {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/particle/flag.png");
    private static List<BlockPos> TMP_DISPLAY_POS = Lists.newArrayList();
    private static ItemKappaCompass.Mode TMP_DISPLAY_MODE = ItemKappaCompass.Mode.NONE;
    private static long TIME;

    @SubscribeEvent
    public static void onRender(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (Minecraft.func_71386_F() <= TIME + TimeUnit.SECONDS.toMillis(9L) && TMP_DISPLAY_POS.size() > 0 && TMP_DISPLAY_MODE != ItemKappaCompass.Mode.NONE) {
            KappaCompassRenderEvent.renderWorldPos(mc, TMP_DISPLAY_POS, TMP_DISPLAY_MODE);
        }
        ItemStack mainStack = mc.field_71439_g.func_184614_ca();
        ItemStack offStack = mc.field_71439_g.func_184592_cb();
        if (mainStack.func_77973_b() != MaidItems.KAPPA_COMPASS && offStack.func_77973_b() != MaidItems.KAPPA_COMPASS) {
            return;
        }
        List<BlockPos> blockPosList = ItemKappaCompass.getPos(mainStack);
        ItemKappaCompass.Mode mode = ItemKappaCompass.getMode(mainStack);
        if (blockPosList.size() == 0 || mode == ItemKappaCompass.Mode.NONE) {
            blockPosList = ItemKappaCompass.getPos(offStack);
            mode = ItemKappaCompass.getMode(offStack);
            if (blockPosList.size() == 0 || mode == ItemKappaCompass.Mode.NONE) {
                return;
            }
        }
        KappaCompassRenderEvent.renderWorldPos(mc, blockPosList, mode);
    }

    public static void setTmpDisplay(List<BlockPos> tmpPos, ItemKappaCompass.Mode tmpMode) {
        TMP_DISPLAY_POS = tmpPos;
        TMP_DISPLAY_MODE = tmpMode;
        TIME = Minecraft.func_71386_F();
    }

    private static void renderWorldPos(Minecraft mc, List<BlockPos> blockPosList, ItemKappaCompass.Mode mode) {
        Vec3d playerVec3d = new Vec3d(-TileEntityRendererDispatcher.field_147554_b, -TileEntityRendererDispatcher.field_147555_c + 1.5, -TileEntityRendererDispatcher.field_147552_d);
        float yaw = TileEntityRendererDispatcher.field_147556_a.field_147562_h;
        float pitch = TileEntityRendererDispatcher.field_147556_a.field_147563_i;
        int size = blockPosList.size();
        GlStateManager.func_179147_l();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        GlStateManager.func_179117_G();
        switch (mode) {
            case SINGLE_POINT: {
                List<BlockPos> singlePos = Collections.singletonList(blockPosList.get(size - 1));
                KappaCompassRenderEvent.drawRangeLine(playerVec3d, blockPosList, 8.0f, -5592576);
                KappaCompassRenderEvent.drawRangeLine(playerVec3d, blockPosList, 16.0f, -5636096);
                KappaCompassRenderEvent.drawPosInfo(mc, playerVec3d, singlePos, yaw, pitch);
                KappaCompassRenderEvent.renderFlag(playerVec3d, yaw, pitch, singlePos);
                break;
            }
            case MULTI_POINT_CLOSURE: {
                KappaCompassRenderEvent.drawPathLine(playerVec3d, blockPosList);
                KappaCompassRenderEvent.drawClosurePathLine(playerVec3d, blockPosList.get(0), blockPosList.get(size - 1));
                if (size < 9) {
                    KappaCompassRenderEvent.drawRangeLine(playerVec3d, blockPosList, 15.0f, -11184896);
                }
                KappaCompassRenderEvent.drawPosInfo(mc, playerVec3d, blockPosList, yaw, pitch);
                KappaCompassRenderEvent.renderFlag(playerVec3d, yaw, pitch, blockPosList);
                break;
            }
            case MULTI_POINT_REENTRY: {
                KappaCompassRenderEvent.drawPathLine(playerVec3d, blockPosList);
                if (size < 9) {
                    KappaCompassRenderEvent.drawRangeLine(playerVec3d, blockPosList, 15.0f, -11184896);
                }
                KappaCompassRenderEvent.drawPosInfo(mc, playerVec3d, blockPosList, yaw, pitch);
                KappaCompassRenderEvent.renderFlag(playerVec3d, yaw, pitch, blockPosList);
                break;
            }
            case SET_RANGE: {
                ArrayList posListTmp = Lists.newArrayList();
                if (size == 1) {
                    KappaCompassRenderEvent.drawRangeLine(playerVec3d, blockPosList, 15.0f, -11184896);
                    posListTmp.add(blockPosList.get(size - 1));
                }
                if (size >= 2) {
                    posListTmp.add(blockPosList.get(size - 1));
                    posListTmp.add(blockPosList.get(size - 2));
                    KappaCompassRenderEvent.drawCubeArea(playerVec3d, (BlockPos)posListTmp.get(0), (BlockPos)posListTmp.get(1));
                }
                KappaCompassRenderEvent.drawPosInfo(mc, playerVec3d, posListTmp, yaw, pitch);
                KappaCompassRenderEvent.renderFlag(playerVec3d, yaw, pitch, posListTmp);
                break;
            }
        }
        GlStateManager.func_179117_G();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private static void drawPosInfo(Minecraft mc, Vec3d vec3d, List<BlockPos> blockPosList, float yaw, float pitch) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)vec3d.field_72450_a, (double)vec3d.field_72448_b, (double)vec3d.field_72449_c);
        for (int i = 0; i < blockPosList.size(); ++i) {
            BlockPos pos = blockPosList.get(i);
            KappaCompassRenderEvent.drawNameplate(mc.field_71466_p, String.format("\u00a7l\u00a7a[%d, %d, %d]", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() - 0.25f, (float)pos.func_177952_p() + 0.5f, 0, yaw, pitch, 0.05f);
            KappaCompassRenderEvent.drawNameplate(mc.field_71466_p, String.valueOf((char)(i + 65)), (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() - 0.25f, (float)pos.func_177952_p() + 0.5f, -10, yaw, pitch, 0.1f);
        }
        GlStateManager.func_179121_F();
    }

    private static void drawRangeLine(Vec3d vec3d, List<BlockPos> blockPosList, float range, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179094_E();
        BlockPos posLast = blockPosList.get(blockPosList.size() - 1);
        GlStateManager.func_179137_b((double)vec3d.field_72450_a, (double)vec3d.field_72448_b, (double)vec3d.field_72449_c);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        GlStateManager.func_179137_b((double)((double)posLast.func_177958_n() + 0.5), (double)((double)posLast.func_177956_o() - 0.75), (double)((double)posLast.func_177952_p() + 0.5));
        GlStateManager.func_179152_a((float)range, (float)range, (float)range);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179148_o((int)RenderHelper.SPHERE_LINE);
        GlStateManager.func_179121_F();
        GlStateManager.func_179117_G();
    }

    private static void drawClosurePathLine(Vec3d vec3d, BlockPos startPos, BlockPos endPos) {
        boolean isFar;
        if (startPos.equals((Object)endPos)) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)vec3d.field_72450_a, (double)vec3d.field_72448_b, (double)vec3d.field_72449_c);
        GlStateManager.func_179114_b((float)360.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_187441_d((float)3.0f);
        boolean bl = isFar = startPos.func_177951_i((Vec3i)endPos) > Math.pow(16.0, 2.0);
        if (isFar) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)255.0f);
            GL11.glLineStipple((int)5, (short)21845);
            GL11.glEnable((int)2852);
        } else {
            GlStateManager.func_179131_c((float)255.0f, (float)0.0f, (float)0.0f, (float)255.0f);
        }
        GlStateManager.func_187447_r((int)3);
        GL11.glVertex3d((double)((double)startPos.func_177958_n() + 0.5), (double)((double)startPos.func_177956_o() - 0.75), (double)((double)startPos.func_177952_p() + 0.5));
        GL11.glVertex3d((double)((double)endPos.func_177958_n() + 0.5), (double)((double)endPos.func_177956_o() - 0.75), (double)((double)endPos.func_177952_p() + 0.5));
        GlStateManager.func_187437_J();
        if (isFar) {
            GL11.glDisable((int)2852);
        }
        GlStateManager.func_179121_F();
    }

    private static void drawCubeArea(Vec3d vec3d, BlockPos pos1, BlockPos pos2) {
        int i;
        if (pos1.equals((Object)pos2)) {
            return;
        }
        BlockPos distancePos = new BlockPos(Math.abs(pos1.func_177958_n() - pos2.func_177958_n()) + 1, Math.abs(pos1.func_177956_o() - pos2.func_177956_o()) + 1, Math.abs(pos1.func_177952_p() - pos2.func_177952_p()) + 1);
        BlockPos originPos = new BlockPos(Math.min(pos1.func_177958_n(), pos2.func_177958_n()), Math.min(pos1.func_177956_o(), pos2.func_177956_o()), Math.min(pos1.func_177952_p(), pos2.func_177952_p()));
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)vec3d.field_72450_a, (double)vec3d.field_72448_b, (double)vec3d.field_72449_c);
        GlStateManager.func_179137_b((double)originPos.func_177958_n(), (double)((double)originPos.func_177956_o() - 1.5), (double)originPos.func_177952_p());
        GlStateManager.func_187441_d((float)3.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (i = 0; i <= distancePos.func_177958_n(); ++i) {
            bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b((double)i, 0.0, (double)distancePos.func_177952_p()).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b((double)i, 0.0, 0.0).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b((double)i, (double)distancePos.func_177956_o(), 0.0).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b((double)i, (double)distancePos.func_177956_o(), (double)distancePos.func_177952_p()).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b((double)i, 0.0, (double)distancePos.func_177952_p()).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
        }
        for (i = 0; i <= distancePos.func_177956_o(); ++i) {
            bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(0.0, (double)i, (double)distancePos.func_177952_p()).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(0.0, (double)i, 0.0).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b((double)distancePos.func_177958_n(), (double)i, 0.0).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b((double)distancePos.func_177958_n(), (double)i, (double)distancePos.func_177952_p()).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(0.0, (double)i, (double)distancePos.func_177952_p()).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
        }
        for (i = 0; i <= distancePos.func_177952_p(); ++i) {
            bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(0.0, (double)distancePos.func_177956_o(), (double)i).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, (double)i).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b((double)distancePos.func_177958_n(), 0.0, (double)i).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b((double)distancePos.func_177958_n(), (double)distancePos.func_177956_o(), (double)i).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(0.0, (double)distancePos.func_177956_o(), (double)i).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179121_F();
    }

    private static void drawPathLine(Vec3d vec3d, List<BlockPos> blockPosList) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)vec3d.field_72450_a, (double)vec3d.field_72448_b, (double)vec3d.field_72449_c);
        GlStateManager.func_179114_b((float)360.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)255.0f, (float)0.0f, (float)0.0f, (float)255.0f);
        GlStateManager.func_187441_d((float)3.0f);
        GlStateManager.func_187447_r((int)3);
        for (BlockPos pos : blockPosList) {
            GL11.glVertex3d((double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() - 0.75), (double)((double)pos.func_177952_p() + 0.5));
        }
        GlStateManager.func_187437_J();
        GlStateManager.func_179121_F();
    }

    public static void renderFlag(Vec3d vec3d, float yaw, float pitch, List<BlockPos> blockPosList) {
        for (BlockPos pos : blockPosList) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)vec3d.field_72450_a, (double)vec3d.field_72448_b, (double)vec3d.field_72449_c);
            GlStateManager.func_179109_b((float)((float)pos.func_177958_n() + 0.5f), (float)((float)pos.func_177956_o() - 1.0f), (float)((float)pos.func_177952_p() + 0.5f));
            GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.25, 0.25, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(0.25, -0.25, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(-0.25, -0.25, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-0.25, 0.25, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
    }

    public static void drawNameplate(FontRenderer fontRendererIn, String str, float x, float y, float z, int verticalShift, float viewerYaw, float viewerPitch, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-viewerYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)viewerPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int i = fontRendererIn.func_78256_a(str) / 2;
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)(-i - 1), (double)(-1 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b((double)(-i - 1), (double)(8 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b((double)(i + 1), (double)(8 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b((double)(i + 1), (double)(-1 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        fontRendererIn.func_78276_b(str, -fontRendererIn.func_78256_a(str) / 2, verticalShift, 0x20FFFFFF);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        fontRendererIn.func_78276_b(str, -fontRendererIn.func_78256_a(str) / 2, verticalShift, -1);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

