/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.api.event.RenderMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resources.ModelData;
import com.github.tartaricacid.touhoulittlemaid.client.resources.PlayerMaidResources;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Side.CLIENT})
public class PlayerMaidRenderEvent {
    private static final String PLAYER_NAME_PREFIX = "=>";

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderPlayerNamedMaid(RenderMaidEvent event) {
        String nameTag = event.getMaid().func_95999_t();
        if (StringUtils.isNotBlank((CharSequence)nameTag) && nameTag.startsWith(PLAYER_NAME_PREFIX)) {
            ModelData data = event.getModelData();
            String name = nameTag.substring(2);
            data.setModel(PlayerMaidResources.getPlayerMaidModel(name));
            data.setAnimations(PlayerMaidResources.getPlayerMaidAnimations());
            data.setInfo(PlayerMaidResources.getPlayerMaidInfo(name));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderEncryptNamedMaid(RenderMaidEvent event) {
        String name = event.getMaid().func_95999_t();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            CustomResourcesLoader.MAID_MODEL.getEasterEggEncryptTagModel(DigestUtils.sha1Hex((String)name)).ifPresent(data -> PlayerMaidRenderEvent.modelDataSet(event, data));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderNormalNamedMaid(RenderMaidEvent event) {
        String name = event.getMaid().func_95999_t();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            CustomResourcesLoader.MAID_MODEL.getEasterEggNormalTagModel(name).ifPresent(data -> PlayerMaidRenderEvent.modelDataSet(event, data));
        }
    }

    private static void modelDataSet(RenderMaidEvent event, ModelData data) {
        ModelData rawData = event.getModelData();
        rawData.setModel(data.getModel());
        rawData.setInfo(data.getInfo());
        if (data.getAnimations() != null && !data.getAnimations().isEmpty()) {
            rawData.setAnimations(data.getAnimations());
        }
        event.setCanceled(true);
    }
}

