/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.compass;

import com.github.tartaricacid.touhoulittlemaid.item.ItemKappaCompass;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SetCompassModeMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiKappaCompass
extends GuiScreen {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/compass_background.png");
    List<BlockPos> blockPosList;
    ItemKappaCompass.Mode currentMode;

    public GuiKappaCompass(ItemStack compass) {
        this.blockPosList = ItemKappaCompass.getPos(compass);
        this.currentMode = ItemKappaCompass.getMode(compass);
    }

    public void func_73866_w_() {
        int middleX = this.field_146294_l / 2;
        int middleY = this.field_146295_m / 2;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(ItemKappaCompass.Mode.SINGLE_POINT.ordinal(), middleX - 117, middleY - 63, 100, 20, I18n.func_135052_a((String)String.format("compass.touhou_little_maid.mode.%s", ItemKappaCompass.Mode.SINGLE_POINT.name().toLowerCase(Locale.US)), (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(ItemKappaCompass.Mode.MULTI_POINT_REENTRY.ordinal(), middleX - 117, middleY - 42, 100, 20, I18n.func_135052_a((String)String.format("compass.touhou_little_maid.mode.%s", ItemKappaCompass.Mode.MULTI_POINT_REENTRY.name().toLowerCase(Locale.US)), (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(ItemKappaCompass.Mode.MULTI_POINT_CLOSURE.ordinal(), middleX - 117, middleY - 21, 100, 20, I18n.func_135052_a((String)String.format("compass.touhou_little_maid.mode.%s", ItemKappaCompass.Mode.MULTI_POINT_CLOSURE.name().toLowerCase(Locale.US)), (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(ItemKappaCompass.Mode.SET_RANGE.ordinal(), middleX - 117, middleY, 100, 20, I18n.func_135052_a((String)String.format("compass.touhou_little_maid.mode.%s", ItemKappaCompass.Mode.SET_RANGE.name().toLowerCase(Locale.US)), (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(-1, middleX - 117, middleY + 42, 234, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.compass.close", (Object[])new Object[0])));
        this.enableCurrentModeButton();
    }

    private void enableCurrentModeButton() {
        if (this.currentMode != ItemKappaCompass.Mode.NONE) {
            for (GuiButton button : this.field_146292_n) {
                if (button.field_146127_k != this.currentMode.ordinal()) continue;
                button.field_146124_l = false;
                return;
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int middleX = this.field_146294_l / 2;
        int middleY = this.field_146295_m / 2;
        this.func_146276_q_();
        this.field_146297_k.field_71446_o.func_110577_a(BG);
        this.func_73729_b(middleX - 124, middleY - 71, 0, 0, 248, 142);
        this.drawPosInfo(middleX, middleY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawPosInfo(int middleX, int middleY) {
        switch (this.currentMode) {
            default: {
                return;
            }
            case SINGLE_POINT: {
                if (this.blockPosList.size() > 0) {
                    BlockPos pos = this.blockPosList.get(this.blockPosList.size() - 1);
                    this.field_146289_q.func_175065_a(String.format("A: [%d, %d, %d]", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (float)(middleX - 5), (float)(middleY - 60), -16777216, false);
                }
                return;
            }
            case SET_RANGE: {
                BlockPos pos;
                if (this.blockPosList.size() > 0) {
                    pos = this.blockPosList.get(this.blockPosList.size() - 1);
                    this.field_146289_q.func_175065_a(String.format("A: [%d, %d, %d]", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (float)(middleX - 5), (float)(middleY - 60), -16777216, false);
                }
                if (this.blockPosList.size() > 1) {
                    pos = this.blockPosList.get(this.blockPosList.size() - 2);
                    this.field_146289_q.func_175065_a(String.format("B: [%d, %d, %d]", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (float)(middleX - 5), (float)(middleY - 50), -16777216, false);
                }
                return;
            }
            case MULTI_POINT_REENTRY: 
            case MULTI_POINT_CLOSURE: 
        }
        for (int i = 0; i < this.blockPosList.size(); ++i) {
            BlockPos pos = this.blockPosList.get(i);
            this.field_146289_q.func_175065_a(String.format("%s: [%d, %d, %d]", Character.valueOf((char)(i + 65)), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (float)(middleX - 5), (float)(middleY - 60 + i * 10), -16777216, false);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (0 <= button.field_146127_k && button.field_146127_k < ItemKappaCompass.Mode.values().length) {
            this.currentMode = ItemKappaCompass.Mode.getModeByIndex(button.field_146127_k);
            this.func_73866_w_();
            CommonProxy.INSTANCE.sendToServer((IMessage)new SetCompassModeMessage(this.currentMode));
            return;
        }
        if (button.field_146127_k == -1) {
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a(null));
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

