/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.download;

import com.github.tartaricacid.touhoulittlemaid.client.download.InfoGetManager;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.gui.download.GuiDownloadButton;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenResourcePacks;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class ResourcesDownloadGui
extends GuiScreen {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/download_background.png");
    private static float scroll;
    private static int startIndex;
    private static int index;
    private static int currentPage;
    private List<Long> crc32List = Lists.newArrayList();
    private List<DownloadInfo> showInfoList;

    public ResourcesDownloadGui(List<DownloadInfo> showInfoList) {
        this.showInfoList = showInfoList;
        if (showInfoList != null && !showInfoList.isEmpty()) {
            this.getCrc32Info();
            this.checkDownloadInfo();
            this.calculationStartIndex();
        }
    }

    public void func_73866_w_() {
        int i;
        this.field_146292_n.clear();
        int startX = this.field_146294_l / 2 - 194;
        int startY = this.field_146295_m / 2 - 79;
        if (this.showInfoList == null || this.showInfoList.isEmpty()) {
            this.func_189646_b(new GuiButton(-1, 5, 5, 60, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.reload", (Object[])new Object[0])));
            return;
        }
        for (i = startIndex; i < 9 + startIndex; ++i) {
            if (i >= this.showInfoList.size()) continue;
            DownloadInfo info = this.showInfoList.get(i);
            GuiButton button = new GuiButton(i - startIndex, startX, startY + 21 * (i - startIndex), 171, 20, I18n.func_135052_a((String)info.getName(), (Object[])new Object[0]));
            if (i == index) {
                button.field_146124_l = false;
            }
            this.func_189646_b(button);
        }
        this.func_189646_b(new GuiDownloadButton(9, startX + 184, startY + 165, 200, 20, this.showInfoList.get(index)));
        for (i = 0; i < 4; ++i) {
            this.func_189646_b((GuiButton)new GuiButtonImage(10 + i, startX - 1 + 28 * i, startY - 30, 25, 25, 480, 0, 0, BG));
        }
        this.func_189646_b(new GuiButton(-2, startX + 287, startY - 30, 100, 20, I18n.func_135052_a((String)"spectatorMenu.close", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(-3, startX + 184, startY + 143, 200, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.open_resources_gui", (Object[])new Object[0])));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean inRangeY;
        int middleX = this.field_146294_l / 2;
        int middleY = this.field_146295_m / 2;
        this.func_146276_q_();
        if (this.showInfoList == null || this.showInfoList.isEmpty()) {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.fail.1", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 15, 1048575);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.fail.2", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2, 1048575);
        } else {
            int i;
            this.field_146297_k.field_71446_o.func_110577_a(BG);
            ResourcesDownloadGui.func_146110_a((int)(middleX - 200), (int)(middleY - 85), (float)0.0f, (float)0.0f, (int)400, (int)200, (float)484.0f, (float)256.0f);
            ResourcesDownloadGui.func_146110_a((int)(middleX - 19), (int)(middleY - 77 + (int)(169.0f * scroll)), (float)400.0f, (float)0.0f, (int)4, (int)15, (float)484.0f, (float)256.0f);
            for (i = 0; i < 4; ++i) {
                ResourcesDownloadGui.func_146110_a((int)(middleX - 196 + 28 * i), (int)(middleY - 110), (float)456.0f, (float)194.0f, (int)28, (int)25, (float)484.0f, (float)256.0f);
            }
            ResourcesDownloadGui.func_146110_a((int)(middleX - 196 + 28 * currentPage), (int)(middleY - 113), (float)456.0f, (float)224.0f, (int)28, (int)32, (float)484.0f, (float)256.0f);
            for (i = 0; i < 4; ++i) {
                ResourcesDownloadGui.func_152125_a((int)(middleX - 192 + 28 * i), (int)(middleY - 106), (float)(i * 32), (float)224.0f, (int)32, (int)32, (int)20, (int)20, (float)484.0f, (float)256.0f);
            }
            this.addResInfo(this.showInfoList.get(index));
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        boolean inRangeX = middleX - 196 <= mouseX && mouseX < middleX - 196 + 112;
        boolean bl = inRangeY = middleY - 110 <= mouseY && mouseY < middleY - 110 + 25;
        if (inRangeX && inRangeY) {
            int index = (mouseX - (middleX - 196)) / 28;
            this.func_146279_a(I18n.func_135052_a((String)("gui.touhou_little_maid.resources_download.tab." + index), (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    private void addResInfo(DownloadInfo info) {
        int startX = this.field_146294_l / 2 - 7;
        int startY = this.field_146295_m / 2 - 73;
        String name = I18n.func_135052_a((String)info.getName(), (Object[])new Object[0]);
        this.func_73731_b(this.field_146289_q, name, startX, startY, 0xFFAA00);
        this.func_73731_b(this.field_146289_q, info.getVersion(), startX + this.field_146289_q.func_78256_a(name) + 4, startY, 0x55FF55);
        this.func_73731_b(this.field_146289_q, this.getI18nFormatFileSize(info.getFormatFileSize()), startX, startY + 12, 3837879);
        this.func_73731_b(this.field_146289_q, this.getI18nFormatFileTime(info.getFormatData()), startX, startY + 24, 0x55FFFF);
        this.func_73731_b(this.field_146289_q, this.getI18nFormatAuthor(info.getAuthor()), startX, startY + 36, 35180);
        this.func_73731_b(this.field_146289_q, this.getI18nFormatLicense(info.getLicense()), startX, startY + 48, 16243020);
        this.field_146289_q.func_78279_b(I18n.func_135052_a((String)info.getDesc(), (Object[])new Object[0]), startX, startY + 72, 195, 0x7A7A7A);
    }

    protected void func_146284_a(GuiButton button) {
        int pageIndex;
        if (button.field_146127_k == -3) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenResourcePacks((GuiScreen)this));
            return;
        }
        if (button.field_146127_k == -2) {
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a(null));
            return;
        }
        if (button.field_146127_k == -1) {
            InfoGetManager.checkInfoJsonFile();
            this.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.resources_download.reload", new Object[0]));
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a(null));
            return;
        }
        if (button.field_146127_k >= 0 && button.field_146127_k < 9) {
            index = button.field_146127_k + startIndex;
            this.func_73866_w_();
            return;
        }
        if (button.field_146127_k == 9) {
            DownloadInfo info = this.showInfoList.get(index);
            if (DownloadStatus.canDownload(info.getStatus())) {
                InfoGetManager.downloadResourcesPack(info);
            }
            return;
        }
        if (10 <= button.field_146127_k && button.field_146127_k <= 13 && currentPage != (pageIndex = button.field_146127_k - 10)) {
            currentPage = pageIndex;
            startIndex = 0;
            scroll = 0.0f;
            DownloadInfo.TypeEnum typeEnum = DownloadInfo.TypeEnum.getTypeByIndex(pageIndex - 1);
            List<DownloadInfo> downloadInfos = InfoGetManager.getTypedDownloadInfoList(typeEnum);
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new ResourcesDownloadGui(downloadInfos)));
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (Mouse.getEventDWheel() != 0) {
            if (this.showInfoList.size() <= 9) {
                return;
            }
            float num = Mouse.getEventDWheel() < 0 ? 1.0f : -1.0f;
            scroll = MathHelper.func_76131_a((float)(scroll + num / (float)(this.showInfoList.size() - 9)), (float)0.0f, (float)1.0f);
            if ((startIndex += (int)num) < 0) {
                startIndex = 0;
            }
            if (startIndex > this.showInfoList.size() - 9) {
                startIndex = this.showInfoList.size() - 9;
            }
            this.func_73866_w_();
        }
    }

    private void getCrc32Info() {
        try {
            Path path = Minecraft.func_71410_x().field_71412_D.toPath().resolve("resourcepacks");
            Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(".zip")) {
                        ResourcesDownloadGui.this.crc32List.add(FileUtils.checksumCRC32((File)file.toFile()));
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkDownloadInfo() {
        block0: for (DownloadInfo info : this.showInfoList) {
            if (info.getStatus() == DownloadStatus.DOWNLOADING) continue;
            info.setStatus(DownloadStatus.NOT_DOWNLOAD);
            for (Long crc32 : this.crc32List) {
                if (!crc32.equals(info.getChecksum())) continue;
                info.setStatus(DownloadStatus.DOWNLOADED);
                continue block0;
            }
        }
    }

    private void calculationStartIndex() {
        int size = this.showInfoList.size();
        index = MathHelper.func_76125_a((int)index, (int)0, (int)(size - 1));
        if (size - 9 > 0 && startIndex > size - 9) {
            startIndex = size - 9;
        }
    }

    private String getI18nFormatAuthor(List<String> authors) {
        String str = String.join((CharSequence)I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.author.delimiter", (Object[])new Object[0]), authors);
        return I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.author", (Object[])new Object[]{str});
    }

    private String getI18nFormatFileSize(String size) {
        return I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.file_size", (Object[])new Object[]{size});
    }

    private String getI18nFormatFileTime(String time) {
        return I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.upload_time", (Object[])new Object[]{time});
    }

    private String getI18nFormatLicense(String license) {
        return I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.license", (Object[])new Object[]{license});
    }

    public static int getCurrentPage() {
        return currentPage;
    }
}

