/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.inventory;

import com.github.tartaricacid.touhoulittlemaid.api.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidAPI;
import com.github.tartaricacid.touhoulittlemaid.client.download.InfoGetManager;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.event.KappaCompassRenderEvent;
import com.github.tartaricacid.touhoulittlemaid.client.gui.download.ResourcesDownloadGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.MaidHataSelect;
import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.MaidSkinGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.sound.GuiMaidSound;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.MaidMainContainer;
import com.github.tartaricacid.touhoulittlemaid.item.ItemKappaCompass;
import com.github.tartaricacid.touhoulittlemaid.network.MaidGuiHandler;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.ClearMaidPosMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.MaidHomeModeMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.MaidPickupModeMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.MaidShowHelmetMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SetMaidRidingMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SwitchMaidGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.effect.EffectRequest;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiButtonToggle;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractMaidGuiContainer
extends GuiContainer {
    protected static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0");
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("touhou_little_maid", "textures/gui/inventory_main.png");
    private static final ResourceLocation SIDE = new ResourceLocation("touhou_little_maid", "textures/gui/inventory_side.png");
    private static final ResourceLocation ICON = new ResourceLocation("touhou_little_maid", "textures/gui/inventory_icon.png");
    private static ItemStack BARRIER = new ItemStack(Blocks.field_180401_cv);
    private static ItemStack SADDLE = new ItemStack(Items.field_151141_av);
    private static ScheduledExecutorService timer;
    private static int taskPageIndex;
    protected MaidMainContainer container;
    EntityMaid maid;
    private int guiId;
    private int taskPageTotal;
    private GuiButtonToggle togglePickup;
    private GuiButtonToggle toggleHome;

    public AbstractMaidGuiContainer(MaidMainContainer inventorySlotsIn, int guiId) {
        super((Container)inventorySlotsIn);
        this.guiId = guiId;
        this.container = inventorySlotsIn;
        this.maid = this.container.maid;
        this.taskPageTotal = (LittleMaidAPI.getTasks().size() - 1) / 6;
        this.syncEffectThread();
    }

    public abstract void drawCustomBackground(int var1, int var2, float var3);

    public abstract void drawCustomScreen(int var1, int var2, float var3);

    public abstract void drawCustomTooltips(int var1, int var2, float var3);

    public abstract String getGuiName();

    public void func_73866_w_() {
        int k;
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        super.func_73866_w_();
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.togglePickup = new GuiButtonToggle(BUTTON.PICKUP.ordinal(), i + 143, j + 63, 26, 16, this.maid.isPickup());
        this.togglePickup.func_191751_a(178, 0, 28, 18, BACKGROUND);
        this.field_146292_n.add(this.togglePickup);
        this.field_146292_n.add(new GuiButtonImage(BUTTON.MAIN.ordinal(), i + 6, j - 25, 22, 22, 234, 234, 0, BACKGROUND));
        this.field_146292_n.add(new GuiButtonImage(BUTTON.INVENTORY.ordinal(), i + 34, j - 25, 22, 22, 234, 234, 0, BACKGROUND));
        this.field_146292_n.add(new GuiButtonImage(BUTTON.BAUBLE.ordinal(), i + 62, j - 25, 22, 22, 234, 234, 0, BACKGROUND));
        this.toggleHome = new GuiButtonToggle(BUTTON.HOME.ordinal(), i + 116, j + 63, 26, 16, this.maid.isHomeModeEnable());
        this.toggleHome.func_191751_a(178, 36, 28, 18, BACKGROUND);
        this.field_146292_n.add(this.toggleHome);
        this.field_146292_n.add(new GuiButtonImage(BUTTON.SKIN.ordinal(), i + 65, j + 9, 9, 9, 178, 72, 10, BACKGROUND));
        if (this.maid.hasSasimono()) {
            this.field_146292_n.add(new GuiButtonImage(BUTTON.HATA_SASIMONO.ordinal(), i + 26, j + 9, 9, 9, 188, 72, 10, BACKGROUND));
        }
        GuiButtonImage leftSwitch = new GuiButtonImage(BUTTON.TASK_LEFT_SWITCH.ordinal(), i - 70, j + 150, 7, 11, 177, 0, 16, SIDE);
        GuiButtonImage rightSwitch = new GuiButtonImage(BUTTON.TASK_RIGHT_SWITCH.ordinal(), i - 17, j + 150, 7, 11, 165, 0, 16, SIDE);
        leftSwitch.field_146125_m = taskPageIndex > 0;
        rightSwitch.field_146125_m = taskPageIndex < this.taskPageTotal;
        this.field_146292_n.add(leftSwitch);
        this.field_146292_n.add(rightSwitch);
        for (k = 0; k < 6 && k + taskPageIndex * 6 < LittleMaidAPI.getTasks().size(); ++k) {
            if (LittleMaidAPI.getTasks().get(k + taskPageIndex * 6) == this.container.task) {
                this.field_146292_n.add(new GuiButtonImage(k + BUTTON.values().length, i - 70, j + 23 + 21 * k, 60, 20, 98, 0, 0, SIDE));
                continue;
            }
            this.field_146292_n.add(new GuiButtonImage(k + BUTTON.values().length, i - 70, j + 23 + 21 * k, 60, 20, 98, 20, 20, SIDE));
        }
        this.field_146292_n.add(new GuiButton(BUTTON.SOUND_CREDIT.ordinal(), i + 5, j + 167, 20, 20, ""));
        this.field_146292_n.add(new GuiButton(BUTTON.DOWNLOAD_RESOURCES.ordinal(), i + 26, j + 167, 20, 20, ""));
        this.field_146292_n.add(new GuiButton(BUTTON.SHOW_POS.ordinal(), i + 47, j + 167, 20, 20, ""));
        this.field_146292_n.add(new GuiButton(BUTTON.CLEAR_POS.ordinal(), i + 68, j + 167, 20, 20, ""));
        this.field_146292_n.add(new GuiButton(BUTTON.RIDING_SET.ordinal(), i + 89, j + 167, 20, 20, ""));
        this.field_146292_n.add(new GuiButton(BUTTON.HELMET_HIDE.ordinal(), i + 110, j + 167, 20, 20, ""));
        for (k = 4; k < 6; ++k) {
            this.field_146292_n.add(new GuiButton(405 + k, i + 47 + 21 * k, j + 167, 20, 20, ""));
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        int listIndex;
        super.func_146284_a(button);
        if (button.field_146127_k == BUTTON.PICKUP.ordinal()) {
            if (this.maid.isPickup()) {
                this.togglePickup.func_191753_b(false);
                CommonProxy.INSTANCE.sendToServer((IMessage)new MaidPickupModeMessage(this.maid.func_110124_au(), false));
                return;
            }
            this.togglePickup.func_191753_b(true);
            CommonProxy.INSTANCE.sendToServer((IMessage)new MaidPickupModeMessage(this.maid.func_110124_au(), true));
            return;
        }
        if (button.field_146127_k == BUTTON.MAIN.ordinal()) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new SwitchMaidGuiMessage(this.maid.func_145782_y(), BUTTON.MAIN.getGuiId(), this.container.taskIndex));
            return;
        }
        if (button.field_146127_k == BUTTON.INVENTORY.ordinal()) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new SwitchMaidGuiMessage(this.maid.func_145782_y(), BUTTON.INVENTORY.getGuiId(), this.container.taskIndex));
            return;
        }
        if (button.field_146127_k == BUTTON.BAUBLE.ordinal()) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new SwitchMaidGuiMessage(this.maid.func_145782_y(), BUTTON.BAUBLE.getGuiId(), this.container.taskIndex));
            return;
        }
        if (button.field_146127_k == BUTTON.HOME.ordinal()) {
            if (this.maid.isHomeModeEnable()) {
                this.toggleHome.func_191753_b(false);
                CommonProxy.INSTANCE.sendToServer((IMessage)new MaidHomeModeMessage(this.maid.func_110124_au(), false));
                return;
            }
            this.toggleHome.func_191753_b(true);
            CommonProxy.INSTANCE.sendToServer((IMessage)new MaidHomeModeMessage(this.maid.func_110124_au(), true));
            return;
        }
        if (button.field_146127_k == BUTTON.SKIN.ordinal()) {
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new MaidSkinGui(this.maid)));
            return;
        }
        if (button.field_146127_k == BUTTON.HATA_SASIMONO.ordinal()) {
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new MaidHataSelect(this.maid)));
            return;
        }
        if (button.field_146127_k == BUTTON.SOUND_CREDIT.ordinal()) {
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new GuiMaidSound()));
            return;
        }
        if (button.field_146127_k == BUTTON.DOWNLOAD_RESOURCES.ordinal()) {
            List<DownloadInfo> downloadInfoList;
            int page = ResourcesDownloadGui.getCurrentPage();
            if (page == 0) {
                downloadInfoList = InfoGetManager.DOWNLOAD_INFO_LIST_ALL;
            } else {
                DownloadInfo.TypeEnum typeEnum = DownloadInfo.TypeEnum.getTypeByIndex(page - 1);
                downloadInfoList = InfoGetManager.getTypedDownloadInfoList(typeEnum);
            }
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new ResourcesDownloadGui(downloadInfoList)));
            return;
        }
        if (button.field_146127_k == BUTTON.SHOW_POS.ordinal()) {
            KappaCompassRenderEvent.setTmpDisplay(this.maid.getCompassPosList(this.maid.getCompassMode()), this.maid.getCompassMode());
            return;
        }
        if (button.field_146127_k == BUTTON.CLEAR_POS.ordinal()) {
            KappaCompassRenderEvent.setTmpDisplay(Lists.newArrayList(), ItemKappaCompass.Mode.NONE);
            CommonProxy.INSTANCE.sendToServer((IMessage)new ClearMaidPosMessage(this.maid.func_110124_au()));
            return;
        }
        if (button.field_146127_k == BUTTON.RIDING_SET.ordinal()) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new SetMaidRidingMessage(this.maid.func_110124_au()));
            return;
        }
        if (button.field_146127_k == BUTTON.HELMET_HIDE.ordinal()) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new MaidShowHelmetMessage(this.maid.func_110124_au(), !this.maid.isShowHelmet()));
            return;
        }
        if (button.field_146127_k == BUTTON.TASK_LEFT_SWITCH.ordinal()) {
            if (taskPageIndex > 0) {
                --taskPageIndex;
                this.func_73866_w_();
            }
            return;
        }
        if (button.field_146127_k == BUTTON.TASK_RIGHT_SWITCH.ordinal()) {
            if (taskPageIndex < this.taskPageTotal) {
                ++taskPageIndex;
                this.func_73866_w_();
            }
            return;
        }
        if (button.field_146127_k >= BUTTON.values().length && button.field_146127_k < BUTTON.values().length + 6 && (listIndex = button.field_146127_k - BUTTON.values().length + taskPageIndex * 6) < LittleMaidAPI.getTasks().size()) {
            this.container.taskIndex = listIndex;
            this.container.task = LittleMaidAPI.getTasks().get(listIndex);
            this.func_73866_w_();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean yInRange;
        boolean xInRange;
        int k;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawCustomScreen(mouseX, mouseY, partialTicks);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        String currentModeName = TextFormatting.DARK_GRAY + I18n.func_135052_a((String)this.container.task.getTranslationKey(), (Object[])new Object[0]);
        this.field_146289_q.func_175065_a(currentModeName, (float)(i - 39 - this.field_146289_q.func_78256_a(currentModeName) / 2), (float)(j + 9), 0xFFFFFF, false);
        String pageText = String.format("%s%d/%d", TextFormatting.DARK_GRAY, taskPageIndex + 1, this.taskPageTotal + 1);
        this.field_146289_q.func_175065_a(pageText, (float)(i - 39 - this.field_146289_q.func_78256_a(pageText) / 2), (float)(j + 151), 0xFFFFFF, false);
        for (k = 0; k < 6 && k + taskPageIndex * 6 < LittleMaidAPI.getTasks().size(); ++k) {
            IMaidTask task = LittleMaidAPI.getTasks().get(k + taskPageIndex * 6);
            this.drawItemStack(task.getIcon(), i - 68, j + 25 + 21 * k);
            String name = I18n.func_135052_a((String)task.getTranslationKey(), (Object[])new Object[0]);
            this.field_146289_q.func_175065_a(name, (float)(i - 32) - (float)this.field_146289_q.func_78256_a(name) / 2.0f, (float)(j + 29 + 21 * k), 0xDDDDDD, false);
        }
        this.field_146297_k.field_71446_o.func_110577_a(ICON);
        AbstractMaidGuiContainer.func_146110_a((int)(i + 8), (int)(j + 170), (float)0.0f, (float)0.0f, (int)14, (int)14, (float)256.0f, (float)256.0f);
        AbstractMaidGuiContainer.func_146110_a((int)(i + 29), (int)(j + 170), (float)14.0f, (float)0.0f, (int)14, (int)14, (float)256.0f, (float)256.0f);
        AbstractMaidGuiContainer.func_146110_a((int)(i + 50), (int)(j + 170), (float)28.0f, (float)0.0f, (int)14, (int)14, (float)256.0f, (float)256.0f);
        AbstractMaidGuiContainer.func_146110_a((int)(i + 71), (int)(j + 170), (float)42.0f, (float)0.0f, (int)14, (int)14, (float)256.0f, (float)256.0f);
        AbstractMaidGuiContainer.func_146110_a((int)(i + 92), (int)(j + 170), (float)56.0f, (float)0.0f, (int)14, (int)14, (float)256.0f, (float)256.0f);
        AbstractMaidGuiContainer.func_146110_a((int)(i + 113), (int)(j + 170), (float)70.0f, (float)0.0f, (int)14, (int)14, (float)256.0f, (float)256.0f);
        for (k = 4; k < 6; ++k) {
            this.drawItemStack(BARRIER, i + 49 + 21 * k, j + 169);
        }
        int spacing = 0;
        Collection effects = this.maid.func_70651_bq();
        for (PotionEffect effect : effects) {
            if (effect.func_76459_b() <= 0) continue;
            Potion potion = effect.func_188419_a();
            int startX = i + 178 + this.getRenderPotionStartXOffset();
            int startY = j + 5 + spacing;
            spacing += 12;
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)startX, (double)((double)startY - 1.5), (double)0.0);
            GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
            this.field_146297_k.func_110434_K().func_110577_a(field_147001_a);
            if (potion.func_76400_d()) {
                int index = potion.func_76392_e();
                this.func_73729_b(0, 0, index % 8 * 18, 198 + index / 8 * 18, 18, 18);
            }
            GlStateManager.func_179121_F();
            potion.renderInventoryEffect(i, j, effect, this.field_146297_k);
            if (!potion.shouldRenderInvText(effect) || effect.func_76459_b() <= 0) continue;
            this.field_146289_q.func_175065_a(String.format("%s %s %s %s%s", effect.func_188419_a().func_76398_f() ? TextFormatting.RED : TextFormatting.RESET, I18n.func_135052_a((String)effect.func_76453_d(), (Object[])new Object[0]), I18n.func_135052_a((String)("enchantment.level." + (effect.func_76458_c() + 1)), (Object[])new Object[0]), TextFormatting.GRAY, Potion.func_188410_a((PotionEffect)effect, (float)1.0f)), (float)(startX + 9), (float)startY, -1, true);
        }
        for (MaidGuiHandler.MAIN_GUI gui : MaidGuiHandler.MAIN_GUI.values()) {
            xInRange = i + 3 + 28 * (gui.getId() - 1) < mouseX && mouseX < i + 3 + 28 * gui.getId();
            boolean bl = yInRange = j - 28 < mouseY && mouseY < j;
            if (!xInRange || !yInRange) continue;
            this.func_146279_a(I18n.func_135052_a((String)("gui.touhou_little_maid.tab." + gui.name().toLowerCase(Locale.US)), (Object[])new Object[0]), mouseX, mouseY);
        }
        xInRange = i + 143 < mouseX && mouseX < i + 169;
        boolean bl = yInRange = j + 63 < mouseY && mouseY < j + 79;
        if (xInRange && yInRange) {
            this.func_146283_a(Arrays.asList(I18n.func_135052_a((String)("gui.touhou_little_maid.button.pickup." + this.maid.isPickup()), (Object[])new Object[0]), I18n.func_135052_a((String)"gui.touhou_little_maid.button.pickup.desc", (Object[])new Object[0])), mouseX, mouseY);
        }
        xInRange = i + 116 < mouseX && mouseX < i + 142;
        boolean bl2 = yInRange = j + 63 < mouseY && mouseY < j + 79;
        if (xInRange && yInRange) {
            this.func_146283_a(Arrays.asList(I18n.func_135052_a((String)("gui.touhou_little_maid.button.home." + this.maid.isHomeModeEnable()), (Object[])new Object[0]), I18n.func_135052_a((String)"gui.touhou_little_maid.button.home.desc", (Object[])new Object[0])), mouseX, mouseY);
        }
        xInRange = i + 65 < mouseX && mouseX < i + 74;
        boolean bl3 = yInRange = j + 9 < mouseY && mouseY < j + 18;
        if (xInRange && yInRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.button.skin", (Object[])new Object[0]), mouseX, mouseY);
        }
        xInRange = i + 26 < mouseX && mouseX < i + 35;
        boolean bl4 = yInRange = j + 9 < mouseY && mouseY < j + 18;
        if (xInRange && yInRange && this.maid.hasSasimono()) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.button.hata_sasimono", (Object[])new Object[0]), mouseX, mouseY);
        }
        xInRange = i + 3 < mouseX && mouseX < i + 23;
        boolean bl5 = yInRange = j + 167 < mouseY && mouseY < j + 187;
        if (xInRange && yInRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.button.sound_credit", (Object[])new Object[0]), mouseX, mouseY);
        }
        xInRange = i + 24 < mouseX && mouseX < i + 44;
        boolean bl6 = yInRange = j + 167 < mouseY && mouseY < j + 187;
        if (xInRange && yInRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.button.pack_download", (Object[])new Object[0]), mouseX, mouseY);
        }
        xInRange = i + 45 < mouseX && mouseX < i + 65;
        boolean bl7 = yInRange = j + 167 < mouseY && mouseY < j + 187;
        if (xInRange && yInRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.button.show_pos", (Object[])new Object[0]), mouseX, mouseY);
        }
        xInRange = i + 67 < mouseX && mouseX < i + 86;
        boolean bl8 = yInRange = j + 167 < mouseY && mouseY < j + 187;
        if (xInRange && yInRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.button.clear_pos", (Object[])new Object[0]), mouseX, mouseY);
        }
        xInRange = i + 89 < mouseX && mouseX < i + 108;
        boolean bl9 = yInRange = j + 167 < mouseY && mouseY < j + 187;
        if (xInRange && yInRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.button.riding_set", (Object[])new Object[0]), mouseX, mouseY);
        }
        xInRange = i + 108 < mouseX && mouseX < i + 127;
        boolean bl10 = yInRange = j + 167 < mouseY && mouseY < j + 187;
        if (xInRange && yInRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.button.hide_helmet", (Object[])new Object[0]), mouseX, mouseY);
        }
        this.drawCustomTooltips(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(i + 3, j - 28, 0, 193, 168, 32);
        this.field_146297_k.func_110434_K().func_110577_a(SIDE);
        this.func_73729_b(i - 76, j, 0, 0, 89, this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawCustomBackground(mouseX, mouseY, partialTicks);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(i + 3 + 28 * (this.guiId - 1), j - 28, 28 * (this.guiId - 1), 224, 28, 32);
        this.drawItemStack(Items.field_151099_bA.func_190903_i(), i + 9, j - 19);
        this.drawItemStack(Item.func_150898_a((Block)Blocks.field_150486_ae).func_190903_i(), i + 37, j - 19);
        this.drawItemStack(new ItemStack(Items.field_151100_aR, 1, 4), i + 65, j - 19);
        this.drawItemStack(BARRIER, i + 93, j - 19);
        this.drawItemStack(BARRIER, i + 121, j - 19);
        this.drawItemStack(BARRIER, i + 149, j - 19);
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        double scaleW = (double)this.field_146297_k.field_71443_c / res.func_78327_c();
        double scaleH = (double)this.field_146297_k.field_71440_d / res.func_78324_d();
        GL11.glScissor((int)((int)((double)(i + 26) * scaleW)), (int)((int)(((double)j + 87.5) * scaleH)), (int)((int)(49.0 * scaleW)), (int)((int)(70.0 * scaleH)));
        GL11.glEnable((int)3089);
        GuiInventory.func_147046_a((int)(i + 51), (int)(j + 70), (int)28, (float)((float)(i + 51) - (float)mouseX), (float)((float)(j + 70 - 45) - (float)mouseY), (EntityLivingBase)this.maid);
        GL11.glDisable((int)3089);
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
    }

    public abstract int getRenderPotionStartXOffset();

    public int getXSize() {
        if (this.maid.func_70651_bq().size() <= 0) {
            return super.getXSize() + this.getRenderPotionStartXOffset();
        }
        int i = 0;
        for (PotionEffect effect : this.maid.func_70651_bq()) {
            i += effect.func_76459_b();
        }
        if (i == 0) {
            return super.getXSize() + this.getRenderPotionStartXOffset();
        }
        return super.getXSize() + 128 + this.getRenderPotionStartXOffset();
    }

    private void syncEffectThread() {
        timer = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("sync-maid-effect-schedule").daemon(true).build());
        timer.scheduleAtFixedRate(() -> CommonProxy.INSTANCE.sendToServer((IMessage)new EffectRequest(this.maid.func_110124_au())), 0L, 500L, TimeUnit.MILLISECONDS);
    }

    public void func_146281_b() {
        timer.shutdownNow();
        super.func_146281_b();
    }

    public static enum BUTTON {
        PICKUP(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        MAIN(MaidGuiHandler.MAIN_GUI.MAIN.getId()),
        INVENTORY(MaidGuiHandler.MAIN_GUI.INVENTORY.getId()),
        BAUBLE(MaidGuiHandler.MAIN_GUI.BAUBLE.getId()),
        HOME(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        SKIN(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        SOUND_CREDIT(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        HATA_SASIMONO(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        TASK_LEFT_SWITCH(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        TASK_RIGHT_SWITCH(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        DOWNLOAD_RESOURCES(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        SHOW_POS(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        CLEAR_POS(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        RIDING_SET(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        HELMET_HIDE(MaidGuiHandler.OTHER_GUI.NONE.getId());

        private int guiId;

        private BUTTON(int guiId) {
            this.guiId = guiId;
        }

        public int getGuiId() {
            return this.guiId;
        }
    }
}

