/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.inventory;

import com.github.tartaricacid.touhoulittlemaid.client.gui.inventory.AbstractMaidGuiContainer;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.MaidInventoryContainer;
import com.github.tartaricacid.touhoulittlemaid.network.MaidGuiHandler;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SwitchMaidGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import java.io.IOException;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class MaidInventoryGuiContainer
extends AbstractMaidGuiContainer {
    private static final ResourceLocation STORAGE_TEX = new ResourceLocation("touhou_little_maid", "textures/gui/inventory_storage.png");
    private float currentScroll;
    private boolean needScroll;
    private int startRow;

    public MaidInventoryGuiContainer(InventoryPlayer inventory, EntityMaid maid, int taskIndex, int startRow) {
        super(new MaidInventoryContainer((IInventory)inventory, maid, taskIndex, startRow), MaidGuiHandler.MAIN_GUI.INVENTORY.getId());
        this.startRow = MathHelper.func_76125_a((int)startRow, (int)0, (int)(maid.getBackLevel().getLevel() * 2));
        this.needScroll = this.maid.getBackLevel() != EntityMaid.EnumBackPackLevel.EMPTY;
        this.currentScroll = (float)((double)this.startRow * (1.0 / (double)(maid.getBackLevel().getLevel() * 2)));
        this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
    }

    @Override
    public void drawCustomScreen(int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void drawCustomTooltips(int mouseX, int mouseY, float partialTicks) {
        boolean yInRange;
        boolean xInRange = this.field_147003_i + 174 < mouseX && mouseX < this.field_147003_i + 186;
        boolean bl = yInRange = this.field_147009_r + 8 < mouseY && mouseY < this.field_147009_r + 60;
        if (this.needScroll && xInRange && yInRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.inventory.scroll.desc", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    @Override
    public void drawCustomBackground(int mouseX, int mouseY, float partialTicks) {
        this.field_146297_k.func_110434_K().func_110577_a(STORAGE_TEX);
        this.func_73729_b(this.field_147003_i + 79, this.field_147009_r, 0, 0, 115, 84);
        if (this.needScroll) {
            this.func_175174_a(this.field_147003_i + 79 + 95, (float)(this.field_147009_r + 8) + 37.0f * this.currentScroll, 115, 0, 12, 15);
        } else {
            this.func_73729_b(this.field_147003_i + 79 + 95, this.field_147009_r + 8, 127, 0, 12, 15);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int dWheel = Mouse.getEventDWheel();
        if (dWheel != 0 && this.needScroll) {
            if (dWheel > 0) {
                dWheel = 1;
            }
            if (dWheel < 0) {
                dWheel = -1;
            }
            int maxStartRow = this.maid.getBackLevel().getLevel() * 2;
            this.startRow = MathHelper.func_76125_a((int)(this.startRow - dWheel), (int)0, (int)maxStartRow);
            this.currentScroll = (float)MathHelper.func_151237_a((double)((double)this.startRow * (1.0 / (double)maxStartRow)), (double)0.0, (double)1.0);
            CommonProxy.INSTANCE.sendToServer((IMessage)new SwitchMaidGuiMessage(this.maid.func_145782_y(), AbstractMaidGuiContainer.BUTTON.INVENTORY.getGuiId(), this.container.taskIndex, this.startRow));
        }
    }

    @Override
    public int getRenderPotionStartXOffset() {
        return 18;
    }

    @Override
    public String getGuiName() {
        return MaidGuiHandler.MAIN_GUI.INVENTORY.name().toLowerCase(Locale.US);
    }
}

