/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.inventory;

import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.WirelessIOContainer;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.WirelessIOGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.WirelessIOSlotConfigMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.github.tartaricacid.touhoulittlemaid.util.BytesBooleansConvert;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiButtonToggle;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WirelessIOGuiContainer
extends GuiContainer {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("textures/gui/container/dispenser.png");
    private static final ResourceLocation ICON = new ResourceLocation("touhou_little_maid", "textures/gui/wireless_io.png");
    private static final ResourceLocation SLOT = new ResourceLocation("touhou_little_maid", "textures/gui/wireless_io_slot_config.png");
    private static final int SLOT_NUM = 47;
    private GuiButtonToggle ioModeToggle;
    private GuiButtonToggle filterModeToggle;
    private boolean isInput;
    private boolean isBlacklist;

    public WirelessIOGuiContainer(IInventory playerInventory, ItemStack wirelessIO) {
        super((Container)new WirelessIOContainer(playerInventory, wirelessIO));
        this.isInput = ItemWirelessIO.isInputMode(wirelessIO);
        this.isBlacklist = ItemWirelessIO.isBlacklist(wirelessIO);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        super.func_73866_w_();
        this.ioModeToggle = new GuiButtonToggle(1, this.field_147003_i + 26, this.field_147009_r + 35, 12, 16, this.isInput);
        this.ioModeToggle.func_191751_a(44, 0, -12, 16, ICON);
        this.filterModeToggle = new GuiButtonToggle(2, this.field_147003_i + 136, this.field_147009_r + 26, 16, 16, this.isBlacklist);
        this.filterModeToggle.func_191751_a(72, 0, -16, 16, ICON);
        GuiButtonImage configButton = new GuiButtonImage(3, this.field_147003_i + 136, this.field_147009_r + 44, 16, 16, 88, 0, 16, ICON);
        this.func_189646_b((GuiButton)this.ioModeToggle);
        this.func_189646_b((GuiButton)this.filterModeToggle);
        this.func_189646_b((GuiButton)configButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean yInRange;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String ioModeText = this.isInput ? I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.io_mode.input", (Object[])new Object[0]) : I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.io_mode.output", (Object[])new Object[0]);
        String filterModeText = this.isBlacklist ? I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.filter_mode.blacklist", (Object[])new Object[0]) : I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.filter_mode.whitelist", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(ioModeText, this.field_147003_i - this.field_146289_q.func_78256_a(ioModeText) - 5, this.field_147009_r + 5, 0xFFFFFF);
        this.field_146289_q.func_78276_b(filterModeText, this.field_147003_i - this.field_146289_q.func_78256_a(filterModeText) - 5, this.field_147009_r + 15, 0xFFFFFF);
        boolean xInRange = this.field_147003_i + 26 < mouseX && mouseX < this.field_147003_i + 38;
        boolean bl = yInRange = this.field_147009_r + 35 < mouseY && mouseY < this.field_147009_r + 51;
        if (xInRange && yInRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.wireless_io.io_mode", (Object[])new Object[0]), mouseX, mouseY);
        }
        xInRange = this.field_147003_i + 136 < mouseX && mouseX < this.field_147003_i + 152;
        boolean bl2 = yInRange = this.field_147009_r + 26 < mouseY && mouseY < this.field_147009_r + 42;
        if (xInRange && yInRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.wireless_io.filter_mode", (Object[])new Object[0]), mouseX, mouseY);
        }
        xInRange = this.field_147003_i + 136 < mouseX && mouseX < this.field_147003_i + 152;
        boolean bl3 = yInRange = this.field_147009_r + 44 < mouseY && mouseY < this.field_147009_r + 60;
        if (xInRange && yInRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.wireless_io.config_slot", (Object[])new Object[0]), mouseX, mouseY);
        }
        super.func_191948_b(mouseX, mouseY);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 1) {
            this.isInput = !this.isInput;
            this.ioModeToggle.func_191753_b(this.isInput);
            CommonProxy.INSTANCE.sendToServer((IMessage)new WirelessIOGuiMessage(this.isInput, this.isBlacklist));
        }
        if (button.field_146127_k == 2) {
            this.isBlacklist = !this.isBlacklist;
            this.filterModeToggle.func_191753_b(this.isBlacklist);
            CommonProxy.INSTANCE.sendToServer((IMessage)new WirelessIOGuiMessage(this.isInput, this.isBlacklist));
        }
        if (button.field_146127_k == 3 && this.field_146297_k.field_71439_g.func_184614_ca().func_77973_b() == MaidItems.WIRELESS_IO) {
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new GuiConfigSlot(this.field_146297_k.field_71439_g.func_184614_ca())));
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(ICON);
        this.func_73729_b(this.field_147003_i + 24, this.field_147009_r + 17, 0, 0, 16, 16);
        this.func_73729_b(this.field_147003_i + 24, this.field_147009_r + 53, 16, 0, 16, 16);
    }

    private static class GuiConfigSlot
    extends GuiScreen {
        private final GuiButtonToggle[] slotButtons = new GuiButtonToggle[47];
        private boolean[] configData = new boolean[47];

        public GuiConfigSlot(ItemStack wirelessIO) {
            byte[] tmp = ItemWirelessIO.getSlotConfig(wirelessIO);
            if (tmp != null) {
                this.configData = BytesBooleansConvert.bytes2Booleans(tmp);
            }
        }

        public void func_73866_w_() {
            int startX = (this.field_146294_l - 104) / 2;
            int startY = (this.field_146295_m - 205) / 2;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 5; ++j) {
                    int id = i * 5 + j;
                    this.slotButtons[id] = new GuiButtonToggle(id, startX + 8 + 18 * j, startY + 6 + 18 * i, 16, 16, this.configData[id]);
                    this.slotButtons[id].func_191751_a(140, 0, 16, 16, SLOT);
                    this.func_189646_b((GuiButton)this.slotButtons[id]);
                }
            }
            for (int k = 0; k < 3; ++k) {
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 5; ++j) {
                        int id = 15 + k * 10 + i * 5 + j;
                        this.slotButtons[id] = new GuiButtonToggle(id, startX + 8 + 18 * j, startY + 64 + 40 * k + 18 * i, 16, 16, this.configData[id]);
                        this.slotButtons[id].func_191751_a(140, 0, 16, 16, SLOT);
                        this.func_189646_b((GuiButton)this.slotButtons[id]);
                    }
                }
            }
            this.slotButtons[45] = new GuiButtonToggle(45, startX + 113, startY + 8, 16, 16, this.configData[45]);
            this.slotButtons[45].func_191751_a(140, 0, 16, 16, SLOT);
            this.func_189646_b((GuiButton)this.slotButtons[45]);
            this.slotButtons[46] = new GuiButtonToggle(46, startX + 113, startY + 26, 16, 16, this.configData[46]);
            this.slotButtons[46].func_191751_a(140, 0, 16, 16, SLOT);
            this.func_189646_b((GuiButton)this.slotButtons[46]);
            GuiButton returnButton = new GuiButton(-1, (this.field_146294_l - 104) / 2, startY + 188, 104, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.wireless_io.config_slot.return", (Object[])new Object[0]));
            this.func_189646_b(returnButton);
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            int startX = (this.field_146294_l - 104) / 2;
            int startY = (this.field_146295_m - 205) / 2;
            this.func_146276_q_();
            this.field_146297_k.func_110434_K().func_110577_a(SLOT);
            this.func_73729_b(startX, startY, 0, 0, 137, 205);
            this.field_146297_k.func_175599_af().func_180450_b(new ItemStack(MaidItems.MAID_BACKPACK, 1, 1), startX - 18, startY + 64);
            this.field_146297_k.func_175599_af().func_180450_b(new ItemStack(MaidItems.MAID_BACKPACK, 1, 2), startX - 18, startY + 104);
            this.field_146297_k.func_175599_af().func_180450_b(new ItemStack(MaidItems.MAID_BACKPACK, 1, 3), startX - 18, startY + 144);
            GlStateManager.func_179147_l();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            GlStateManager.func_179084_k();
        }

        protected void func_146284_a(GuiButton button) {
            if (0 <= button.field_146127_k && button.field_146127_k < 47) {
                this.slotButtons[button.field_146127_k].func_191753_b(!this.configData[button.field_146127_k]);
                this.configData[button.field_146127_k] = !this.configData[button.field_146127_k];
                return;
            }
            if (button.field_146127_k == -1) {
                CommonProxy.INSTANCE.sendToServer((IMessage)new WirelessIOSlotConfigMessage(BytesBooleansConvert.booleans2Bytes(this.configData), false));
            }
        }

        public void func_146281_b() {
            CommonProxy.INSTANCE.sendToServer((IMessage)new WirelessIOSlotConfigMessage(BytesBooleansConvert.booleans2Bytes(this.configData), true));
        }
    }
}

