/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.client.gui.item.DrawListGui;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.draw.DrawManger;
import com.github.tartaricacid.touhoulittlemaid.draw.SendToServerDrawMessage;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class DrawConfigGui
extends GuiScreen {
    private static final String ENTITY_ID = "touhou_little_maid:entity.passive.maid";
    public List<DrawManger.ModelDrawInfo> modelDrawInfoList;
    private long unixTime;
    private boolean isEditPool = false;
    private MaidModelInfo modelItem;
    private DrawListGui drawList;
    private int selectIndex;

    public DrawConfigGui(List<DrawManger.ModelDrawInfo> modelDrawInfoList) {
        this.modelDrawInfoList = modelDrawInfoList;
    }

    public void func_73866_w_() {
        this.drawList = new DrawListGui(this);
        this.drawList.elementClicked(0, false);
        this.field_146292_n.add(new GuiButton(0, 100, 20, 30, 20, "N"));
        this.field_146292_n.add(new GuiButton(1, 132, 20, 30, 20, "R"));
        this.field_146292_n.add(new GuiButton(2, 164, 20, 30, 20, "SR"));
        this.field_146292_n.add(new GuiButton(3, 196, 20, 30, 20, "SSR"));
        this.field_146292_n.add(new GuiButton(4, 228, 20, 30, 20, "UR"));
        this.field_146292_n.add(new GuiButton(5, 100, 60, 30, 20, "-100"));
        this.field_146292_n.add(new GuiButton(6, 132, 60, 30, 20, "-10"));
        this.field_146292_n.add(new GuiButton(7, 164, 60, 30, 20, "-1"));
        this.field_146292_n.add(new GuiButton(8, 196, 60, 30, 20, "+1"));
        this.field_146292_n.add(new GuiButton(9, 228, 60, 30, 20, "+10"));
        this.field_146292_n.add(new GuiButton(10, 260, 60, 30, 20, "+100"));
        this.field_146292_n.add(new GuiButton(11, this.field_146294_l - 90, 20, 80, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.draw_config.save", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(12, this.field_146294_l - 90, 45, 80, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.draw_config.save_reload", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(13, 260, 20, 30, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.draw_config.edit", (Object[])new Object[0])));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -14737116, -14737116);
        if (this.modelItem != null) {
            EntityMaid maid;
            try {
                maid = (EntityMaid)((Object)EntityCacheUtil.ENTITY_CACHE.get((Object)ENTITY_ID, () -> {
                    Entity e = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(ENTITY_ID), (World)this.field_146297_k.field_71441_e);
                    if (e == null) {
                        return new EntityMaid((World)this.field_146297_k.field_71441_e);
                    }
                    return e;
                }));
            }
            catch (ClassCastException | ExecutionException e) {
                e.printStackTrace();
                return;
            }
            EntityCacheUtil.clearMaidDataResidue(maid, true);
            maid.setModelId(this.modelItem.getModelId().toString());
            GuiInventory.func_147046_a((int)50, (int)80, (int)((int)(40.0f * this.modelItem.getRenderItemScale())), (float)(-mouseX + 50), (float)(-mouseY + 40), (EntityLivingBase)maid);
        }
        if (!this.isEditPool) {
            this.drawList.drawScreen(mouseX, mouseY, partialTicks);
        } else {
            String text = I18n.func_135052_a((String)"gui.touhou_little_maid.draw_config.how_to_edit_pool", (Object[])new Object[]{GeneralConfig.GASHAPON_CONFIG.gashaponWeights1, GeneralConfig.GASHAPON_CONFIG.gashaponWeights2, GeneralConfig.GASHAPON_CONFIG.gashaponWeights3, GeneralConfig.GASHAPON_CONFIG.gashaponWeights4, GeneralConfig.GASHAPON_CONFIG.gashaponWeights5}).replace("\\n", "\n");
            this.field_146289_q.func_78279_b(text, 50, 110, this.field_146294_l - 100, -1);
        }
        if (this.selectIndex >= 0 && this.selectIndex < this.modelDrawInfoList.size()) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.draw_config.pool", (Object[])new Object[]{this.modelDrawInfoList.get(this.selectIndex).getLevel().getFormatText()}), 100, 5, -1);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.draw_config.weight", (Object[])new Object[]{this.modelDrawInfoList.get(this.selectIndex).getWeight()}), 100, 45, -1);
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }
        if (this.unixTime > System.currentTimeMillis()) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.draw_config.done", (Object[])new Object[0]), this.field_146294_l - 50 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.touhou_little_maid.draw_config.done", (Object[])new Object[0])) / 2, 72, -56798);
        }
    }

    protected void func_146284_a(GuiButton button) {
        DrawManger.ModelDrawInfo info = this.modelDrawInfoList.get(this.selectIndex);
        switch (button.field_146127_k) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                info.setLevel(DrawManger.Level.values()[button.field_146127_k]);
                return;
            }
            case 5: {
                info.setWeight(MathHelper.func_76125_a((int)(info.getWeight() - 100), (int)0, (int)Integer.MAX_VALUE));
                return;
            }
            case 6: {
                info.setWeight(MathHelper.func_76125_a((int)(info.getWeight() - 10), (int)0, (int)Integer.MAX_VALUE));
                return;
            }
            case 7: {
                info.setWeight(MathHelper.func_76125_a((int)(info.getWeight() - 1), (int)0, (int)Integer.MAX_VALUE));
                return;
            }
            case 8: {
                info.setWeight(MathHelper.func_76125_a((int)(info.getWeight() + 1), (int)0, (int)Integer.MAX_VALUE));
                return;
            }
            case 9: {
                info.setWeight(MathHelper.func_76125_a((int)(info.getWeight() + 10), (int)0, (int)Integer.MAX_VALUE));
                return;
            }
            case 10: {
                info.setWeight(MathHelper.func_76125_a((int)(info.getWeight() + 100), (int)0, (int)Integer.MAX_VALUE));
                return;
            }
            case 11: {
                CommonProxy.INSTANCE.sendToServer((IMessage)new SendToServerDrawMessage(this.modelDrawInfoList, false));
                this.unixTime = System.currentTimeMillis() + 3000L;
                return;
            }
            case 12: {
                CommonProxy.INSTANCE.sendToServer((IMessage)new SendToServerDrawMessage(this.modelDrawInfoList, true));
                this.unixTime = System.currentTimeMillis() + 3000L;
                return;
            }
            case 13: {
                this.isEditPool = !this.isEditPool;
            }
        }
    }

    public void func_146274_d() throws IOException {
        if (!this.isEditPool) {
            int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.drawList.handleMouseInput(mouseX, mouseY);
        }
        super.func_146274_d();
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public int getSelectIndex() {
        return this.selectIndex;
    }

    public void setSelectIndex(int index) {
        this.selectIndex = MathHelper.func_76125_a((int)index, (int)0, (int)(this.modelDrawInfoList.size() - 1));
    }

    public void setModelItem(MaidModelInfo modelItem) {
        this.modelItem = modelItem;
    }
}

