/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.client.gui.item.DrawConfigGui;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.draw.DrawManger;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.Optional;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.GuiScrollingList;

public class DrawListGui
extends GuiScrollingList {
    private DrawConfigGui parentGui;

    public DrawListGui(DrawConfigGui parentGui) {
        super(parentGui.field_146297_k, parentGui.field_146294_l, parentGui.field_146295_m, 90, parentGui.field_146295_m, 0, 12, parentGui.field_146294_l, parentGui.field_146295_m);
        this.parentGui = parentGui;
        this.setHeaderInfo(true, 15);
    }

    protected int getSize() {
        return this.parentGui.modelDrawInfoList.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        DrawManger.ModelDrawInfo info = this.parentGui.modelDrawInfoList.get(index);
        Optional<MaidModelInfo> modelInfo = CustomResourcesLoader.MAID_MODEL.getInfo(info.getModelId());
        if (modelInfo.isPresent()) {
            this.parentGui.setSelectIndex(index);
            this.parentGui.setModelItem(modelInfo.get());
        }
    }

    protected void drawHeader(int entryRight, int relativeY, Tessellator tess) {
        this.parentGui.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.draw_list.index", (Object[])new Object[0]), 10, relativeY, -1);
        this.parentGui.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.draw_list.model_name", (Object[])new Object[0]), 40, relativeY, -1);
        this.parentGui.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.draw_list.pool", (Object[])new Object[0]), this.parentGui.field_146294_l - 100, relativeY, -1);
        this.parentGui.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.draw_list.weight", (Object[])new Object[0]), this.parentGui.field_146294_l - 50, relativeY, -1);
    }

    protected boolean isSelected(int index) {
        return index == this.parentGui.getSelectIndex();
    }

    protected void drawBackground() {
        Gui.func_73734_a((int)0, (int)89, (int)this.parentGui.field_146294_l, (int)90, (int)-11115920);
        Gui.func_73734_a((int)0, (int)90, (int)this.parentGui.field_146294_l, (int)this.parentGui.field_146295_m, (int)-13092289);
    }

    protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        DrawManger.ModelDrawInfo info = this.parentGui.modelDrawInfoList.get(slotIdx);
        Optional<MaidModelInfo> modelInfo = CustomResourcesLoader.MAID_MODEL.getInfo(info.getModelId());
        if (modelInfo.isPresent()) {
            if (slotIdx % 2 == 0) {
                Gui.func_73734_a((int)0, (int)(slotTop - 2), (int)this.parentGui.field_146294_l, (int)(slotTop + 10), (int)576086640);
            }
            String name = ParseI18n.parse(modelInfo.get().getName());
            this.parentGui.getFontRenderer().func_78276_b(String.valueOf(slotIdx), 10, slotTop, -1);
            this.parentGui.getFontRenderer().func_78276_b(name, 40, slotTop, -1);
            this.parentGui.getFontRenderer().func_78276_b(info.getLevel().getFormatText(), this.parentGui.field_146294_l - 100, slotTop, -1);
            this.parentGui.getFontRenderer().func_78276_b(String.valueOf(info.getWeight()), this.parentGui.field_146294_l - 50, slotTop, -1);
            if (info.getWeight() == 0) {
                Gui.func_73734_a((int)40, (int)(slotTop + 4), (int)(40 + this.parentGui.getFontRenderer().func_78256_a(name)), (int)(slotTop + 5), (int)-1157888);
            }
        }
    }
}

