/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.client.audio.music.MusicManger;
import com.github.tartaricacid.touhoulittlemaid.client.audio.music.NetEaseMusicList;
import com.github.tartaricacid.touhoulittlemaid.client.gui.item.PortableAudioGui;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.PortableAudioMessageToServer;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiMusicList
extends GuiScrollingList {
    private static final ResourceLocation PIC = new ResourceLocation("touhou_little_maid", "textures/gui/netease_music.png");
    public static int MUSIC_INDEX;
    private final PortableAudioGui parent;
    private final NetEaseMusicList.PlayList playList;

    public GuiMusicList(PortableAudioGui parent) {
        super(parent.field_146297_k, parent.field_146294_l - 101, parent.field_146295_m - 48, 24, parent.field_146295_m - 24, 101, 12, parent.field_146294_l, parent.field_146295_m);
        this.parent = parent;
        this.playList = MusicManger.MUSIC_LIST_GROUP.get(Math.min(PortableAudioGui.LIST_INDEX, MusicManger.MUSIC_LIST_GROUP.size() - 1)).getPlayList();
        MUSIC_INDEX = Math.min(this.playList.getTracks().size() - 1, MUSIC_INDEX);
        this.setHeaderInfo(true, 130);
    }

    protected int getSize() {
        return this.playList.getTrackCount();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        if (doubleClick) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new PortableAudioMessageToServer(this.parent.getAudio().func_110124_au(), this.playList, index));
        } else {
            MUSIC_INDEX = index;
        }
    }

    protected boolean isSelected(int index) {
        return index == MUSIC_INDEX;
    }

    protected void drawHeader(int entryRight, int startY, Tessellator tess) {
        int startX = 101;
        Minecraft mc = this.parent.field_146297_k;
        FontRenderer fontRenderer = mc.field_71466_p;
        Gui.func_73734_a((int)0, (int)0, (int)this.parent.field_146294_l, (int)this.parent.field_146295_m, (int)-13948117);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(PIC);
        Gui.func_146110_a((int)(startX + 10), (int)(startY + 10), (float)0.0f, (float)0.0f, (int)64, (int)64, (float)64.0f, (float)64.0f);
        String name = I18n.func_135052_a((String)"gui.touhou_little_maid.portable_audio.play_list.name", (Object[])new Object[]{this.playList.getName()});
        this.parent.func_73731_b(fontRenderer, fontRenderer.func_78269_a(name, this.parent.field_146294_l - startX - 85 - 80 - 3), startX + 85, startY + 12, -1);
        String creator = I18n.func_135052_a((String)"gui.touhou_little_maid.portable_audio.play_list.creator", (Object[])new Object[]{this.playList.getCreator(), this.playList.getCreateTime()});
        this.parent.func_73731_b(fontRenderer, creator, startX + 85, startY + 26, 8553349);
        String desc = I18n.func_135052_a((String)"gui.touhou_little_maid.portable_audio.play_list.description", (Object[])new Object[]{this.playList.getDescription()});
        List test = fontRenderer.func_78271_c(this.trimStringNewline(desc), this.parent.field_146294_l - startX - 97);
        int y = startY + 38;
        for (int i = 0; i < Math.min(test.size(), 7); ++i) {
            fontRenderer.func_175065_a((String)test.get(i), (float)(startX + 85), (float)y, 11056835, false);
            y += fontRenderer.field_78288_b;
        }
        int cell = (this.parent.field_146294_l - startX - 58) / 5;
        this.parent.func_73731_b(fontRenderer, I18n.func_135052_a((String)"gui.touhou_little_maid.portable_audio.track.name", (Object[])new Object[0]), startX + 25, startY + 115, 0x757775);
        this.parent.func_73731_b(fontRenderer, I18n.func_135052_a((String)"gui.touhou_little_maid.portable_audio.track.artists", (Object[])new Object[0]), startX + 25 + cell * 2, startY + 115, 0x757775);
        this.parent.func_73731_b(fontRenderer, I18n.func_135052_a((String)"gui.touhou_little_maid.portable_audio.track.album", (Object[])new Object[0]), startX + 25 + cell * 3, startY + 115, 0x757775);
        this.parent.func_73731_b(fontRenderer, I18n.func_135052_a((String)"gui.touhou_little_maid.portable_audio.track.duration", (Object[])new Object[0]), this.parent.field_146294_l - 33, startY + 115, 0x757775);
    }

    protected void drawBackground() {
    }

    protected void drawScreen(int mouseX, int mouseY) {
    }

    protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        if (slotIdx >= this.playList.getTrackCount()) {
            return;
        }
        Minecraft mc = this.parent.field_146297_k;
        FontRenderer fontRenderer = mc.field_71466_p;
        NetEaseMusicList.Track track = this.playList.getTracks().get(slotIdx);
        int startX = 101;
        if (track != null) {
            int textColor = 0x757775;
            if (slotIdx % 2 == 0) {
                Gui.func_73734_a((int)0, (int)(slotTop - 2), (int)this.parent.field_146294_l, (int)(slotTop + this.slotHeight - 2), (int)-14145496);
            }
            if (this.isSelected(slotIdx)) {
                Gui.func_73734_a((int)0, (int)(slotTop - 2), (int)this.parent.field_146294_l, (int)(slotTop + this.slotHeight - 2), (int)-13487566);
                textColor = 11056835;
            }
            String index = slotIdx < 9 ? "0" : "";
            index = index + String.valueOf(slotIdx + 1);
            this.parent.func_73731_b(fontRenderer, index, startX + 20 - fontRenderer.func_78256_a(index), slotTop, textColor);
            this.parent.func_73731_b(fontRenderer, track.getDuration(), this.parent.field_146294_l - 33, slotTop, textColor);
            int cell = (this.parent.field_146294_l - startX - 58) / 5;
            this.parent.func_73731_b(fontRenderer, fontRenderer.func_78269_a(track.getName(), cell * 2 - 5), startX + 25, slotTop, 11056835);
            this.parent.func_73731_b(fontRenderer, fontRenderer.func_78269_a(track.getArtists(), cell - 5), startX + 25 + cell * 2, slotTop, textColor);
            this.parent.func_73731_b(fontRenderer, fontRenderer.func_78269_a(track.getAlbum(), cell * 2 - 5), startX + 25 + cell * 3, slotTop, textColor);
        }
    }

    private String trimStringNewline(String text) {
        while (text != null && text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }
}

