/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.client.audio.music.MusicJsonInfo;
import com.github.tartaricacid.touhoulittlemaid.client.audio.music.MusicManger;
import com.github.tartaricacid.touhoulittlemaid.client.audio.music.NetEaseMusicList;
import com.github.tartaricacid.touhoulittlemaid.client.gui.item.GuiMusicList;
import com.github.tartaricacid.touhoulittlemaid.client.gui.item.GuiMusicListGroup;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPortableAudio;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.PortableAudioMessageToServer;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class PortableAudioGui
extends GuiScreen {
    private static final ResourceLocation ICON = new ResourceLocation("touhou_little_maid", "textures/gui/netease_music_icon.png");
    protected static int LIST_INDEX;
    private final EntityPortableAudio audio;
    private final boolean isMusicListEmpty;
    protected GuiMusicList guiMusicList;
    private GuiMusicListGroup guiMusicListGroup;
    private GuiTextField musicListField;
    private String promptMsg = "";

    public PortableAudioGui(EntityPortableAudio audio) {
        this.audio = audio;
        this.isMusicListEmpty = MusicManger.MUSIC_LIST_GROUP.isEmpty();
    }

    public void func_73866_w_() {
        if (this.isMusicListEmpty) {
            return;
        }
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.musicListField = new GuiTextField(0, this.field_146297_k.field_71466_p, this.field_146294_l - 86, 5, 80, 14){

            public boolean func_146181_i() {
                return false;
            }
        };
        this.musicListField.func_146180_a(String.valueOf(MusicManger.MUSIC_LIST_GROUP.get(LIST_INDEX).getListId()));
        this.musicListField.func_146203_f(19);
        this.guiMusicList = new GuiMusicList(this);
        this.guiMusicListGroup = new GuiMusicListGroup(this);
        this.field_146292_n.add(new GuiButtonImage(1, this.field_146294_l / 2 - 33, this.field_146295_m - 19, 16, 16, 32, 0, 16, ICON));
        this.field_146292_n.add(new GuiButtonImage(2, this.field_146294_l / 2 - 8, this.field_146295_m - 19, 16, 16, 0, 0, 16, ICON));
        this.field_146292_n.add(new GuiButtonImage(3, this.field_146294_l / 2 + 17, this.field_146295_m - 19, 16, 16, 16, 0, 16, ICON));
        this.field_146292_n.add(new GuiButtonImage(4, this.field_146294_l - 105, 4, 16, 16, 48, 0, 16, ICON));
        this.field_146292_n.add(new VolumeButton(5, this.field_146294_l - 110, this.field_146295_m - 22));
        this.field_146292_n.add(new GuiButtonImage(6, this.field_146294_l / 2 + 42, this.field_146295_m - 19, 16, 16, 64, 0, 16, ICON));
        this.field_146292_n.add(new GuiButtonImage(7, this.field_146294_l - 122, 4, 16, 16, 80, 0, 16, ICON));
    }

    public void func_73876_c() {
        if (this.isMusicListEmpty) {
            return;
        }
        this.musicListField.func_146178_a();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.isMusicListEmpty) {
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -284159984, -284159984);
            this.field_146297_k.field_71466_p.func_78279_b(I18n.func_135052_a((String)"gui.touhou_little_maid.portable_audio.play_list.empty", (Object[])new Object[0]).replace("\\n", "\n"), (this.field_146294_l - 300) / 2, (this.field_146295_m - 170) / 2, 300, 0xFF1111);
            super.func_73863_a(mouseX, mouseY, partialTicks);
            return;
        }
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -11184811, -11184811);
        this.guiMusicList.drawScreen(mouseX, mouseY, partialTicks);
        this.guiMusicListGroup.drawScreen(mouseX, mouseY, partialTicks);
        this.func_73733_a(0, this.field_146295_m - 23, this.field_146294_l, this.field_146295_m, -14144460, -14144460);
        this.func_73733_a(0, 0, this.field_146294_l, 23, -14144460, -14144460);
        this.func_73733_a(this.field_146294_l - 86, 5, this.field_146294_l - 6, 19, -12828338, -12828338);
        this.musicListField.func_146194_f();
        this.func_73731_b(this.field_146297_k.field_71466_p, this.promptMsg, this.field_146294_l - 110 - this.field_146297_k.field_71466_p.func_78256_a(this.promptMsg), 8, 12466746);
        MusicJsonInfo info = MusicManger.MUSIC_LIST_GROUP.get(LIST_INDEX).getMusicJsonInfo();
        this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.touhou_little_maid.portable_audio.play_list.importer", (Object[])new Object[]{info.getCreator()}), 8, 8, 0x7E7C7E);
        NetEaseMusicList.PlayList playList = MusicManger.MUSIC_LIST_GROUP.get(Math.min(LIST_INDEX, MusicManger.MUSIC_LIST_GROUP.size() - 1)).getPlayList();
        if (GuiMusicList.MUSIC_INDEX < playList.getTrackCount()) {
            FontRenderer fontRenderer = this.field_146297_k.field_71466_p;
            RenderHelper.func_74520_c();
            this.field_146297_k.func_175599_af().func_180450_b(new ItemStack((Block)Blocks.field_150397_co, 1, 0), 3, this.field_146295_m - 19);
            this.field_146297_k.func_175599_af().func_180450_b(new ItemStack((Block)Blocks.field_150398_cm, 1, 0), 3, this.field_146295_m - 19);
            RenderHelper.func_74518_a();
            NetEaseMusicList.Track track = playList.getTracks().get(GuiMusicList.MUSIC_INDEX);
            this.func_73731_b(fontRenderer, fontRenderer.func_78269_a(track.getName(), this.field_146294_l / 2 - 63), 23, this.field_146295_m - 20, 14474724);
            this.func_73731_b(fontRenderer, fontRenderer.func_78269_a(track.getArtists(), this.field_146294_l / 2 - 63), 23, this.field_146295_m - 10, 0x757775);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) {
        NetEaseMusicList playList;
        if (this.isMusicListEmpty) {
            return;
        }
        if (button.field_146127_k == 1) {
            if (LIST_INDEX < MusicManger.MUSIC_LIST_GROUP.size()) {
                NetEaseMusicList.PlayList playList2 = MusicManger.MUSIC_LIST_GROUP.get(LIST_INDEX).getPlayList();
                GuiMusicList.MUSIC_INDEX = GuiMusicList.MUSIC_INDEX - 1 < 0 ? playList2.getTrackCount() - 1 : --GuiMusicList.MUSIC_INDEX;
                CommonProxy.INSTANCE.sendToServer((IMessage)new PortableAudioMessageToServer(this.audio.func_110124_au(), playList2, GuiMusicList.MUSIC_INDEX));
            }
            return;
        }
        if (button.field_146127_k == 2) {
            CommonProxy.INSTANCE.sendToServer((IMessage)PortableAudioMessageToServer.getStopMessage(this.audio.func_110124_au()));
            return;
        }
        if (button.field_146127_k == 3) {
            if (LIST_INDEX < MusicManger.MUSIC_LIST_GROUP.size()) {
                NetEaseMusicList.PlayList playList3 = MusicManger.MUSIC_LIST_GROUP.get(LIST_INDEX).getPlayList();
                GuiMusicList.MUSIC_INDEX = GuiMusicList.MUSIC_INDEX + 1 < playList3.getTrackCount() ? ++GuiMusicList.MUSIC_INDEX : 0;
                CommonProxy.INSTANCE.sendToServer((IMessage)new PortableAudioMessageToServer(this.audio.func_110124_au(), playList3, GuiMusicList.MUSIC_INDEX));
            }
            return;
        }
        if (button.field_146127_k == 4) {
            if (StringUtils.isNotBlank((CharSequence)this.musicListField.func_146179_b())) {
                try {
                    long id = Long.parseUnsignedLong(this.musicListField.func_146179_b());
                    MusicManger.addSingleList(id);
                }
                catch (NumberFormatException ignore) {
                    this.promptMsg = I18n.func_135052_a((String)"gui.touhou_little_maid.portable_audio.song_id.illegal", (Object[])new Object[0]);
                }
            }
            return;
        }
        if (button.field_146127_k == 6) {
            NetEaseMusicList playList4 = MusicManger.MUSIC_LIST_GROUP.get(LIST_INDEX);
            String listUrl = "https://music.163.com/#/playlist?id=" + playList4.getListId();
            GuiConfirmOpenLink openLink = new GuiConfirmOpenLink((GuiYesNoCallback)this, listUrl, 31102009, true);
            this.field_146297_k.func_147108_a((GuiScreen)openLink);
            return;
        }
        if (button.field_146127_k == 7 && MusicManger.removeSingleList((playList = MusicManger.MUSIC_LIST_GROUP.get(LIST_INDEX)).getListId())) {
            LIST_INDEX = 0;
            this.guiMusicList = new GuiMusicList(this);
        }
    }

    public void func_73878_a(boolean result, int id) {
        if (id == 31102009) {
            if (result) {
                try {
                    NetEaseMusicList playList = MusicManger.MUSIC_LIST_GROUP.get(LIST_INDEX);
                    URI uri = new URI("https://music.163.com/#/playlist?id=" + playList.getListId());
                    this.func_175282_a(uri);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.isMusicListEmpty) {
            return;
        }
        this.musicListField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.isMusicListEmpty) {
            return;
        }
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.guiMusicList.handleMouseInput(mouseX, mouseY);
        this.guiMusicListGroup.handleMouseInput(mouseX, mouseY);
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        super.func_73869_a(c, keyCode);
        if (this.isMusicListEmpty) {
            return;
        }
        if (Character.isDigit(c) || keyCode == 14 || keyCode == 211 || keyCode == 203 || keyCode == 205 || GuiScreen.func_175278_g((int)keyCode) || GuiScreen.func_175280_f((int)keyCode) || GuiScreen.func_175279_e((int)keyCode) || GuiScreen.func_175277_d((int)keyCode)) {
            this.musicListField.func_146201_a(c, keyCode);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public EntityPortableAudio getAudio() {
        return this.audio;
    }

    private static class VolumeButton
    extends GuiButton {
        public float volume = 1.0f;
        public boolean pressed;

        public VolumeButton(int buttonId, int x, int y) {
            super(buttonId, x, y, 100, 20, "");
            this.volume = Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.RECORDS);
        }

        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            this.func_146119_b(mc, mouseX, mouseY);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Gui.func_73734_a((int)this.field_146128_h, (int)(this.field_146129_i + 10), (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + 11), (int)-5262925);
            Gui.func_73734_a((int)this.field_146128_h, (int)(this.field_146129_i + 10), (int)(this.field_146128_h + (int)(this.volume * (float)this.field_146120_f)), (int)(this.field_146129_i + 11), (int)-5308416);
            Gui.func_73734_a((int)(this.field_146128_h + (int)(this.volume * (float)this.field_146120_f) - 6), (int)(this.field_146129_i + 7), (int)(this.field_146128_h + (int)(this.volume * (float)this.field_146120_f)), (int)(this.field_146129_i + 14), (int)-5262925);
        }

        protected void func_146119_b(@Nonnull Minecraft mc, int mouseX, int mouseY) {
            if (this.pressed) {
                this.volume = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.volume = MathHelper.func_76131_a((float)this.volume, (float)0.05f, (float)1.0f);
                mc.field_71474_y.func_186712_a(SoundCategory.RECORDS, this.volume);
                mc.field_71474_y.func_74303_b();
            }
        }

        public boolean func_146116_c(@Nonnull Minecraft mc, int mouseX, int mouseY) {
            boolean isInRange;
            boolean bl = isInRange = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            if (isInRange) {
                this.volume = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.volume = MathHelper.func_76131_a((float)this.volume, (float)0.05f, (float)1.0f);
                mc.field_71474_y.func_186712_a(SoundCategory.RECORDS, this.volume);
                mc.field_71474_y.func_74303_b();
                this.pressed = true;
                return true;
            }
            return false;
        }

        public void func_146113_a(@Nonnull SoundHandler soundHandlerIn) {
        }

        public void func_146118_a(int mouseX, int mouseY) {
            if (this.pressed) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
            this.pressed = false;
        }
    }
}

