/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.skin;

import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.vecmath.Point4d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractSkinDetailsGui<T extends EntityLivingBase, U extends IModelInfo>
extends GuiScreen {
    protected static final ResourceLocation BUTTON_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/gui/skin_detail.png");
    private static final float SCALE_MAX = 360.0f;
    private static final float SCALE_MIN = 18.0f;
    private static final float PITCH_MAX = 90.0f;
    private static final float PITCH_MIN = -90.0f;
    private static ScheduledExecutorService TIMER;
    private static Point4d BACKGROUND_SIZE;
    private static Point4d BOTTOM_STATUS_BAR_SIZE;
    private static Point4d SIDE_MENU_SIZE;
    private static Point4d TOP_STATUS_BAR_SIZE;
    protected T sourceEntity;
    protected U modelItem;
    protected volatile T guiEntity;
    protected volatile boolean isEnableWalk = false;
    private float posX = 0.0f;
    private float posY = -15.0f;
    private float scale = 80.0f;
    private float yaw = -45.0f;
    private float pitch = -30.0f;

    public AbstractSkinDetailsGui(T sourceEntity, T guiEntity, U modelItem) {
        this.sourceEntity = sourceEntity;
        this.guiEntity = guiEntity;
        this.modelItem = modelItem;
        this.simulationTickRun();
    }

    abstract void initSideButton();

    abstract void actionSideButtonPerformed(GuiButton var1);

    abstract void applyFloorButtonLogic();

    abstract void applyReturnButtonLogic();

    abstract void drawSideButtonText();

    abstract void drawSideButtonTooltips(int var1, int var2);

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        BACKGROUND_SIZE.set(0.0, 0.0, (double)this.field_146294_l, (double)this.field_146295_m);
        BOTTOM_STATUS_BAR_SIZE.set(0.0, (double)(this.field_146295_m - 16), (double)this.field_146294_l, (double)this.field_146295_m);
        SIDE_MENU_SIZE.set(0.0, 0.0, 132.0, (double)this.field_146295_m);
        TOP_STATUS_BAR_SIZE.set(0.0, 0.0, (double)this.field_146294_l, 15.0);
        this.drawGradientRect(BACKGROUND_SIZE, -32040675, -1000.0);
        this.drawEntity((this.field_146294_l + 132) / 2, this.field_146295_m / 2);
        this.drawDirections();
        this.drawBottomStatusBar();
        this.drawSideMenu();
        this.drawTopStatusBar();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawSideButtonText();
        this.drawButtonTooltips(mouseX, mouseY);
    }

    private void simulationTickRun() {
        TIMER = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("skin-details-gui-simulation-tick-schedule").daemon(true).build());
        TIMER.scheduleAtFixedRate(() -> {
            ++((EntityLivingBase)this.guiEntity).field_70173_aa;
            ((EntityLivingBase)this.guiEntity).field_184618_aE = ((EntityLivingBase)this.guiEntity).field_70721_aZ;
            float speed = this.isEnableWalk ? 0.5f : 0.0f;
            ((EntityLivingBase)this.guiEntity).field_70721_aZ += (speed - ((EntityLivingBase)this.guiEntity).field_70721_aZ) * 0.4f;
            ((EntityLivingBase)this.guiEntity).field_184619_aG += ((EntityLivingBase)this.guiEntity).field_70721_aZ;
        }, 0L, 50L, TimeUnit.MILLISECONDS);
    }

    public void func_146281_b() {
        this.field_146297_k.func_152344_a(this::closeThread);
    }

    private void closeThread() {
        TIMER.shutdownNow();
    }

    private void drawDirections() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.field_146294_l - 16), (float)(this.field_146295_m - 32), (float)-20.0f);
        GlStateManager.func_179114_b((float)this.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        OpenGlHelper.func_188785_m((int)12);
        GlStateManager.func_179121_F();
    }

    private void drawBottomStatusBar() {
        this.drawGradientRect(BOTTOM_STATUS_BAR_SIZE, -30921676, this.field_73735_i);
        String name = String.format("%s%s %s", TextFormatting.BOLD, "\u2714", ParseI18n.parse(this.modelItem.getName()));
        String info = String.format("%s%d FPS %.2f%%", TextFormatting.BOLD, Minecraft.func_175610_ah(), Float.valueOf(this.scale * 100.0f / 80.0f));
        this.field_146289_q.func_175065_a(name, 136.0f, (float)(this.field_146295_m - 12), 13290196, false);
        this.field_146289_q.func_175065_a(info, (float)(this.field_146294_l - this.field_146289_q.func_78256_a(info) - 4), (float)(this.field_146295_m - 12), 13290196, false);
    }

    private void drawSideMenu() {
        this.drawGradientRect(SIDE_MENU_SIZE, -31382229, this.field_73735_i);
    }

    private void drawTopStatusBar() {
        this.drawGradientRect(TOP_STATUS_BAR_SIZE, -30921676, this.field_73735_i);
        String title = String.format("%s%s", TextFormatting.BOLD, "Touhou Little Maid");
        this.field_146289_q.func_175065_a(title, 6.0f, 3.0f, 13290196, false);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        GuiButtonImage closeButton = new GuiButtonImage(BUTTON.CLOSE.getIndex(), this.field_146294_l - 15, 0, 15, 15, 0, 24, 15, BUTTON_TEXTURE);
        GuiButtonImage floorButton = new GuiButtonImage(BUTTON.SHOW_FLOOR.getIndex(), this.field_146294_l - 30, 0, 15, 15, 30, 24, 15, BUTTON_TEXTURE);
        GuiButtonImage returnButton = new GuiButtonImage(BUTTON.RETURN.getIndex(), this.field_146294_l - 45, 0, 15, 15, 15, 24, 15, BUTTON_TEXTURE);
        this.func_189646_b((GuiButton)closeButton);
        this.func_189646_b((GuiButton)floorButton);
        this.func_189646_b((GuiButton)returnButton);
        this.initSideButton();
    }

    protected void func_146284_a(GuiButton button) {
        switch (BUTTON.getButtonFromIndex(button.field_146127_k)) {
            case CLOSE: {
                this.applyCloseButtonLogic();
                return;
            }
            case SHOW_FLOOR: {
                this.applyFloorButtonLogic();
                return;
            }
            case RETURN: {
                this.applyReturnButtonLogic();
                return;
            }
        }
        this.actionSideButtonPerformed(button);
    }

    protected void applyCloseButtonLogic() {
        this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a(null));
    }

    private void drawButtonTooltips(int mouseX, int mouseY) {
        boolean isInHeightRange;
        boolean isInWidthRange = this.field_146294_l - 15 < mouseX && mouseX < this.field_146294_l;
        boolean bl = isInHeightRange = 0 < mouseY && mouseY < 15;
        if (isInWidthRange && isInHeightRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.close", (Object[])new Object[0]), mouseX + 16, mouseY + 24);
        }
        boolean bl2 = isInWidthRange = this.field_146294_l - 30 < mouseX && mouseX < this.field_146294_l - 15;
        if (isInWidthRange && isInHeightRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.floor", (Object[])new Object[0]), mouseX + 16, mouseY + 24);
        }
        boolean bl3 = isInWidthRange = this.field_146294_l - 45 < mouseX && mouseX < this.field_146294_l - 30;
        if (isInWidthRange && isInHeightRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.return", (Object[])new Object[0]), mouseX + 16, mouseY + 24);
        }
        this.drawSideButtonTooltips(mouseX, mouseY);
    }

    public void func_146274_d() throws IOException {
        boolean isInHeightRange;
        super.func_146274_d();
        int mouseX = Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int mouseDX = Mouse.getDX() * this.field_146294_l / this.field_146297_k.field_71443_c * 3;
        int mouseDY = -Mouse.getDY() * this.field_146295_m / this.field_146297_k.field_71440_d * 3;
        boolean isInWidthRange = 132 < mouseX && mouseX < this.field_146294_l - 1;
        boolean bl = isInHeightRange = 15 < mouseY && mouseY < this.field_146295_m - 16;
        if (!isInWidthRange || !isInHeightRange) {
            return;
        }
        if (Mouse.getEventDWheel() != 0) {
            this.changeScaleValue((float)Mouse.getEventDWheel() * 0.07f);
        }
        if (Mouse.isButtonDown((int)0)) {
            this.yaw += (float)mouseDX;
            this.changePitchValue(mouseDY);
        }
        if (Mouse.isButtonDown((int)1)) {
            this.posX += (float)mouseDX;
            this.posY += (float)mouseDY;
        }
    }

    private void changeScaleValue(float amount) {
        float tmp = this.scale + amount * this.scale / 80.0f;
        this.scale = MathHelper.func_76131_a((float)tmp, (float)18.0f, (float)360.0f);
    }

    private void changePitchValue(float amount) {
        this.pitch = this.pitch - amount > 90.0f ? 90.0f : (this.pitch - amount < -90.0f ? -90.0f : (this.pitch -= amount));
    }

    protected void drawEntityPre(RenderManager rendermanager, int middleWidth, int middleHeight) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.posX + (float)middleWidth), (float)(this.posY + (float)middleHeight), (float)-500.0f);
        GlStateManager.func_179114_b((float)this.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)(-this.scale), (float)this.scale, (float)this.scale);
        RenderHelper.func_74519_b();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
    }

    protected void drawEntityPost(RenderManager rendermanager) {
        rendermanager.func_178633_a(true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    protected void drawEntity(int middleWidth, int middleHeight) {
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        this.drawEntityPre(rendermanager, middleWidth, middleHeight);
        rendermanager.func_188391_a(this.guiEntity, 0.0, -1.0, 0.0, 0.0f, 0.0f, true);
        this.drawEntityPost(rendermanager);
    }

    private void drawGradientRect(Point4d size, int color, double zLevel) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b(size.z, size.y, zLevel).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(size.x, size.y, zLevel).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(size.x, size.w, zLevel).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(size.z, size.w, zLevel).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    static {
        BACKGROUND_SIZE = new Point4d();
        BOTTOM_STATUS_BAR_SIZE = new Point4d();
        SIDE_MENU_SIZE = new Point4d();
        TOP_STATUS_BAR_SIZE = new Point4d();
    }

    static enum BUTTON {
        CLOSE(943),
        SHOW_FLOOR(944),
        RETURN(945),
        OTHER(-1);

        private int index;

        private BUTTON(int index) {
            this.index = index;
        }

        static BUTTON getButtonFromIndex(int index) {
            for (BUTTON button : BUTTON.values()) {
                if (button.getIndex() != index) continue;
                return button;
            }
            return OTHER;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

