/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.skin;

import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.SkinGuiNumber;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractSkinGui<T extends EntityLivingBase, U extends IModelInfo>
extends GuiScreen {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/skin_select.png");
    private static final ResourceLocation SIDE = new ResourceLocation("touhou_little_maid", "textures/gui/skin_select_side.png");
    private static final HashMap<Integer, IModelInfo> BUTTON_MODEL_MAP = Maps.newHashMap();
    protected static String ENTITY_ID;
    protected T entity;
    private SkinGuiNumber<U> guiNumber;
    private List<CustomModelPack<U>> modelPackList;

    public AbstractSkinGui(T entity, List<CustomModelPack<U>> listPack, String entityId) {
        this.entity = entity;
        this.modelPackList = listPack;
        this.guiNumber = new SkinGuiNumber(this.modelPackList);
        this.setPageIndex(MathHelper.func_76125_a((int)this.getPageIndex(), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
        this.setPackIndex(MathHelper.func_76125_a((int)this.getPackIndex(), (int)0, (int)(this.guiNumber.getPackSize() - 1)));
        this.setRowIndex(MathHelper.func_76125_a((int)this.getRowIndex(), (int)0, (int)this.guiNumber.getRowSize(this.getPackIndex())));
        ENTITY_ID = entityId;
    }

    abstract void drawLeftEntity(int var1, int var2, float var3, float var4);

    abstract void drawRightEntity(int var1, int var2, U var3);

    abstract void openDetailsGui(T var1, ResourceLocation var2);

    abstract void notifyModelChange(T var1, U var2);

    abstract int getPackIndex();

    abstract void setPackIndex(int var1);

    abstract int getRowIndex();

    abstract void setRowIndex(int var1);

    abstract int getPageIndex();

    abstract void setPageIndex(int var1);

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        int i = this.field_146294_l / 2 + 50;
        int j = this.field_146295_m / 2 + 5;
        int id = 0;
        for (int index = 0; index < 7; ++index) {
            if (index == this.guiNumber.getTabIndex(this.getPackIndex())) {
                this.field_146292_n.add(new GuiButtonImage(id++, i - 98 + 28 * index, j - 108, 28, 31, 116, 224, 0, BG));
                continue;
            }
            if (index < this.guiNumber.getTabSize(this.getPackIndex())) {
                this.field_146292_n.add(new GuiButtonImage(id++, i - 98 + 28 * index, j - 105, 28, 25, 116, 194, 0, BG));
                continue;
            }
            GuiButtonImage buttonImage = new GuiButtonImage(id++, i - 98 + 28 * index, j - 105, 28, 25, 116, 194, 0, BG);
            buttonImage.field_146125_m = false;
            this.field_146292_n.add(buttonImage);
        }
        this.field_146292_n.add(new GuiButtonImage(id++, i + 122, j - 97, 21, 17, 58, 201, 18, BG));
        id = 8;
        GuiButton prePage = new GuiButton(id++, i - 119, j - 101, 20, 20, "<");
        GuiButton nextPage = new GuiButton(id++, i + 99, j - 101, 20, 20, ">");
        if (this.getPageIndex() == 0) {
            prePage.field_146124_l = false;
        }
        if (this.getPageIndex() == this.guiNumber.getPageSize() - 1) {
            nextPage.field_146124_l = false;
        }
        this.field_146292_n.add(prePage);
        this.field_146292_n.add(nextPage);
        CustomModelPack<U> pack = this.modelPackList.get(this.getPackIndex());
        int x = -100;
        int y = -35;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        int toIndex = this.guiNumber.modelToIndex(this.getPackIndex(), this.getRowIndex());
        BUTTON_MODEL_MAP.clear();
        for (IModelInfo modelItem : pack.getModelList().subList(fromIndex, toIndex)) {
            this.field_146292_n.add(new GuiButtonImage(id, i + x - 8, j + y - 26, 15, 24, 41, 201, 24, BG));
            BUTTON_MODEL_MAP.put(id, modelItem);
            ++id;
            if ((x += 20) <= 105) continue;
            x = -100;
            y += 30;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int middleX = this.field_146294_l / 2 + 50;
        int middleY = this.field_146295_m / 2 + 5;
        this.func_146276_q_();
        this.field_146297_k.field_71446_o.func_110577_a(BG);
        this.func_73729_b(middleX - 128, middleY - 80, 0, 0, 256, 180);
        this.field_146297_k.field_71446_o.func_110577_a(SIDE);
        this.func_73729_b(middleX - 128 + 250, middleY - 80, 0, 0, 24, 180);
        this.drawScrollSide(middleX, middleY);
        this.drawButton(mouseX, mouseY, partialTicks);
        this.drawTabIcon(middleX, middleY);
        this.drawLeftEntity(middleX, middleY, mouseX, mouseY);
        this.drawEntity(middleX, middleY);
        this.drawTooltips(mouseX, mouseY, middleX, middleY);
    }

    private void drawButton(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179094_E();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private void drawScrollSide(int middleX, int middleY) {
        if (this.guiNumber.canScroll(this.getPackIndex(), this.getRowIndex())) {
            this.func_73729_b(middleX - 128 + 254, middleY - 72 + (int)(149.0f * this.guiNumber.getCurrentScroll(this.getPackIndex(), this.getRowIndex())), 24, 0, 12, 15);
        } else {
            this.func_73729_b(middleX - 128 + 254, middleY - 72 + (int)(149.0f * this.guiNumber.getCurrentScroll(this.getPackIndex(), this.getRowIndex())), 36, 0, 12, 15);
        }
    }

    private void drawTabIcon(int middleX, int middleY) {
        int size = this.guiNumber.getTabSize(this.getPackIndex());
        for (int index = 0; index < size; ++index) {
            CustomModelPack<U> pack = this.modelPackList.get(this.guiNumber.tabToPackIndex(index, this.getPageIndex()));
            ResourceLocation icon = pack.getIcon();
            if (icon == null) continue;
            if (pack.getIconAnimation() == CustomModelPack.AnimationState.UNCHECK) {
                this.checkIconAnimation(pack, icon);
            }
            if (pack.getIconAnimation() == CustomModelPack.AnimationState.FALSE) {
                this.field_146297_k.field_71446_o.func_110577_a(icon);
                AbstractSkinGui.func_146110_a((int)(middleX - 92 + 28 * index), (int)(middleY - 98), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                continue;
            }
            this.field_146297_k.field_71446_o.func_110577_a(icon);
            int time = this.getTickTime() / pack.getIconDelay();
            int iconIndex = time % pack.getIconAspectRatio();
            AbstractSkinGui.func_146110_a((int)(middleX - 92 + 28 * index), (int)(middleY - 98), (float)0.0f, (float)(iconIndex * 16), (int)16, (int)16, (float)16.0f, (float)(16 * pack.getIconAspectRatio()));
        }
    }

    private int getTickTime() {
        return (int)Minecraft.func_71386_F() / 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIconAnimation(CustomModelPack<U> pack, ResourceLocation icon) {
        InputStream stream;
        block5: {
            stream = null;
            try {
                stream = this.field_146297_k.func_110442_L().func_110536_a(icon).func_110527_b();
                BufferedImage img = ImageIO.read(stream);
                if (img.getWidth() >= img.getHeight()) {
                    pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
                    break block5;
                }
                pack.setIconAnimation(CustomModelPack.AnimationState.TRUE);
                pack.setIconAspectRatio(img.getHeight() / img.getWidth());
            }
            catch (IOException ignore) {
                try {
                    pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    private void drawEntity(int middleX, int middleY) {
        CustomModelPack<U> pack = this.modelPackList.get(this.getPackIndex());
        this.drawPackInfoText(pack, middleX, middleY);
        int x = -100;
        int y = -38;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        int toIndex = this.guiNumber.modelToIndex(this.getPackIndex(), this.getRowIndex());
        for (IModelInfo modelItem : pack.getModelList().subList(fromIndex, toIndex)) {
            this.drawRightEntity(middleX + x, middleY + y, modelItem);
            if ((x += 20) <= 105) continue;
            x = -100;
            y += 30;
        }
    }

    private void drawPackInfoText(CustomModelPack<U> pack, int middleX, int middleY) {
        int offSet = -80;
        int sideMiddleX = (middleX - 128) / 2;
        String packName = ParseI18n.parse(pack.getPackName());
        List packNameSplit = this.field_146289_q.func_78271_c(packName, middleX - 128 - 20);
        for (String line : packNameSplit) {
            this.func_73732_a(this.field_146289_q, line, sideMiddleX, middleY + (offSet += 10), 0xFFFFFF);
        }
        for (String str : ParseI18n.parse(pack.getDescription())) {
            List split = this.field_146289_q.func_78271_c(str, middleX - 128 - 20);
            for (String line : split) {
                this.func_73732_a(this.field_146289_q, TextFormatting.GRAY + line, sideMiddleX, middleY + (offSet += 10), 0xFFFFFF);
            }
        }
        if (!pack.getAuthor().isEmpty()) {
            for (List textList : Lists.partition(pack.getAuthor(), (int)2)) {
                this.func_73732_a(this.field_146289_q, TextFormatting.GOLD + textList.toString(), sideMiddleX, middleY + (offSet += 10), 0xFFFFFF);
            }
        }
        if (pack.getVersion() != null) {
            this.func_73732_a(this.field_146289_q, TextFormatting.DARK_AQUA + I18n.func_135052_a((String)"gui.touhou_little_maid.skin.text.version", (Object[])new Object[]{pack.getVersion()}), sideMiddleX, middleY + (offSet += 10), 0xFFFFFF);
        }
        if (pack.getDate() != null) {
            this.func_73732_a(this.field_146289_q, TextFormatting.GREEN + I18n.func_135052_a((String)"gui.touhou_little_maid.skin.text.date", (Object[])new Object[]{pack.getDate()}), sideMiddleX, middleY + (offSet += 10), 0xFFFFFF);
        }
        this.func_73732_a(this.field_146289_q, String.format("%s/%s", this.getPageIndex() + 1, this.guiNumber.getPageSize()), middleX, middleY - 120, 0xFFFFFF);
    }

    private void drawTooltips(int mouseX, int mouseY, int middleX, int middleY) {
        boolean yInRange;
        boolean isyInRange;
        boolean isxInRange;
        CustomModelPack<U> pack = this.modelPackList.get(this.getPackIndex());
        int x = -100;
        int y = -35;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        int toIndex = this.guiNumber.modelToIndex(this.getPackIndex(), this.getRowIndex());
        for (IModelInfo modelItem : pack.getModelList().subList(fromIndex, toIndex)) {
            isxInRange = middleX + x - 8 < mouseX && mouseX < middleX + x + 7;
            boolean bl = isyInRange = middleY + y - 23 < mouseY && mouseY < middleY + y + 1;
            if (isxInRange && isyInRange) {
                ArrayList<String> str = new ArrayList<String>();
                str.add(modelItem.getName());
                str.addAll(modelItem.getDescription());
                str.add(TextFormatting.DARK_GRAY.toString() + TextFormatting.ITALIC.toString() + I18n.func_135052_a((String)"gui.touhou_little_maid.skin.tooltips.show_details", (Object[])new Object[0]));
                this.func_146283_a(ParseI18n.parse(str), mouseX, mouseY);
            }
            if ((x += 20) <= 105) continue;
            x = -100;
            y += 30;
        }
        int size = this.guiNumber.getTabSize(this.getPackIndex());
        for (int index = 0; index < size; ++index) {
            isxInRange = middleX - 98 + 28 * index < mouseX && mouseX < middleX - 98 + 28 * index + 28;
            boolean bl = isyInRange = middleY - 108 < mouseY && mouseY < middleY - 108 + 31;
            if (!isxInRange || !isyInRange) continue;
            CustomModelPack<U> hoverPack = this.modelPackList.get(this.guiNumber.tabToPackIndex(index, this.getPageIndex()));
            this.func_146279_a(ParseI18n.parse(hoverPack.getPackName()), mouseX, mouseY);
        }
        boolean xInRange = middleX + 122 < mouseX && mouseX < middleX + 143;
        boolean bl = yInRange = middleY - 97 < mouseY && mouseY < middleY - 80;
        if (xInRange && yInRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.skin.button.close", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (0 <= button.field_146127_k && button.field_146127_k < this.guiNumber.getTabSize(this.getPackIndex())) {
            this.setRowIndex(0);
            this.setPackIndex(this.guiNumber.tabToPackIndex(button.field_146127_k, this.getPageIndex()));
            this.func_73866_w_();
            return;
        }
        if (button.field_146127_k == 7) {
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a(null));
            return;
        }
        if (button.field_146127_k == 8) {
            this.setRowIndex(0);
            this.setPageIndex(MathHelper.func_76125_a((int)(this.getPageIndex() - 1), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
            this.setPackIndex(this.guiNumber.tabToPackIndex(0, this.getPageIndex()));
            this.func_73866_w_();
            return;
        }
        if (button.field_146127_k == 9) {
            this.setRowIndex(0);
            this.setPageIndex(MathHelper.func_76125_a((int)(this.getPageIndex() + 1), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
            this.setPackIndex(this.guiNumber.tabToPackIndex(0, this.getPageIndex()));
            this.func_73866_w_();
            return;
        }
        if (AbstractSkinGui.func_146272_n()) {
            this.openDetailsGui(this.entity, BUTTON_MODEL_MAP.get(button.field_146127_k).getModelId());
        } else {
            this.notifyModelChange(this.entity, BUTTON_MODEL_MAP.get(button.field_146127_k));
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int dWheel = Mouse.getEventDWheel();
        if (dWheel != 0) {
            int row;
            if (dWheel > 0) {
                dWheel = 1;
            }
            if (dWheel < 0) {
                dWheel = -1;
            }
            if ((row = MathHelper.func_76125_a((int)(this.getRowIndex() - dWheel), (int)0, (int)this.guiNumber.getRowSize(this.getPackIndex()))) != this.getRowIndex()) {
                this.setRowIndex(row);
                this.func_73866_w_();
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

