/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.skin;

import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.AbstractSkinDetailsGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.ChairSkinGui;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.ApplyChairSkinDataMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonToggle;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ChairSkinDetailsGui
extends AbstractSkinDetailsGui<EntityChair, ChairModelInfo> {
    private GuiButtonToggle characterButton;
    private GuiButtonToggle gravityButton;
    private ResourceLocation modelId;

    public ChairSkinDetailsGui(EntityChair sourceEntity, ResourceLocation modelId) {
        super(sourceEntity, new EntityChair(sourceEntity.field_70170_p), (IModelInfo)CustomResourcesLoader.CHAIR_MODEL.getInfo(modelId.toString()).orElseThrow(NullPointerException::new));
        this.modelId = modelId;
        ((EntityChair)this.guiEntity).setModelId(modelId.toString());
        ((EntityChair)this.guiEntity).setMountedHeight(((ChairModelInfo)this.modelItem).getMountedYOffset());
        ((EntityChair)this.guiEntity).setTameableCanRide(((ChairModelInfo)this.modelItem).isTameableCanRide());
        ((EntityChair)this.guiEntity).func_189654_d(((ChairModelInfo)this.modelItem).isNoGravity());
        ((EntityChair)this.guiEntity).isDebugFloorOpen = true;
    }

    @Override
    void initSideButton() {
        this.func_189646_b(new GuiButton(BUTTON.MIN_HEIGHT.ordinal(), 58, 20, 12, 12, "-"));
        this.func_189646_b(new GuiButton(BUTTON.ADD_HEIGHT.ordinal(), 118, 20, 12, 12, "+"));
        this.characterButton = new GuiButtonToggle(BUTTON.SHOW_CHARACTER.ordinal(), 2, 34, 128, 12, ((EntityChair)this.guiEntity).isDebugCharacterOpen);
        this.characterButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.func_189646_b((GuiButton)this.characterButton);
        this.gravityButton = new GuiButtonToggle(BUTTON.SET_GRAVITY.ordinal(), 2, 48, 128, 12, ((EntityChair)this.guiEntity).func_189652_ae());
        this.gravityButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.func_189646_b((GuiButton)this.gravityButton);
        this.func_189646_b(new GuiButton(BUTTON.APPLY_DATA.ordinal(), 2, 62, 128, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.apply_data", (Object[])new Object[0])));
    }

    @Override
    void actionSideButtonPerformed(GuiButton button) {
        switch (BUTTON.getButtonFromOrdinal(button.field_146127_k)) {
            case APPLY_DATA: {
                CommonProxy.INSTANCE.sendToServer((IMessage)new ApplyChairSkinDataMessage(((EntityChair)this.sourceEntity).func_110124_au(), this.modelId, ((EntityChair)this.guiEntity).getMountedHeight(), ((EntityChair)this.guiEntity).isTameableCanRide(), ((EntityChair)this.guiEntity).func_189652_ae()));
                return;
            }
            case MIN_HEIGHT: {
                if (ChairSkinDetailsGui.func_146272_n()) {
                    ((EntityChair)this.guiEntity).setMountedHeight(((EntityChair)this.guiEntity).getMountedHeight() - 0.5f);
                } else {
                    ((EntityChair)this.guiEntity).setMountedHeight(((EntityChair)this.guiEntity).getMountedHeight() - 0.0625f);
                }
                return;
            }
            case ADD_HEIGHT: {
                if (ChairSkinDetailsGui.func_146272_n()) {
                    ((EntityChair)this.guiEntity).setMountedHeight(((EntityChair)this.guiEntity).getMountedHeight() + 0.5f);
                } else {
                    ((EntityChair)this.guiEntity).setMountedHeight(((EntityChair)this.guiEntity).getMountedHeight() + 0.0625f);
                }
                return;
            }
            case SHOW_CHARACTER: {
                this.applyShowCharacterLogic();
                return;
            }
            case SET_GRAVITY: {
                this.applySetGravityLogic();
                return;
            }
        }
    }

    @Override
    void applyFloorButtonLogic() {
        ((EntityChair)this.guiEntity).isDebugFloorOpen = !((EntityChair)this.guiEntity).isDebugFloorOpen;
    }

    @Override
    void applyReturnButtonLogic() {
        this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new ChairSkinGui((EntityChair)this.sourceEntity)));
    }

    @Override
    void drawSideButtonText() {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.mounted_height", (Object[])new Object[0]), 5, 22, 13290196);
        String data = String.format("%.2f", Float.valueOf(((EntityChair)this.guiEntity).getMountedHeight() / 0.0625f + 3.0f));
        this.field_146289_q.func_78276_b(data, (188 - this.field_146289_q.func_78256_a(data)) / 2, 22, 13290196);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.show_character", (Object[])new Object[0]), 16, 36, 13290196);
        this.field_146289_q.func_78276_b(this.getGravityButtonText(((EntityChair)this.guiEntity).func_189652_ae()), 16, 50, 13290196);
    }

    @Override
    void drawSideButtonTooltips(int mouseX, int mouseY) {
        boolean isInHeightRange;
        boolean isInWidthRange = 58 < mouseX && mouseX < 70 || 118 < mouseX && mouseX < 130;
        boolean bl = isInHeightRange = 20 < mouseY && mouseY < 32;
        if (isInWidthRange && isInHeightRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.mounted_height.button.tooltips", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    private void applyShowCharacterLogic() {
        ((EntityChair)this.guiEntity).isDebugCharacterOpen = !((EntityChair)this.guiEntity).isDebugCharacterOpen;
        this.characterButton.func_191753_b(((EntityChair)this.guiEntity).isDebugCharacterOpen);
    }

    private void applySetGravityLogic() {
        ((EntityChair)this.guiEntity).func_189654_d(!((EntityChair)this.guiEntity).func_189652_ae());
        this.gravityButton.func_191753_b(((EntityChair)this.guiEntity).func_189652_ae());
    }

    private String getGravityButtonText(boolean isNoGravity) {
        return I18n.func_135052_a((String)String.format("gui.touhou_little_maid.skin_details.set_gravity.button.%s", isNoGravity), (Object[])new Object[0]);
    }

    static enum BUTTON {
        MIN_HEIGHT,
        ADD_HEIGHT,
        SHOW_CHARACTER,
        APPLY_DATA,
        SET_GRAVITY;


        static BUTTON getButtonFromOrdinal(int ordinal) {
            for (BUTTON button : BUTTON.values()) {
                if (button.ordinal() != ordinal) continue;
                return button;
            }
            return ADD_HEIGHT;
        }
    }
}

