/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.skin;

import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.AbstractSkinGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.ChairSkinDetailsGui;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.ApplyChairSkinDataMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ChairSkinGui
extends AbstractSkinGui<EntityChair, ChairModelInfo> {
    private static final ResourceLocation ICON0 = new ResourceLocation("textures/items/spawn_egg.png");
    private static final ResourceLocation ICON1 = new ResourceLocation("textures/items/spawn_egg_overlay.png");
    private static int PAGE_INDEX = 0;
    private static int PACK_INDEX = 0;
    private static int ROW_INDEX = 0;

    public ChairSkinGui(EntityChair chair) {
        super(chair, CustomResourcesLoader.CHAIR_MODEL.getPackList(), "touhou_little_maid:entity.item.chair");
    }

    @Override
    void drawLeftEntity(int middleX, int middleY, float mouseX, float mouseY) {
        float renderItemScale = CustomResourcesLoader.CHAIR_MODEL.getModelRenderItemScale(((EntityChair)this.entity).getModelId());
        GuiInventory.func_147046_a((int)((middleX - 128) / 2), (int)(middleY + 80), (int)((int)(45.0f * renderItemScale)), (float)-25.0f, (float)-20.0f, (EntityLivingBase)this.entity);
    }

    @Override
    void drawRightEntity(int posX, int posY, ChairModelInfo modelItem) {
        if (!GeneralConfig.MISC_CONFIG.fastRendering) {
            EntityChair chair;
            try {
                chair = (EntityChair)((Object)EntityCacheUtil.ENTITY_CACHE.get((Object)ENTITY_ID, () -> {
                    Entity e = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(ENTITY_ID), (World)this.field_146297_k.field_71441_e);
                    if (e == null) {
                        return new EntityChair((World)this.field_146297_k.field_71441_e);
                    }
                    return e;
                }));
            }
            catch (ClassCastException | ExecutionException e) {
                e.printStackTrace();
                return;
            }
            chair.setModelId(modelItem.getModelId().toString());
            GuiInventory.func_147046_a((int)posX, (int)posY, (int)((int)(12.0f * modelItem.getRenderItemScale())), (float)-25.0f, (float)-20.0f, (EntityLivingBase)chair);
        } else {
            float[] rgb0 = this.getRgbFromHash(modelItem.getName().hashCode());
            GlStateManager.func_179124_c((float)rgb0[0], (float)rgb0[1], (float)rgb0[2]);
            this.field_146297_k.field_71446_o.func_110577_a(ICON0);
            ChairSkinGui.func_146110_a((int)(posX - 8), (int)(posY - 20), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            float[] rgb1 = this.getRgbFromHash(modelItem.getModelId().hashCode());
            GlStateManager.func_179124_c((float)rgb1[0], (float)rgb1[1], (float)rgb1[2]);
            this.field_146297_k.field_71446_o.func_110577_a(ICON1);
            ChairSkinGui.func_146110_a((int)(posX - 8), (int)(posY - 20), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
    }

    private float[] getRgbFromHash(int hashCode) {
        float r = (float)(hashCode >> 16 & 0xFF) / 255.0f;
        float g = (float)(hashCode >> 8 & 0xFF) / 255.0f;
        float b = (float)(hashCode & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }

    @Override
    void openDetailsGui(EntityChair chair, ResourceLocation modelId) {
        this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new ChairSkinDetailsGui(chair, modelId)));
    }

    @Override
    void notifyModelChange(EntityChair chair, ChairModelInfo info) {
        CommonProxy.INSTANCE.sendToServer((IMessage)new ApplyChairSkinDataMessage(chair.func_110124_au(), info.getModelId(), info.getMountedYOffset(), info.isTameableCanRide(), info.isNoGravity()));
    }

    @Override
    int getPageIndex() {
        return PAGE_INDEX;
    }

    @Override
    void setPageIndex(int pageIndex) {
        PAGE_INDEX = pageIndex;
    }

    @Override
    int getPackIndex() {
        return PACK_INDEX;
    }

    @Override
    void setPackIndex(int packIndex) {
        PACK_INDEX = packIndex;
    }

    @Override
    int getRowIndex() {
        return ROW_INDEX;
    }

    @Override
    void setRowIndex(int rowIndex) {
        ROW_INDEX = rowIndex;
    }
}

