/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.skin;

import com.github.tartaricacid.touhoulittlemaid.client.model.HataSasimonoFlagModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.HataSasimonoFrameModel;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SetMaidSasimonoCRC32;
import com.github.tartaricacid.touhoulittlemaid.proxy.ClientProxy;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Iterator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class MaidHataSelect
extends GuiScreen {
    private static final ModelBase HATA_SASIMONO_FLAG_MODEL = new HataSasimonoFlagModel();
    private static final ModelBase HATA_SASIMONO_FRAME_MODEL = new HataSasimonoFrameModel();
    private static final ResourceLocation FRAME_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/hata_sasimono.png");
    private EntityMaid maid;
    private Long hataCrc32;
    private int index = 0;
    private boolean isShowSasimono;
    private GuiButton showHideButton;

    public MaidHataSelect(EntityMaid maid) {
        this.maid = maid;
        this.hataCrc32 = maid.getSasimonoCRC32();
        this.isShowSasimono = maid.isShowSasimono();
        for (Long crc32 : ClientProxy.HATA_NAME_MAP.keySet()) {
            if (maid.getSasimonoCRC32().equals(crc32)) break;
            ++this.index;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -300937200, -300937200);
        this.drawTopListModel();
        this.drawBottomReferenceModel();
        this.showHideButton.field_146126_j = this.isShowSasimono ? I18n.func_135052_a((String)"gui.touhou_little_maid.hata_select.display.true", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.touhou_little_maid.hata_select.display.false", (Object[])new Object[0]);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, String.format("%s%d/%d", TextFormatting.BOLD, this.index + 1, ClientProxy.HATA_NAME_MAP.size()), this.field_146294_l / 2, this.field_146295_m / 17, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.touhou_little_maid.hata_select.scroll", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m * 2 / 17, 0xFFFFFF);
    }

    private void drawTopListModel() {
        Iterator iterable = Iterators.cycle(ClientProxy.HATA_NAME_MAP.keySet());
        if (ClientProxy.HATA_NAME_MAP.keySet().size() < 1) {
            return;
        }
        for (int j = 0; j < this.index; ++j) {
            iterable.next();
        }
        Long tmpCrc32 = this.hataCrc32 = (Long)iterable.next();
        for (int i = 5; i < this.field_146294_l - 29; i += 24) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179109_b((float)i, (float)(this.field_146295_m * 2 / 5), (float)100.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179144_i((int)ClientProxy.HATA_NAME_MAP.get(tmpCrc32));
            HATA_SASIMONO_FLAG_MODEL.func_78088_a((Entity)this.maid, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f);
            this.field_146297_k.field_71446_o.func_110577_a(FRAME_TEXTURE);
            HATA_SASIMONO_FRAME_MODEL.func_78088_a((Entity)this.maid, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179121_F();
            tmpCrc32 = (Long)iterable.next();
        }
    }

    private void drawBottomReferenceModel() {
        if (this.isShowSasimono) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.field_146294_l / 4), (float)(this.field_146295_m * 4 / 5), (float)100.0f);
            this.drawHataModel(this.hataCrc32, 90.0f);
            this.drawHataModel(this.hataCrc32, -90.0f);
            GlStateManager.func_179121_F();
        }
    }

    private void drawHataModel(Long crc32, float angle) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179089_o();
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179144_i((int)ClientProxy.HATA_NAME_MAP.get(crc32));
        HATA_SASIMONO_FLAG_MODEL.func_78088_a((Entity)this.maid, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f);
        this.field_146297_k.field_71446_o.func_110577_a(FRAME_TEXTURE);
        HATA_SASIMONO_FRAME_MODEL.func_78088_a((Entity)this.maid, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f);
        GlStateManager.func_179129_p();
        GlStateManager.func_179121_F();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (Mouse.getEventDWheel() != 0) {
            this.index = Mouse.getEventDWheel() < 0 ? this.indexCycle(this.index + 1) : this.indexCycle(this.index - 1);
        }
    }

    private int indexCycle(int indexNext) {
        int size = ClientProxy.HATA_NAME_MAP.size();
        if (0 <= indexNext && indexNext < size) {
            return indexNext;
        }
        if (indexNext < 0) {
            return size - 1;
        }
        return 0;
    }

    public void func_73866_w_() {
        this.func_189646_b(new GuiButton(BUTTON.APPLY.ordinal(), this.field_146294_l * 2 / 5, this.field_146295_m * 4 / 5 - 36, 100, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.hata_select.apply", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(BUTTON.DISASSEMBLY.ordinal(), this.field_146294_l * 2 / 5 + 104, this.field_146295_m * 4 / 5 - 36, 100, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.hata_select.disassembly", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(BUTTON.CLOSE.ordinal(), this.field_146294_l * 2 / 5, this.field_146295_m * 4 / 5 - 12, 100, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.hata_select.close", (Object[])new Object[0])));
        this.showHideButton = new GuiButton(BUTTON.SHOW_HIDE.ordinal(), this.field_146294_l * 2 / 5 + 104, this.field_146295_m * 4 / 5 - 12, 100, 20, "");
        this.func_189646_b(this.showHideButton);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == BUTTON.APPLY.ordinal()) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new SetMaidSasimonoCRC32(this.maid.func_110124_au(), this.hataCrc32, this.maid.isShowSasimono()));
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a(null));
        }
        if (button.field_146127_k == BUTTON.CLOSE.ordinal()) {
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a(null));
        }
        if (button.field_146127_k == BUTTON.SHOW_HIDE.ordinal()) {
            this.isShowSasimono = !this.isShowSasimono;
            CommonProxy.INSTANCE.sendToServer((IMessage)new SetMaidSasimonoCRC32(this.maid.func_110124_au(), this.maid.getSasimonoCRC32(), this.isShowSasimono));
        }
        if (button.field_146127_k == BUTTON.DISASSEMBLY.ordinal()) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new SetMaidSasimonoCRC32(this.maid.func_110124_au(), Long.MIN_VALUE, this.isShowSasimono));
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a(null));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    static enum BUTTON {
        CLOSE,
        APPLY,
        SHOW_HIDE,
        DISASSEMBLY;

    }
}

