/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.skin;

import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.AbstractSkinDetailsGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.MaidSkinGui;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityMarisaBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.proxy.ClientProxy;
import java.util.Random;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonToggle;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MaidSkinDetailsGui
extends AbstractSkinDetailsGui<EntityMaid, MaidModelInfo> {
    private static final ItemStack MAIN_HAND_SWORD = Items.field_151048_u.func_190903_i();
    private static final ItemStack OFF_HAND_SHIELD = Items.field_185159_cQ.func_190903_i();
    private static final ItemStack ARMOR_ITEM = Items.field_151169_ag.func_190903_i();
    private static final Random RANDOM = new Random();
    private EntityMarisaBroom marisaBroom;
    private GuiButtonToggle begButton;
    private GuiButtonToggle walkButton;
    private GuiButtonToggle sitButton;
    private GuiButtonToggle rideButton;
    private GuiButtonToggle rideBroomButton;
    private GuiButtonToggle helmetButton;
    private GuiButtonToggle chestPlateButton;
    private GuiButtonToggle leggingsButton;
    private GuiButtonToggle bootsButton;
    private GuiButtonToggle mainHandButton;
    private GuiButtonToggle offHandButton;
    private GuiButtonToggle hataSasimonoButton;
    private GuiButtonToggle arrowButton;

    MaidSkinDetailsGui(EntityMaid sourceMaid, ResourceLocation modelId) {
        super(sourceMaid, new EntityMaid(sourceMaid.field_70170_p), (IModelInfo)CustomResourcesLoader.MAID_MODEL.getInfo(modelId.toString()).orElseThrow(NullPointerException::new));
        this.marisaBroom = new EntityMarisaBroom(sourceMaid.field_70170_p);
        ((EntityMaid)this.guiEntity).setModelId(modelId.toString());
        ((EntityMaid)this.guiEntity).isDebugFloorOpen = true;
    }

    @Override
    void initSideButton() {
        this.begButton = new GuiButtonToggle(BUTTON.BEG.ordinal(), 2, 17, 128, 12, ((EntityMaid)this.guiEntity).isBegging());
        this.begButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.walkButton = new GuiButtonToggle(BUTTON.WALK.ordinal(), 2, 30, 128, 12, this.isEnableWalk);
        this.walkButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.sitButton = new GuiButtonToggle(BUTTON.SIT.ordinal(), 2, 43, 128, 12, ((EntityMaid)this.guiEntity).func_70906_o());
        this.sitButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.rideButton = new GuiButtonToggle(BUTTON.RIDE.ordinal(), 2, 56, 128, 12, ((EntityMaid)this.guiEntity).func_184218_aH());
        this.rideButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.rideBroomButton = new GuiButtonToggle(BUTTON.RIDE_BROOM.ordinal(), 2, 69, 128, 12, ((EntityMaid)this.guiEntity).isDebugBroomShow);
        this.rideBroomButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.helmetButton = new GuiButtonToggle(BUTTON.HELMET.ordinal(), 2, 82, 128, 12, !((EntityMaid)this.guiEntity).func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b());
        this.helmetButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.chestPlateButton = new GuiButtonToggle(BUTTON.CHEST_PLATE.ordinal(), 2, 95, 128, 12, !((EntityMaid)this.guiEntity).func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b());
        this.chestPlateButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.leggingsButton = new GuiButtonToggle(BUTTON.LEGGINGS.ordinal(), 2, 108, 128, 12, !((EntityMaid)this.guiEntity).func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b());
        this.leggingsButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.bootsButton = new GuiButtonToggle(BUTTON.BOOTS.ordinal(), 2, 121, 128, 12, !((EntityMaid)this.guiEntity).func_184582_a(EntityEquipmentSlot.FEET).func_190926_b());
        this.bootsButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.mainHandButton = new GuiButtonToggle(BUTTON.MAIN_HAND.ordinal(), 2, 134, 128, 12, !((EntityMaid)this.guiEntity).func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b());
        this.mainHandButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.offHandButton = new GuiButtonToggle(BUTTON.OFF_HAND.ordinal(), 2, 147, 128, 12, !((EntityMaid)this.guiEntity).func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b());
        this.offHandButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.hataSasimonoButton = new GuiButtonToggle(BUTTON.HATA_SASIMONO.ordinal(), 2, 160, 128, 12, ((EntityMaid)this.guiEntity).isShowSasimono());
        this.hataSasimonoButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.arrowButton = new GuiButtonToggle(BUTTON.ARROW.ordinal(), 2, 173, 128, 12, ((EntityMaid)this.guiEntity).func_85035_bI() > 0);
        this.arrowButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.func_189646_b((GuiButton)this.begButton);
        this.func_189646_b((GuiButton)this.walkButton);
        this.func_189646_b((GuiButton)this.sitButton);
        this.func_189646_b((GuiButton)this.rideButton);
        this.func_189646_b((GuiButton)this.rideBroomButton);
        this.func_189646_b((GuiButton)this.helmetButton);
        this.func_189646_b((GuiButton)this.chestPlateButton);
        this.func_189646_b((GuiButton)this.leggingsButton);
        this.func_189646_b((GuiButton)this.bootsButton);
        this.func_189646_b((GuiButton)this.mainHandButton);
        this.func_189646_b((GuiButton)this.offHandButton);
        this.func_189646_b((GuiButton)this.hataSasimonoButton);
        this.func_189646_b((GuiButton)this.arrowButton);
    }

    @Override
    void drawSideButtonText() {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.beg", (Object[])new Object[0]), 16, 19, 13290196);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.walk", (Object[])new Object[0]), 16, 32, 13290196);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.sit", (Object[])new Object[0]), 16, 45, 13290196);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.ride", (Object[])new Object[0]), 16, 58, 13290196);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.ride_broom", (Object[])new Object[0]), 16, 71, 13290196);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.helmet", (Object[])new Object[0]), 16, 84, 13290196);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.chest_plate", (Object[])new Object[0]), 16, 97, 13290196);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.leggings", (Object[])new Object[0]), 16, 110, 13290196);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.boots", (Object[])new Object[0]), 16, 123, 13290196);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.main_hand", (Object[])new Object[0]), 16, 136, 13290196);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.off_hand", (Object[])new Object[0]), 16, 149, 13290196);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.hata_sasimono", (Object[])new Object[0]), 16, 162, 13290196);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.arrow", (Object[])new Object[0]), 16, 175, 13290196);
    }

    @Override
    void actionSideButtonPerformed(GuiButton button) {
        switch (BUTTON.getButtonFromOrdinal(button.field_146127_k)) {
            case BEG: {
                this.applyBegButtonLogic();
                return;
            }
            case WALK: {
                this.applyWalkButtonLogic();
                return;
            }
            case SIT: {
                this.applySitButtonLogic();
                return;
            }
            case RIDE: {
                this.applyRideButtonLogic();
                return;
            }
            case RIDE_BROOM: {
                this.applyRideBroomButtonLogic();
                return;
            }
            case HELMET: {
                this.applyEquipmentButtonLogic(EntityEquipmentSlot.HEAD);
                return;
            }
            case CHEST_PLATE: {
                this.applyEquipmentButtonLogic(EntityEquipmentSlot.CHEST);
                return;
            }
            case LEGGINGS: {
                this.applyEquipmentButtonLogic(EntityEquipmentSlot.LEGS);
                return;
            }
            case BOOTS: {
                this.applyEquipmentButtonLogic(EntityEquipmentSlot.FEET);
                return;
            }
            case MAIN_HAND: {
                this.applyEquipmentButtonLogic(EntityEquipmentSlot.MAINHAND);
                return;
            }
            case OFF_HAND: {
                this.applyEquipmentButtonLogic(EntityEquipmentSlot.OFFHAND);
                return;
            }
            case HATA_SASIMONO: {
                this.applyHataSasimonoButtonLogic();
                return;
            }
            case ARROW: {
                this.applyArrowButtonLogic();
                return;
            }
        }
        super.applyCloseButtonLogic();
    }

    @Override
    public void applyFloorButtonLogic() {
        ((EntityMaid)this.guiEntity).isDebugFloorOpen = !((EntityMaid)this.guiEntity).isDebugFloorOpen;
    }

    @Override
    public void applyReturnButtonLogic() {
        this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new MaidSkinGui((EntityMaid)this.sourceEntity)));
    }

    @Override
    void drawSideButtonTooltips(int mouseX, int mouseY) {
    }

    private void applyBegButtonLogic() {
        this.begButton.func_191753_b(!this.begButton.func_191754_c());
        ((EntityMaid)this.guiEntity).setBegging(!((EntityMaid)this.guiEntity).isBegging());
    }

    private void applyWalkButtonLogic() {
        this.walkButton.func_191753_b(!this.walkButton.func_191754_c());
        boolean bl = this.isEnableWalk = !this.isEnableWalk;
        if (this.walkButton.func_191754_c()) {
            this.applyConflictReset(BUTTON.WALK);
        }
    }

    private void applySitButtonLogic() {
        this.sitButton.func_191753_b(!this.sitButton.func_191754_c());
        ((EntityMaid)this.guiEntity).func_70904_g(!((EntityMaid)this.guiEntity).func_70906_o());
        if (this.sitButton.func_191754_c()) {
            this.applyConflictReset(BUTTON.SIT);
        }
    }

    private void applyRideButtonLogic() {
        this.rideButton.func_191753_b(!this.rideButton.func_191754_c());
        if (this.rideButton.func_191754_c()) {
            this.applyConflictReset(BUTTON.RIDE);
            ((EntityMaid)this.guiEntity).func_184220_m((Entity)this.marisaBroom);
        } else {
            ((EntityMaid)this.guiEntity).func_184210_p();
        }
    }

    private void applyRideBroomButtonLogic() {
        this.rideBroomButton.func_191753_b(!this.rideBroomButton.func_191754_c());
        boolean bl = ((EntityMaid)this.guiEntity).isDebugBroomShow = !((EntityMaid)this.guiEntity).isDebugBroomShow;
        if (this.rideBroomButton.func_191754_c()) {
            this.applyConflictReset(BUTTON.RIDE_BROOM);
        }
    }

    private void applyEquipmentButtonLogic(EntityEquipmentSlot slot) {
        if (!((EntityMaid)this.guiEntity).func_184582_a(slot).func_190926_b()) {
            ((EntityMaid)this.guiEntity).func_184201_a(slot, ItemStack.field_190927_a);
            this.setEquipmentStateTriggered(slot, false);
        } else {
            if (slot == EntityEquipmentSlot.MAINHAND) {
                ((EntityMaid)this.guiEntity).func_184201_a(slot, MAIN_HAND_SWORD);
            } else if (slot == EntityEquipmentSlot.OFFHAND) {
                ((EntityMaid)this.guiEntity).func_184201_a(slot, OFF_HAND_SHIELD);
            } else {
                ((EntityMaid)this.guiEntity).func_184201_a(slot, ARMOR_ITEM);
            }
            this.setEquipmentStateTriggered(slot, true);
        }
    }

    private void applyHataSasimonoButtonLogic() {
        this.hataSasimonoButton.func_191753_b(!this.hataSasimonoButton.func_191754_c());
        if (this.hataSasimonoButton.func_191754_c()) {
            Object[] key = ClientProxy.HATA_NAME_MAP.keySet().toArray();
            ((EntityMaid)this.guiEntity).setSasimonoCRC32((Long)key[RANDOM.nextInt(key.length)]);
            ((EntityMaid)this.guiEntity).setShowSasimono(true);
        } else {
            ((EntityMaid)this.guiEntity).setShowSasimono(false);
        }
    }

    private void applyArrowButtonLogic() {
        this.arrowButton.func_191753_b(!this.arrowButton.func_191754_c());
        if (this.arrowButton.func_191754_c()) {
            ((EntityMaid)this.guiEntity).func_85034_r(9);
        } else {
            ((EntityMaid)this.guiEntity).func_85034_r(0);
        }
    }

    private void setEquipmentStateTriggered(EntityEquipmentSlot slot, boolean state) {
        switch (slot) {
            case HEAD: {
                this.helmetButton.func_191753_b(state);
                return;
            }
            case CHEST: {
                this.chestPlateButton.func_191753_b(state);
                return;
            }
            case LEGS: {
                this.leggingsButton.func_191753_b(state);
                return;
            }
            case FEET: {
                this.bootsButton.func_191753_b(state);
                return;
            }
            case MAINHAND: {
                this.mainHandButton.func_191753_b(state);
                return;
            }
            case OFFHAND: {
                this.offHandButton.func_191753_b(state);
                return;
            }
        }
    }

    private void applyConflictReset(BUTTON button) {
        if (button != BUTTON.WALK) {
            this.isEnableWalk = false;
            this.walkButton.func_191753_b(false);
        }
        if (button != BUTTON.SIT) {
            ((EntityMaid)this.guiEntity).func_70904_g(false);
            this.sitButton.func_191753_b(false);
        }
        if (button != BUTTON.RIDE) {
            ((EntityMaid)this.guiEntity).func_184210_p();
            this.rideButton.func_191753_b(false);
        }
        if (button != BUTTON.RIDE_BROOM) {
            ((EntityMaid)this.guiEntity).isDebugBroomShow = false;
            this.rideBroomButton.func_191753_b(false);
        }
    }

    @Override
    public void func_146281_b() {
        ((EntityMaid)this.guiEntity).func_184210_p();
        super.func_146281_b();
    }

    static enum BUTTON {
        BEG,
        WALK,
        SIT,
        RIDE,
        RIDE_BROOM,
        HELMET,
        CHEST_PLATE,
        LEGGINGS,
        BOOTS,
        MAIN_HAND,
        OFF_HAND,
        HATA_SASIMONO,
        ARROW;


        static BUTTON getButtonFromOrdinal(int ordinal) {
            for (BUTTON button : BUTTON.values()) {
                if (button.ordinal() != ordinal) continue;
                return button;
            }
            return BEG;
        }
    }
}

