/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.sound;

import com.github.tartaricacid.touhoulittlemaid.client.gui.sound.GuiMaidSound;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.SoundPackInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

@SideOnly(value=Side.CLIENT)
public class GuiInfoList
extends GuiScrollingList {
    private GuiMaidSound parent;

    public GuiInfoList(GuiMaidSound parent) {
        super(parent.field_146297_k, parent.field_146294_l - 210, parent.field_146295_m, 20, parent.field_146295_m - 8, 8, 90, parent.field_146294_l, parent.field_146295_m);
        this.parent = parent;
        this.setHeaderInfo(true, 16);
    }

    protected int getSize() {
        return CustomResourcesLoader.SOUND_INFO.getInfoList().size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        SoundPackInfo info;
        this.parent.setInfoIndex(index);
        if (doubleClick && StringUtils.isNotBlank((CharSequence)(info = CustomResourcesLoader.SOUND_INFO.getInfoList().get(index)).getUrl())) {
            ITextComponent urlText = ForgeHooks.newChatWithLinks((String)info.getUrl());
            this.parent.func_175276_a(urlText);
        }
    }

    protected boolean isSelected(int index) {
        return this.parent.getInfoIndex() == index;
    }

    protected void drawBackground() {
    }

    protected void drawHeader(int entryRight, int relativeY, Tessellator tess) {
        this.parent.func_73732_a(this.parent.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.touhou_little_maid.sound_info.url.desc", (Object[])new Object[0]), 8 + (this.parent.field_146294_l - 210) / 2, relativeY + 2, -7829368);
    }

    protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        SoundPackInfo info = CustomResourcesLoader.SOUND_INFO.getInfoList().get(slotIdx);
        int middleX = 14;
        int middleY = slotTop + 4;
        if (info != null) {
            int offSet = 0;
            FontRenderer fontRenderer = this.parent.field_146297_k.field_71466_p;
            this.parent.func_73731_b(fontRenderer, ParseI18n.parse(info.getPackName()), middleX, middleY + offSet, 0xFFFFFF);
            if (!info.getAuthor().isEmpty()) {
                for (List textList : Lists.partition(info.getAuthor(), (int)2)) {
                    this.parent.func_73731_b(fontRenderer, TextFormatting.GOLD + textList.toString(), middleX, middleY + (offSet += 10), 0xFFFFFF);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)info.getVersion())) {
                this.parent.func_73731_b(fontRenderer, TextFormatting.DARK_AQUA + I18n.func_135052_a((String)"gui.touhou_little_maid.skin.text.version", (Object[])new Object[]{info.getVersion()}), middleX, middleY + (offSet += 10), 0xFFFFFF);
            }
            if (StringUtils.isNotBlank((CharSequence)info.getDate())) {
                this.parent.func_73731_b(fontRenderer, TextFormatting.GREEN + I18n.func_135052_a((String)"gui.touhou_little_maid.skin.text.date", (Object[])new Object[]{info.getDate()}), middleX, middleY + (offSet += 10), 0xFFFFFF);
            }
            fontRenderer.func_78279_b(TextFormatting.GRAY + ParseI18n.parse(info.getDescription()), middleX, middleY + (offSet += 15), this.parent.field_146294_l - 228, 0xFFFFFF);
        }
    }
}

