/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.model;

import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.IAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.EntityChairWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.EntityMaidWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.BedrockVersion;
import com.github.tartaricacid.touhoulittlemaid.client.model.ModelBoxFaceFloat;
import com.github.tartaricacid.touhoulittlemaid.client.model.ModelBoxFloat;
import com.github.tartaricacid.touhoulittlemaid.client.model.ModelRendererWithInit;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.BonesItem;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.CubesItem;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.CustomModelPOJO;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.Description;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.FaceUVsItem;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.script.Invocable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityModelJson
extends ModelBase {
    private final EntityMaidWrapper entityMaidWrapper = new EntityMaidWrapper();
    private final EntityChairWrapper entityChairWrapper = new EntityChairWrapper();
    public AxisAlignedBB renderBoundingBox;
    private List<Object> animations = Lists.newArrayList();
    private HashMap<String, ModelRendererWrapper> modelMap = new HashMap();
    private HashMap<String, BonesItem> indexBones = new HashMap();
    private List<ModelRendererWithInit> shouldRender = new LinkedList<ModelRendererWithInit>();

    public EntityModelJson(CustomModelPOJO pojo, BedrockVersion version) {
        if (version == BedrockVersion.LEGACY) {
            this.loadLegacyModel(pojo);
        }
        if (version == BedrockVersion.NEW) {
            this.loadNewModel(pojo);
        }
    }

    public void loadLegacyModel(CustomModelPOJO pojo) {
        assert (pojo.getGeometryModel() != null);
        pojo.getGeometryModel().deco();
        this.field_78090_t = pojo.getGeometryModel().getTexturewidth();
        this.field_78089_u = pojo.getGeometryModel().getTextureheight();
        List<Float> offset = pojo.getGeometryModel().getVisibleBoundsOffset();
        float offsetX = offset.get(0).floatValue();
        float offsetY = offset.get(1).floatValue();
        float offsetZ = offset.get(2).floatValue();
        float width = pojo.getGeometryModel().getVisibleBoundsWidth() / 2.0f;
        float height = pojo.getGeometryModel().getVisibleBoundsHeight() / 2.0f;
        this.renderBoundingBox = new AxisAlignedBB((double)(offsetX - width), (double)(offsetY - height), (double)(offsetZ - width), (double)(offsetX + width), (double)(offsetY + height), (double)(offsetZ + width));
        for (BonesItem bones : pojo.getGeometryModel().getBones()) {
            this.indexBones.put(bones.getName(), bones);
            this.modelMap.put(bones.getName(), new ModelRendererWrapper(new ModelRendererWithInit(this)));
        }
        for (BonesItem bones : pojo.getGeometryModel().getBones()) {
            String name = bones.getName();
            List<Float> rotation = bones.getRotation();
            String parent = bones.getParent();
            ModelRendererWithInit model = this.modelMap.get(name).getModelRenderer();
            model.field_78809_i = bones.isMirror();
            model.func_78793_a(this.convertPivot(bones, 0), this.convertPivot(bones, 1), this.convertPivot(bones, 2));
            if (rotation != null) {
                this.setRotationAngle(model, this.convertRotation(rotation.get(0).floatValue()), this.convertRotation(rotation.get(1).floatValue()), this.convertRotation(rotation.get(2).floatValue()));
            }
            if (parent != null) {
                this.modelMap.get(parent).getModelRenderer().func_78792_a(model);
            } else {
                this.shouldRender.add(model);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cubes : bones.getCubes()) {
                List<Float> uv = cubes.getUv();
                List<Float> size = cubes.getSize();
                boolean mirror = cubes.isMirror();
                float inflate = cubes.getInflate();
                model.field_78804_l.add(new ModelBoxFloat(model, uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(bones, cubes, 0), this.convertOrigin(bones, cubes, 1), this.convertOrigin(bones, cubes, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror));
            }
        }
    }

    public void loadNewModel(CustomModelPOJO pojo) {
        assert (pojo.getGeometryModelNew() != null);
        pojo.getGeometryModelNew().deco();
        Description description = pojo.getGeometryModelNew().getDescription();
        this.field_78090_t = description.getTextureWidth();
        this.field_78089_u = description.getTextureHeight();
        List<Float> offset = description.getVisibleBoundsOffset();
        float offsetX = offset.get(0).floatValue();
        float offsetY = offset.get(1).floatValue();
        float offsetZ = offset.get(2).floatValue();
        float width = description.getVisibleBoundsWidth() / 2.0f;
        float height = description.getVisibleBoundsHeight() / 2.0f;
        this.renderBoundingBox = new AxisAlignedBB((double)(offsetX - width), (double)(offsetY - height), (double)(offsetZ - width), (double)(offsetX + width), (double)(offsetY + height), (double)(offsetZ + width));
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            this.indexBones.put(bones.getName(), bones);
            this.modelMap.put(bones.getName(), new ModelRendererWrapper(new ModelRendererWithInit(this)));
        }
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            String name = bones.getName();
            List<Float> rotation = bones.getRotation();
            String parent = bones.getParent();
            ModelRendererWithInit model = this.modelMap.get(name).getModelRenderer();
            model.field_78809_i = bones.isMirror();
            model.func_78793_a(this.convertPivot(bones, 0), this.convertPivot(bones, 1), this.convertPivot(bones, 2));
            if (rotation != null) {
                this.setRotationAngle(model, this.convertRotation(rotation.get(0).floatValue()), this.convertRotation(rotation.get(1).floatValue()), this.convertRotation(rotation.get(2).floatValue()));
            }
            if (parent != null) {
                this.modelMap.get(parent).getModelRenderer().func_78792_a(model);
            } else {
                this.shouldRender.add(model);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                List<Float> uv = cube.getUv();
                FaceUVsItem faceUv = cube.getFaceUv();
                List<Float> size = cube.getSize();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                List<Float> cubeRotation = cube.getRotation();
                if (cubeRotation == null) {
                    if (faceUv == null) {
                        model.field_78804_l.add(new ModelBoxFloat(model, uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror));
                        continue;
                    }
                    model.field_78804_l.add(new ModelBoxFaceFloat(model, this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, faceUv));
                    continue;
                }
                ModelRendererWithInit cubeRenderer = new ModelRendererWithInit(this);
                cubeRenderer.func_78793_a(this.convertPivot(bones, cube, 0), this.convertPivot(bones, cube, 1), this.convertPivot(bones, cube, 2));
                this.setRotationAngle(cubeRenderer, this.convertRotation(cubeRotation.get(0).floatValue()), this.convertRotation(cubeRotation.get(1).floatValue()), this.convertRotation(cubeRotation.get(2).floatValue()));
                if (faceUv == null) {
                    cubeRenderer.field_78804_l.add(new ModelBoxFloat(model, uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(cube, 0), this.convertOrigin(cube, 1), this.convertOrigin(cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror));
                } else {
                    cubeRenderer.field_78804_l.add(new ModelBoxFaceFloat(model, this.convertOrigin(cube, 0), this.convertOrigin(cube, 1), this.convertOrigin(cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, faceUv));
                }
                model.func_78792_a(cubeRenderer);
            }
        }
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        for (ModelRenderer modelRenderer : this.shouldRender) {
            modelRenderer.func_78785_a(scale);
        }
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        if (this.animations == null) {
            return;
        }
        Invocable invocable = (Invocable)((Object)CommonProxy.NASHORN);
        if (entityIn instanceof EntityMaid) {
            try {
                for (Object animation : this.animations) {
                    if (animation instanceof IAnimation) {
                        ((IAnimation)animation).setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn, this.modelMap);
                        continue;
                    }
                    this.entityMaidWrapper.setData((EntityMaid)entityIn, this.field_78095_p, this.field_78093_q);
                    invocable.invokeMethod(animation, "animation", this.entityMaidWrapper, Float.valueOf(limbSwing), Float.valueOf(limbSwingAmount), Float.valueOf(ageInTicks), Float.valueOf(netHeadYaw), Float.valueOf(headPitch), Float.valueOf(scaleFactor), this.modelMap);
                    this.entityMaidWrapper.clearData();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                CustomResourcesLoader.MAID_MODEL.removeAnimation(((EntityMaid)entityIn).getModelId());
            }
            if (((EntityMaid)entityIn).isSleep()) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)-1.08, (double)1.3);
            }
            return;
        }
        if (entityIn instanceof EntityChair) {
            try {
                for (Object animation : this.animations) {
                    if (animation instanceof IAnimation) {
                        ((IAnimation)animation).setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn, this.modelMap);
                        continue;
                    }
                    this.entityChairWrapper.setData((EntityChair)entityIn);
                    invocable.invokeMethod(animation, "animation", this.entityChairWrapper, Float.valueOf(limbSwing), Float.valueOf(limbSwingAmount), Float.valueOf(ageInTicks), Float.valueOf(netHeadYaw), Float.valueOf(headPitch), Float.valueOf(scaleFactor), this.modelMap);
                    this.entityChairWrapper.clearData();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                CustomResourcesLoader.CHAIR_MODEL.removeAnimation(((EntityChair)entityIn).getModelId());
            }
        }
    }

    private void setRotationAngle(ModelRendererWithInit modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
        modelRenderer.setInitRotationAngle(x, y, z);
    }

    public boolean hasBackpackPositioningModel() {
        return this.modelMap.get("backpackPositioningBone") != null;
    }

    public ModelRenderer getBackpackPositioningModel() {
        return this.modelMap.get("backpackPositioningBone").getModelRenderer();
    }

    public boolean hasHataSasimonoPositioningModel() {
        return this.modelMap.get("hasHataSasimonoPositioningBone") != null;
    }

    public ModelRenderer getHataSasimonoPositioningModel() {
        return this.modelMap.get("hasHataSasimonoPositioningBone").getModelRenderer();
    }

    public boolean hasArmPositioningModel(EnumHandSide side) {
        ModelRendererWrapper arm = side == EnumHandSide.LEFT ? this.modelMap.get("armLeftPositioningBone") : this.modelMap.get("armRightPositioningBone");
        return arm != null;
    }

    public void postRenderArmPositioningModel(float scale, EnumHandSide side) {
        ModelRendererWithInit arm;
        ModelRendererWithInit modelRendererWithInit = arm = side == EnumHandSide.LEFT ? this.modelMap.get("armLeftPositioningBone").getModelRenderer() : this.modelMap.get("armRightPositioningBone").getModelRenderer();
        if (arm != null) {
            arm.func_78794_c(scale);
        }
    }

    public void postRenderArm(float scale, EnumHandSide side) {
        ModelRendererWithInit arm;
        ModelRendererWithInit modelRendererWithInit = arm = side == EnumHandSide.LEFT ? this.modelMap.get("armLeft").getModelRenderer() : this.modelMap.get("armRight").getModelRenderer();
        if (arm != null) {
            arm.func_78794_c(scale);
        }
    }

    public boolean hasLeftArm() {
        return this.modelMap.containsKey("armLeft");
    }

    public boolean hasRightArm() {
        return this.modelMap.containsKey("armRight");
    }

    public boolean hasHead() {
        return this.modelMap.containsKey("head");
    }

    public ModelRenderer getHead() {
        return this.modelMap.get("head").getModelRenderer();
    }

    public void postRenderCustomHead(float scale) {
        ModelRenderer customHead = this.getHead();
        if (customHead != null) {
            customHead.func_78794_c(scale);
        }
    }

    public void setAnimations(List<Object> animations) {
        this.animations = animations;
    }

    private float convertPivot(BonesItem bones, int index) {
        if (bones.getParent() != null) {
            if (index == 1) {
                return this.indexBones.get(bones.getParent()).getPivot().get(index).floatValue() - bones.getPivot().get(index).floatValue();
            }
            return bones.getPivot().get(index).floatValue() - this.indexBones.get(bones.getParent()).getPivot().get(index).floatValue();
        }
        if (index == 1) {
            return 24.0f - bones.getPivot().get(index).floatValue();
        }
        return bones.getPivot().get(index).floatValue();
    }

    private float convertPivot(BonesItem parent, CubesItem cube, int index) {
        assert (cube.getPivot() != null);
        if (index == 1) {
            return parent.getPivot().get(index).floatValue() - cube.getPivot().get(index).floatValue();
        }
        return cube.getPivot().get(index).floatValue() - parent.getPivot().get(index).floatValue();
    }

    private float convertOrigin(BonesItem bones, CubesItem cubes, int index) {
        if (index == 1) {
            return bones.getPivot().get(index).floatValue() - cubes.getOrigin().get(index).floatValue() - cubes.getSize().get(index).floatValue();
        }
        return cubes.getOrigin().get(index).floatValue() - bones.getPivot().get(index).floatValue();
    }

    private float convertOrigin(CubesItem cube, int index) {
        assert (cube.getPivot() != null);
        if (index == 1) {
            return cube.getPivot().get(index).floatValue() - cube.getOrigin().get(index).floatValue() - cube.getSize().get(index).floatValue();
        }
        return cube.getOrigin().get(index).floatValue() - cube.getPivot().get(index).floatValue();
    }

    private float convertRotation(float degree) {
        return (float)((double)degree * Math.PI / 180.0);
    }
}

