/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.MaidBackpackBigModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.MaidBackpackMiddleModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.MaidBackpackSmallModel;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBackpack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class EntityBackpackRender
extends Render<EntityBackpack> {
    public static final Factory FACTORY = new Factory();
    private static final ResourceLocation SMALL = new ResourceLocation("touhou_little_maid", "textures/entity/maid_backpack_small.png");
    private static final ResourceLocation MIDDLE = new ResourceLocation("touhou_little_maid", "textures/entity/maid_backpack_middle.png");
    private static final ResourceLocation BIG = new ResourceLocation("touhou_little_maid", "textures/entity/maid_backpack_big.png");
    private ModelBase smallModel = new MaidBackpackSmallModel();
    private ModelBase middleModel = new MaidBackpackMiddleModel();
    private ModelBase bigModel = new MaidBackpackBigModel();

    private EntityBackpackRender(RenderManager renderManager, float shadowSizeIn) {
        super(renderManager);
        this.field_76989_e = shadowSizeIn;
    }

    public void doRender(@Nonnull EntityBackpack entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        switch (entity.getBackpackLevel()) {
            default: {
                break;
            }
            case SMALL: {
                GlStateManager.func_179137_b((double)x, (double)(y + 1.5), (double)z);
                GlStateManager.func_179114_b((float)(-entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(SMALL);
                this.smallModel.func_78088_a((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                break;
            }
            case MIDDLE: {
                GlStateManager.func_179137_b((double)x, (double)(y + 1.6875), (double)z);
                GlStateManager.func_179114_b((float)(-entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(MIDDLE);
                this.middleModel.func_78088_a((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                break;
            }
            case BIG: {
                GlStateManager.func_179137_b((double)x, (double)(y + 1.5), (double)z);
                GlStateManager.func_179114_b((float)(-entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(BIG);
                this.bigModel.func_78088_a((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            }
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@Nonnull EntityBackpack entity) {
        switch (entity.getBackpackLevel()) {
            default: {
                return SMALL;
            }
            case MIDDLE: {
                return MIDDLE;
            }
            case BIG: 
        }
        return BIG;
    }

    public static class Factory
    implements IRenderFactory<EntityBackpack> {
        public Render<? super EntityBackpack> createRenderFor(RenderManager manager) {
            return new EntityBackpackRender(manager, 0.5f);
        }
    }
}

