/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuColor;
import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuType;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.EntityDanmaku;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityDanmakuRender
extends Render<EntityDanmaku> {
    public static final Factory FACTORY = new Factory();
    private static final ResourceLocation SINGLE_PLANE_DANMAKU = new ResourceLocation("touhou_little_maid", "textures/entity/singe_plane_danmaku.png");
    private static final ResourceLocation AMULET_DANMAKU = new ResourceLocation("touhou_little_maid", "textures/entity/amulet_danmaku.png");
    private static final ResourceLocation STAR_DANMAKU = new ResourceLocation("touhou_little_maid", "textures/entity/star_danmaku.png");
    private static final ResourceLocation PETAL_DANMAKU = new ResourceLocation("touhou_little_maid", "entity/petal.obj");
    private static final ResourceLocation KNIFE_TOP_DANMAKU = new ResourceLocation("touhou_little_maid", "entity/knife_top.obj");
    private static final ResourceLocation KNIFE_BOTTOM_DANMAKU = new ResourceLocation("touhou_little_maid", "entity/knife_bottom.obj");
    private static final ResourceLocation BULLET_DANMAKU = new ResourceLocation("touhou_little_maid", "entity/bullet_danmaku.obj");
    private static final ResourceLocation RING = new ResourceLocation("touhou_little_maid", "entity/ring.obj");
    private static final ResourceLocation GOSSIP = new ResourceLocation("touhou_little_maid", "entity/gossip.obj");
    private static final ResourceLocation KUNAI_DANMAKU = new ResourceLocation("touhou_little_maid", "entity/kunai.obj");
    private static final ResourceLocation RAINDROP_DANMAKU = new ResourceLocation("touhou_little_maid", "entity/raindrop.obj");
    private static final ResourceLocation ARROWHEAD_DANMAKU = new ResourceLocation("touhou_little_maid", "entity/arrowhead.obj");
    private static final ResourceLocation BUTTERFLY_DANMAKU = new ResourceLocation("touhou_little_maid", "entity/butterfly.obj");
    private static final ResourceLocation GLOWEY_BALL_DANMAKU = new ResourceLocation("touhou_little_maid", "textures/entity/glowey_ball.png");
    private static List<BakedQuad> PETAL_QUADS;
    private static List<BakedQuad> KNIFE_TOP_QUADS;
    private static List<BakedQuad> KNIFE_BOTTOM_QUADS;
    private static List<BakedQuad> BULLET_QUADS;
    private static List<BakedQuad> RING_QUADS;
    private static List<BakedQuad> GOSSIP_QUADS;
    private static List<BakedQuad> KUNAI_QUADS;
    private static List<BakedQuad> RAINDROP_QUADS;
    private static List<BakedQuad> ARROWHEAD_QUADS;
    private static List<BakedQuad> BUTTERFLY_QUADS;

    private EntityDanmakuRender(RenderManager renderManagerIn) {
        super(renderManagerIn);
        PETAL_QUADS = EntityDanmakuRender.getObjQuads(PETAL_DANMAKU);
        KNIFE_TOP_QUADS = EntityDanmakuRender.getObjQuads(KNIFE_TOP_DANMAKU);
        KNIFE_BOTTOM_QUADS = EntityDanmakuRender.getObjQuads(KNIFE_BOTTOM_DANMAKU);
        BULLET_QUADS = EntityDanmakuRender.getObjQuads(BULLET_DANMAKU);
        RING_QUADS = EntityDanmakuRender.getObjQuads(RING);
        GOSSIP_QUADS = EntityDanmakuRender.getObjQuads(GOSSIP);
        KUNAI_QUADS = EntityDanmakuRender.getObjQuads(KUNAI_DANMAKU);
        RAINDROP_QUADS = EntityDanmakuRender.getObjQuads(RAINDROP_DANMAKU);
        ARROWHEAD_QUADS = EntityDanmakuRender.getObjQuads(ARROWHEAD_DANMAKU);
        BUTTERFLY_QUADS = EntityDanmakuRender.getObjQuads(BUTTERFLY_DANMAKU);
    }

    private static List<BakedQuad> getObjQuads(ResourceLocation obj) {
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)obj);
            IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
            return bakedModel.func_188616_a(null, null, 0L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Lists.newArrayList();
        }
    }

    public boolean func_188295_H_() {
        return super.func_188295_H_();
    }

    public boolean shouldRender(EntityDanmaku danmaku, @Nonnull ICamera camera, double camX, double camY, double camZ) {
        if (danmaku.getType() == DanmakuType.MASTER_SPARK) {
            return true;
        }
        return super.func_177071_a((Entity)danmaku, camera, camX, camY, camZ);
    }

    public void doRender(@Nonnull EntityDanmaku entity, double x, double y, double z, float entityYaw, float partialTicks) {
        DanmakuType type = entity.getType();
        switch (type) {
            case PELLET: 
            case BALL: 
            case ORBS: 
            case BIG_BALL: 
            case BUBBLE: 
            case HEART: {
                this.renderSinglePlaneDanmaku(entity, x, y, z, type);
                break;
            }
            case JELLYBEAN: {
                this.renderJellyBeanDanmaku(entity, x, y, z);
                break;
            }
            case AMULET: {
                this.renderAmuletDanmaku(entity, x, y, z);
                break;
            }
            case STAR: 
            case BIG_STAR: {
                this.renderStarDanmaku(entity, x, y, z, partialTicks);
                break;
            }
            case PETAL: {
                this.renderPetalDanmaku(entity, x, y, z);
                break;
            }
            case KNIFE: {
                this.renderKnifeDanmaku(entity, x, y, z);
                break;
            }
            case MASTER_SPARK: {
                this.renderMasterSparkDanmaku(entity, x, y, z, partialTicks);
                break;
            }
            case BULLET: {
                this.renderObjDanmaku(entity, x, y, z, BULLET_QUADS, 0.2f, 0.25f, 180.0f);
                break;
            }
            case KUNAI: {
                this.renderObjDanmaku(entity, x, y, z, KUNAI_QUADS, 0.15f, 0.2f, 0.0f);
                break;
            }
            case RAINDROP: {
                this.renderObjDanmaku(entity, x, y, z, RAINDROP_QUADS, 0.25f, 0.3f, 0.0f);
                break;
            }
            case ARROWHEAD: {
                this.renderObjDanmaku(entity, x, y, z, ARROWHEAD_QUADS, 0.2f, 0.25f, 0.0f);
                break;
            }
            case BUTTERFLY: {
                this.renderButterflyDanmaku(entity, x, y, z, partialTicks);
                break;
            }
            case GLOWEY_BALL: {
                this.renderGloweyBallDanmaku(entity, x, y, z, type);
                break;
            }
        }
    }

    protected ResourceLocation getEntityTexture(@Nonnull EntityDanmaku entity) {
        return SINGLE_PLANE_DANMAKU;
    }

    private void renderSinglePlaneDanmaku(EntityDanmaku entity, double x, double y, double z, DanmakuType type) {
        DanmakuColor color = entity.getColor();
        int w = 416;
        int l = 192;
        double pStartU = 32 * color.ordinal();
        double pStartV = 32 * type.ordinal();
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufBuilder = tessellator.func_178180_c();
        bufBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        this.field_76990_c.field_78724_e.func_110577_a(SINGLE_PLANE_DANMAKU);
        bufBuilder.func_181662_b(-type.getSize(), type.getSize(), 0.0).func_187315_a((pStartU + 0.0) / (double)w, (pStartV + 0.0) / (double)l).func_181675_d();
        bufBuilder.func_181662_b(-type.getSize(), -type.getSize(), 0.0).func_187315_a((pStartU + 0.0) / (double)w, (pStartV + 32.0) / (double)l).func_181675_d();
        bufBuilder.func_181662_b(type.getSize(), -type.getSize(), 0.0).func_187315_a((pStartU + 32.0) / (double)w, (pStartV + 32.0) / (double)l).func_181675_d();
        bufBuilder.func_181662_b(type.getSize(), type.getSize(), 0.0).func_187315_a((pStartU + 32.0) / (double)w, (pStartV + 0.0) / (double)l).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    private void renderJellyBeanDanmaku(EntityDanmaku entity, double x, double y, double z) {
        DanmakuColor color = entity.getColor();
        float yaw = entity.field_70177_z + 90.0f;
        float pitch = -entity.field_70125_A;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179137_b((double)x, (double)(y + 0.3), (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.25f, (float)0.25f);
        GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179148_o((int)RenderHelper.SPHERE_OUT_INDEX);
        GlStateManager.func_179148_o((int)RenderHelper.SPHERE_IN_INDEX);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + 0.3), (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.6f, (float)0.3f, (float)0.3f);
        GlStateManager.func_179124_c((float)color.getFloatRed(), (float)color.getFloatGreen(), (float)color.getFloatBlue());
        GlStateManager.func_179148_o((int)RenderHelper.SPHERE_OUT_INDEX);
        GlStateManager.func_179148_o((int)RenderHelper.SPHERE_IN_INDEX);
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void renderAmuletDanmaku(EntityDanmaku entity, double x, double y, double z) {
        DanmakuType type = DanmakuType.AMULET;
        DanmakuColor color = entity.getColor();
        float yaw = entity.field_70177_z;
        float pitch = 90.0f - entity.field_70125_A;
        int w = 416;
        double pStartU = 32 * color.ordinal();
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179137_b((double)x, (double)(y + 0.12), (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufBuilder = tessellator.func_178180_c();
        this.field_76990_c.field_78724_e.func_110577_a(AMULET_DANMAKU);
        bufBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufBuilder.func_181662_b(-type.getSize(), type.getSize(), 0.0).func_187315_a((pStartU + 0.0) / (double)w, 0.0).func_181675_d();
        bufBuilder.func_181662_b(-type.getSize(), -type.getSize(), 0.0).func_187315_a((pStartU + 0.0) / (double)w, 1.0).func_181675_d();
        bufBuilder.func_181662_b(type.getSize(), -type.getSize(), 0.0).func_187315_a((pStartU + 32.0) / (double)w, 1.0).func_181675_d();
        bufBuilder.func_181662_b(type.getSize(), type.getSize(), 0.0).func_187315_a((pStartU + 32.0) / (double)w, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    private void renderStarDanmaku(EntityDanmaku entity, double x, double y, double z, float partialTicks) {
        DanmakuColor color = entity.getColor();
        DanmakuType type = entity.getType();
        int w = 416;
        int l = 64;
        double pStartU = 32 * color.ordinal();
        double pStartV = 32 * (type == DanmakuType.BIG_STAR ? 0 : 1);
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(((float)entity.field_70173_aa + partialTicks) * 5.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufBuilder = tessellator.func_178180_c();
        bufBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        this.field_76990_c.field_78724_e.func_110577_a(STAR_DANMAKU);
        bufBuilder.func_181662_b(-type.getSize(), type.getSize(), 0.0).func_187315_a((pStartU + 0.0) / (double)w, (pStartV + 0.0) / (double)l).func_181675_d();
        bufBuilder.func_181662_b(-type.getSize(), -type.getSize(), 0.0).func_187315_a((pStartU + 0.0) / (double)w, (pStartV + 32.0) / (double)l).func_181675_d();
        bufBuilder.func_181662_b(type.getSize(), -type.getSize(), 0.0).func_187315_a((pStartU + 32.0) / (double)w, (pStartV + 32.0) / (double)l).func_181675_d();
        bufBuilder.func_181662_b(type.getSize(), type.getSize(), 0.0).func_187315_a((pStartU + 32.0) / (double)w, (pStartV + 0.0) / (double)l).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    private void renderPetalDanmaku(EntityDanmaku entity, double x, double y, double z) {
        DanmakuColor color = entity.getColor();
        float yaw = entity.field_70177_z - 90.0f;
        float pitch = entity.field_70125_A;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buff = tessellator.func_178180_c();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.1f, (float)0.1f, (float)0.1f);
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : PETAL_QUADS) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)-1);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y - 0.02), (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.12f, (float)0.12f, (float)0.12f);
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : PETAL_QUADS) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)(-1442840576 + color.getRgb()));
        }
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void renderKnifeDanmaku(EntityDanmaku entity, double x, double y, double z) {
        DanmakuColor color = entity.getColor();
        float yaw = entity.field_70177_z;
        float pitch = -entity.field_70125_A;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179137_b((double)x, (double)(y + 0.1), (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.06f, (float)0.06f, (float)0.06f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buff = tessellator.func_178180_c();
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : KNIFE_TOP_QUADS) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)-285212673);
        }
        tessellator.func_78381_a();
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : KNIFE_BOTTOM_QUADS) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)(-33554432 + color.getRgb()));
        }
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void renderMasterSparkDanmaku(EntityDanmaku entity, double x, double y, double z, float partialTicks) {
        DanmakuColor color = entity.getColor();
        float yaw = entity.field_70177_z;
        float pitch = 90.0f - entity.field_70125_A;
        float num = (float)(20.0 * (Math.atan(((float)entity.field_70173_aa + partialTicks - 50.0f) / 2.0f) + 1.6));
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buff = tessellator.func_178180_c();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)((double)num * 0.1), (double)16.0, (double)((double)num * 0.1));
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : BULLET_QUADS) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)-1);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)((double)num * 0.11), (double)16.0, (double)((double)num * 0.11));
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : BULLET_QUADS) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)(-1442840576 + color.getRgb()));
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)((double)num * 0.115), (double)16.0, (double)((double)num * 0.115));
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : BULLET_QUADS) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)(0x22000000 + color.getRgb()));
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)0.5f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)((double)num * 0.2), (double)((double)num * 0.2), (double)((double)num * 0.2));
        GlStateManager.func_179109_b((float)0.0f, (float)2.0f, (float)0.0f);
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : RING_QUADS) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)(0x33000000 + DanmakuColor.RED.getRgb()));
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)0.5f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)((double)num * 0.15), (double)((double)num * 0.15), (double)((double)num * 0.15));
        GlStateManager.func_179137_b((double)0.0, (double)1.2, (double)0.0);
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : RING_QUADS) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)(0x33000000 + DanmakuColor.GREEN.getRgb()));
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)0.5f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)((double)num * 0.08), (double)((double)num * 0.08), (double)((double)num * 0.08));
        GlStateManager.func_179137_b((double)0.0, (double)0.2, (double)0.0);
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : RING_QUADS) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)(0x33000000 + DanmakuColor.YELLOW.getRgb()));
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)0.5f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
        GlStateManager.func_179137_b((double)0.0, (double)-0.6, (double)0.0);
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : GOSSIP_QUADS) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)-16711423);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void renderObjDanmaku(EntityDanmaku entity, double x, double y, double z, List<BakedQuad> quadList, float scaleIn, float scaleOut, float pitchOffset) {
        DanmakuColor color = entity.getColor();
        float yaw = entity.field_70177_z;
        float pitch = 90.0f - entity.field_70125_A;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buff = tessellator.func_178180_c();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(pitch + pitchOffset), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)scaleIn, (float)scaleIn, (float)scaleIn);
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : quadList) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)-1);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(pitch + pitchOffset), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)scaleOut, (float)scaleOut, (float)scaleOut);
        GlStateManager.func_179109_b((float)0.0f, (float)((scaleIn - scaleOut) * 8.0f), (float)0.0f);
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : quadList) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)(-1442840576 + color.getRgb()));
        }
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void renderButterflyDanmaku(EntityDanmaku entity, double x, double y, double z, float partialTicks) {
        DanmakuColor color = entity.getColor();
        float yaw = entity.field_70177_z;
        float pitch = 180.0f - entity.field_70125_A;
        int argb = -1728053248 + color.getRgb();
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179137_b((double)x, (double)(y + 0.1), (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.1f, (float)0.1f, (float)0.1f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buff = tessellator.func_178180_c();
        GlStateManager.func_179114_b((float)(10.0f * MathHelper.func_76134_b((float)(((float)entity.field_70173_aa + partialTicks) / 4.0f)) + 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : BUTTERFLY_QUADS) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)argb);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + 0.1), (double)z);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.1f, (float)0.1f, (float)0.1f);
        GlStateManager.func_179114_b((float)(160.0f - 10.0f * MathHelper.func_76134_b((float)(((float)entity.field_70173_aa + partialTicks) / 4.0f))), (float)0.0f, (float)0.0f, (float)1.0f);
        buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : BUTTERFLY_QUADS) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)quad, (int)argb);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void renderGloweyBallDanmaku(EntityDanmaku entity, double x, double y, double z, DanmakuType type) {
        DanmakuColor color = entity.getColor();
        int w = 832;
        int l = 64;
        double pStartU = 64 * color.ordinal();
        double pStartV = 0.0;
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.04f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufBuilder = tessellator.func_178180_c();
        bufBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        this.field_76990_c.field_78724_e.func_110577_a(GLOWEY_BALL_DANMAKU);
        bufBuilder.func_181662_b(-type.getSize(), type.getSize(), 0.0).func_187315_a((pStartU + 0.0) / (double)w, (pStartV + 0.0) / (double)l).func_181675_d();
        bufBuilder.func_181662_b(-type.getSize(), -type.getSize(), 0.0).func_187315_a((pStartU + 0.0) / (double)w, (pStartV + 64.0) / (double)l).func_181675_d();
        bufBuilder.func_181662_b(type.getSize(), -type.getSize(), 0.0).func_187315_a((pStartU + 64.0) / (double)w, (pStartV + 64.0) / (double)l).func_181675_d();
        bufBuilder.func_181662_b(type.getSize(), type.getSize(), 0.0).func_187315_a((pStartU + 64.0) / (double)w, (pStartV + 0.0) / (double)l).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    public static class Factory
    implements IRenderFactory<EntityDanmaku> {
        public Render<? super EntityDanmaku> createRenderFor(RenderManager manager) {
            return new EntityDanmakuRender(manager);
        }
    }
}

