/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.api.event.RenderMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityModelJson;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerHataSasimono;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerMaidArrow;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerMaidBipedHead;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerMaidCustomHead;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerMaidDebugBroom;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerMaidDebugFloor;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerMaidHeldItem;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resources.ModelData;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityMaidRender
extends RenderLiving<EntityMaid> {
    public static final Factory FACTORY = new Factory();
    public static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    public static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/hakurei_reimu.png");
    public MaidModelInfo mainInfo;
    public List<Object> mainAnimations = Lists.newArrayList();
    public ModelData eventModelData;

    private EntityMaidRender(RenderManager renderManager, ModelBase modelBase, float shadowSize) {
        super(renderManager, modelBase, shadowSize);
        this.func_177094_a((LayerRenderer)new LayerMaidBipedHead(this));
        this.func_177094_a(new LayerMaidHeldItem(this));
        this.func_177094_a(new LayerMaidArrow((RenderLivingBase<?>)this));
        this.func_177094_a(new LayerMaidDebugFloor());
        this.func_177094_a(new LayerMaidDebugBroom());
        this.func_177094_a(new LayerHataSasimono(this));
        this.func_177094_a(new LayerMaidCustomHead(this));
        this.func_177094_a(new LayerMaidBackpack(this));
    }

    public void doRender(@Nonnull EntityMaid entity, double x, double y, double z, float entityYaw, float partialTicks) {
        CustomResourcesLoader.MAID_MODEL.getModel(DEFAULT_MODEL_ID).ifPresent(model -> {
            this.field_77045_g = model;
        });
        CustomResourcesLoader.MAID_MODEL.getInfo(DEFAULT_MODEL_ID).ifPresent(info -> {
            this.mainInfo = info;
        });
        CustomResourcesLoader.MAID_MODEL.getAnimation(DEFAULT_MODEL_ID).ifPresent(animations -> {
            this.mainAnimations = animations;
        });
        this.eventModelData = new ModelData((EntityModelJson)this.field_77045_g, this.mainInfo, this.mainAnimations);
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderMaidEvent(entity, this.eventModelData))) {
            this.field_77045_g = this.eventModelData.getModel();
            this.mainInfo = this.eventModelData.getInfo();
            this.mainAnimations = this.eventModelData.getAnimations();
        } else {
            CustomResourcesLoader.MAID_MODEL.getModel(entity.getModelId()).ifPresent(model -> {
                this.field_77045_g = model;
            });
            CustomResourcesLoader.MAID_MODEL.getInfo(entity.getModelId()).ifPresent(info -> {
                this.mainInfo = info;
            });
            CustomResourcesLoader.MAID_MODEL.getAnimation(entity.getModelId()).ifPresent(animations -> {
                this.mainAnimations = animations;
            });
        }
        ((EntityModelJson)this.field_77045_g).setAnimations(this.mainAnimations);
        GlStateManager.func_179094_E();
        GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        GlStateManager.func_179121_F();
    }

    protected void preRenderCallback(EntityMaid entityMaid, float partialTickTime) {
        float scale = this.mainInfo.getRenderEntityScale();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
    }

    protected boolean canRenderName(EntityMaid entity) {
        boolean hasCompass = Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() == MaidItems.KAPPA_COMPASS;
        boolean isYourMaid = entity.func_184753_b() != null && entity.func_184753_b().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au());
        return hasCompass && isYourMaid || super.func_177070_b((EntityLiving)entity);
    }

    protected void renderEntityName(@Nonnull EntityMaid entityIn, double x, double y, double z, @Nonnull String name, double distanceSq) {
        String str;
        boolean hasCompass = Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() == MaidItems.KAPPA_COMPASS;
        y = y + (double)this.mainInfo.getRenderEntityScale() - 1.0;
        if (hasCompass) {
            String modeKey = String.format("compass.touhou_little_maid.mode.%s", entityIn.getCompassMode().name().toLowerCase(Locale.US));
            str = I18n.func_135052_a((String)"tooltips.touhou_little_maid.kappa_compass.mode", (Object[])new Object[]{I18n.func_135052_a((String)modeKey, (Object[])new Object[0])});
            if (!entityIn.isHomeModeEnable()) {
                super.func_188296_a((Entity)entityIn, x, y + 0.25, z, I18n.func_135052_a((String)"compass.touhou_little_maid.mode.home.disable", (Object[])new Object[0]), 16.0);
            }
        } else {
            str = name;
        }
        super.func_188296_a((Entity)entityIn, x, y, z, str, 16.0);
    }

    @Nonnull
    protected ResourceLocation getEntityTexture(@Nonnull EntityMaid entity) {
        if (this.mainInfo == null) {
            return DEFAULT_TEXTURE;
        }
        return this.mainInfo.getTexture();
    }

    public MaidModelInfo getMainInfo() {
        return this.mainInfo;
    }

    public void setMainModel(EntityModelJson mainModel) {
        this.field_77045_g = mainModel;
    }

    public static class Factory
    implements IRenderFactory<EntityMaid> {
        public Render<? super EntityMaid> createRenderFor(RenderManager manager) {
            return new EntityMaidRender(manager, CustomResourcesLoader.MAID_MODEL.getModel(EntityMaidRender.DEFAULT_MODEL_ID).orElseThrow(NullPointerException::new), 0.5f);
        }
    }
}

