/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.EntityYukkuriModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerYukkuriSlimeGel;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityYukkuriSlimeRender
extends RenderLiving<EntitySlime> {
    public static final Factory FACTORY = new Factory();
    private static final ResourceLocation SLIME_TEXTURES = new ResourceLocation("textures/entity/slime/slime.png");
    private static final ResourceLocation YUKKURI_TEXTURES = new ResourceLocation("touhou_little_maid", "textures/entity/yukkuri.png");
    private ModelBase modelSlime = this.func_177087_b();
    private ModelBase modelYukkuri = new EntityYukkuriModel();

    private EntityYukkuriSlimeRender(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelSlime(16), 0.25f);
        this.func_177094_a(new LayerYukkuriSlimeGel(this));
    }

    public void doRender(@Nonnull EntitySlime entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_76989_e = 0.25f * (float)entity.func_70809_q();
        this.field_77045_g = GeneralConfig.VANILLA_CONFIG.changeSlimeModel ? this.modelYukkuri : this.modelSlime;
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected void preRenderCallback(EntitySlime entitySlime, float partialTickTime) {
        GlStateManager.func_179152_a((float)0.999f, (float)0.999f, (float)0.999f);
        float slimeSize = entitySlime.func_70809_q();
        float tmpValue = (entitySlime.field_70812_c + (entitySlime.field_70811_b - entitySlime.field_70812_c) * partialTickTime) / (slimeSize * 0.5f + 1.0f);
        float scaleFactor = 1.0f / (tmpValue + 1.0f);
        GlStateManager.func_179152_a((float)(scaleFactor * slimeSize), (float)(1.0f / scaleFactor * slimeSize), (float)(scaleFactor * slimeSize));
    }

    protected ResourceLocation getEntityTexture(@Nonnull EntitySlime entity) {
        if (GeneralConfig.VANILLA_CONFIG.changeSlimeModel) {
            return YUKKURI_TEXTURES;
        }
        return SLIME_TEXTURES;
    }

    public static class Factory
    implements IRenderFactory<EntitySlime> {
        public Render<? super EntitySlime> createRenderFor(RenderManager manager) {
            return new EntityYukkuriSlimeRender(manager);
        }
    }
}

