/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers;

import com.github.tartaricacid.touhoulittlemaid.client.model.EntityModelJson;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRender;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.authlib.GameProfile;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.StringUtils;

public class LayerMaidCustomHead
implements LayerRenderer<EntityMaid> {
    private static final String SKULL_OWNER_TAG = "SkullOwner";
    private final EntityMaidRender maidRender;

    public LayerMaidCustomHead(EntityMaidRender maidRender) {
        this.maidRender = maidRender;
    }

    public void doRenderLayer(@Nonnull EntityMaid maid, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!maid.isShowHelmet()) {
            return;
        }
        ItemStack head = maid.func_184582_a(EntityEquipmentSlot.HEAD);
        EntityModelJson modelJson = (EntityModelJson)this.maidRender.func_177087_b();
        if (!head.func_190926_b() && this.maidRender.getMainInfo().isShowCustomHead() && modelJson.hasHead()) {
            Item item = head.func_77973_b();
            Minecraft minecraft = Minecraft.func_71410_x();
            GlStateManager.func_179094_E();
            modelJson.postRenderCustomHead(0.0625f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (item == Items.field_151144_bL) {
                GlStateManager.func_179152_a((float)1.05f, (float)-1.05f, (float)-1.05f);
                TileEntitySkullRenderer.field_147536_b.func_188190_a(-0.5f, 0.0f, -0.5f, EnumFacing.UP, 180.0f, head.func_77960_j(), this.getSkullGameProfile(head), -1, limbSwing);
            } else if (!(item instanceof ItemArmor) || ((ItemArmor)item).func_185083_B_() != EntityEquipmentSlot.HEAD) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.625f, (float)-0.625f, (float)-0.625f);
                minecraft.func_175597_ag().func_178099_a((EntityLivingBase)maid, head, ItemCameraTransforms.TransformType.HEAD);
            }
            GlStateManager.func_179121_F();
        }
    }

    private GameProfile getSkullGameProfile(ItemStack head) {
        GameProfile gameprofile = null;
        if (head.func_77942_o()) {
            String skullOwner;
            NBTTagCompound nbttagcompound = head.func_77978_p();
            if (nbttagcompound.func_150297_b(SKULL_OWNER_TAG, 10)) {
                gameprofile = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l(SKULL_OWNER_TAG));
            } else if (nbttagcompound.func_150297_b(SKULL_OWNER_TAG, 8) && !StringUtils.isBlank((CharSequence)(skullOwner = nbttagcompound.func_74779_i(SKULL_OWNER_TAG)))) {
                gameprofile = TileEntitySkull.func_174884_b((GameProfile)new GameProfile(null, skullOwner));
                nbttagcompound.func_74782_a(SKULL_OWNER_TAG, (NBTBase)NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)gameprofile));
            }
        }
        return gameprofile;
    }

    public boolean func_177142_b() {
        return false;
    }
}

