/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers;

import com.github.tartaricacid.touhoulittlemaid.client.model.EntityModelJson;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerMaidHeldItem
implements LayerRenderer<EntityMaid> {
    protected final RenderLiving<EntityMaid> livingEntityRenderer;

    public LayerMaidHeldItem(RenderLiving<EntityMaid> livingEntityRendererIn) {
        this.livingEntityRenderer = livingEntityRendererIn;
    }

    public void doRenderLayer(@Nonnull EntityMaid entityMaid, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ItemStack mainRightItem = entityMaid.func_184614_ca();
        ItemStack offLeftItem = entityMaid.func_184592_cb();
        EntityModelJson mainModel = (EntityModelJson)this.livingEntityRenderer.func_177087_b();
        if (!mainRightItem.func_190926_b() && mainModel.hasRightArm()) {
            this.renderHeldItem(entityMaid, mainRightItem, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, EnumHandSide.RIGHT, mainModel);
        }
        if (!offLeftItem.func_190926_b() && mainModel.hasLeftArm()) {
            this.renderHeldItem(entityMaid, offLeftItem, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, EnumHandSide.LEFT, mainModel);
        }
    }

    private void renderHeldItem(EntityMaid entityMaid, ItemStack itemStack, ItemCameraTransforms.TransformType type, EnumHandSide handSide, EntityModelJson mainModel) {
        if (!itemStack.func_190926_b()) {
            GlStateManager.func_179094_E();
            boolean isLeft = handSide == EnumHandSide.LEFT;
            mainModel.postRenderArm(0.0625f, handSide);
            if (mainModel.hasArmPositioningModel(handSide)) {
                mainModel.postRenderArmPositioningModel(0.0625f, handSide);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.125f, (float)-0.0625f);
            } else {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)((float)(isLeft ? -1 : 1) / 16.0f), (float)0.125f, (float)-0.525f);
            }
            Minecraft.func_71410_x().func_175597_ag().func_187462_a((EntityLivingBase)entityMaid, itemStack, type, isLeft);
            GlStateManager.func_179121_F();
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

