/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.client.model.StatueBaseModel;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityStatue;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.util.concurrent.ExecutionException;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class TileEntityStatueRenderer
extends TileEntitySpecialRenderer<TileEntityStatue> {
    private static final StatueBaseModel BASE = new StatueBaseModel();
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/statue_base.png");

    @ParametersAreNonnullByDefault
    public void render(TileEntityStatue te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Entity entity;
        super.func_192841_a((TileEntity)te, x, y, z, partialTicks, destroyStage, alpha);
        if (!te.isCoreBlock()) {
            return;
        }
        float size = te.getSize().getScale();
        EnumFacing facing = te.getFacing();
        float offset = 0.0f;
        if (te.getSize() == TileEntityStatue.Size.MIDDLE) {
            offset = 0.25f;
        } else if (te.getSize() == TileEntityStatue.Size.BIG) {
            offset = 0.33333334f;
        }
        this.func_147499_a(TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        boolean lightmapEnabled = GL11.glGetBoolean((int)3553);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        switch (te.getFacing()) {
            case EAST: {
                GlStateManager.func_179137_b((double)(x - (double)(offset * size)), (double)y, (double)(z - (double)(offset * size)));
                break;
            }
            case NORTH: {
                GlStateManager.func_179137_b((double)(x - (double)(offset * size)), (double)y, (double)(z + (double)(offset * size)));
                break;
            }
            case WEST: {
                GlStateManager.func_179137_b((double)(x + (double)(offset * size)), (double)y, (double)(z + (double)(offset * size)));
                break;
            }
            case SOUTH: {
                GlStateManager.func_179137_b((double)(x + (double)(offset * size)), (double)y, (double)(z - (double)(offset * size)));
                break;
            }
            default: {
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            }
        }
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
        GlStateManager.func_179137_b((double)(0.5 / (double)size), (double)0.5, (double)(0.5 / (double)size));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        BASE.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        if (lightmapEnabled) {
            GlStateManager.func_179098_w();
        } else {
            GlStateManager.func_179090_x();
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        NBTTagCompound data = te.getExtraMaidData();
        if (data == null) {
            return;
        }
        String name = data.func_74779_i("ModelId");
        try {
            entity = (Entity)EntityCacheUtil.ENTITY_CACHE.get((Object)name, () -> {
                Entity e = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(name), (World)this.func_178459_a());
                if (e == null) {
                    return new EntityMaid(this.func_178459_a());
                }
                return e;
            });
            if (entity instanceof EntityMaid) {
                EntityMaid maid = (EntityMaid)entity;
                EntityCacheUtil.clearMaidDataResidue(maid, true);
                maid.setModelId(name);
                entity.func_70020_e(data);
            }
        }
        catch (ExecutionException e) {
            return;
        }
        size = te.getSize().getScale();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
        GlStateManager.func_179137_b((double)(0.5 / (double)size), (double)0.21328125, (double)(0.5 / (double)size));
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        switch (facing) {
            default: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        Minecraft.func_71410_x().func_175598_ae().func_178633_a(false);
        Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, (double)offset, 0.0, (double)(-offset), 0.0f, 0.0f, true);
        Minecraft.func_71410_x().func_175598_ae().func_178633_a(true);
        GlStateManager.func_179121_F();
    }

    @ParametersAreNonnullByDefault
    public boolean isGlobalRenderer(TileEntityStatue te) {
        return true;
    }
}

