/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resources;

import com.github.tartaricacid.touhoulittlemaid.client.model.EntityModelJson;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.CustomModelPack;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CustomChairModelResources {
    private String jsonFileName;
    private List<CustomModelPack<ChairModelInfo>> packList;
    private HashMap<String, EntityModelJson> idModelMap;
    private HashMap<String, ChairModelInfo> idInfoMap;
    private HashMap<String, List<Object>> idAnimationMap;
    private HashMap<String, String> idDebugAnimationFile;

    public CustomChairModelResources(String jsonFileName, List<CustomModelPack<ChairModelInfo>> packList, HashMap<String, EntityModelJson> idToModel, HashMap<String, ChairModelInfo> idToInfo, HashMap<String, List<Object>> idAnimationMap) {
        this.jsonFileName = jsonFileName;
        this.packList = packList;
        this.idModelMap = idToModel;
        this.idInfoMap = idToInfo;
        this.idAnimationMap = idAnimationMap;
        this.idDebugAnimationFile = Maps.newHashMap();
    }

    public void clearAll() {
        this.packList.clear();
        this.idModelMap.clear();
        this.idInfoMap.clear();
        this.idAnimationMap.clear();
    }

    public String getJsonFileName() {
        return this.jsonFileName;
    }

    public List<CustomModelPack<ChairModelInfo>> getPackList() {
        return this.packList;
    }

    public Set<String> getModelIdSet() {
        return this.idInfoMap.keySet();
    }

    public void addPack(CustomModelPack<ChairModelInfo> pack) {
        this.packList.add(pack);
    }

    public void putModel(String modelId, EntityModelJson modelJson) {
        this.idModelMap.put(modelId, modelJson);
    }

    public void putInfo(String modelId, ChairModelInfo chairModelItem) {
        this.idInfoMap.put(modelId, chairModelItem);
    }

    public void putAnimation(String modelId, List<Object> animationJs) {
        this.idAnimationMap.put(modelId, animationJs);
    }

    public void putDebugAnimation(String modelId, String debugAnimationFilePath) {
        this.idDebugAnimationFile.put(modelId, debugAnimationFilePath);
    }

    public void removeDebugAnimation(String modelId) {
        this.idDebugAnimationFile.remove(modelId);
    }

    @Nullable
    public String getDebugAnimationFilePath(String modelId) {
        return this.idDebugAnimationFile.get(modelId);
    }

    public Optional<EntityModelJson> getModel(String modelId) {
        return Optional.ofNullable(this.idModelMap.get(modelId));
    }

    public float getModelRenderItemScale(String modelId) {
        if (this.idInfoMap.containsKey(modelId)) {
            return this.idInfoMap.get(modelId).getRenderItemScale();
        }
        return 1.0f;
    }

    public float getModelMountedYOffset(String modelId) {
        if (this.idInfoMap.containsKey(modelId)) {
            return this.idInfoMap.get(modelId).getMountedYOffset();
        }
        return 0.0f;
    }

    public boolean getModelTameableCanRide(String modelId) {
        if (this.idInfoMap.containsKey(modelId)) {
            return this.idInfoMap.get(modelId).isTameableCanRide();
        }
        return true;
    }

    public boolean getModelNoGravity(String modelId) {
        if (this.idInfoMap.containsKey(modelId)) {
            return this.idInfoMap.get(modelId).isNoGravity();
        }
        return false;
    }

    public Optional<List<Object>> getAnimation(String modelId) {
        return Optional.ofNullable(this.idAnimationMap.get(modelId));
    }

    public void removeAnimation(String modelId) {
        this.idAnimationMap.remove(modelId);
    }

    public Optional<ChairModelInfo> getInfo(String modelId) {
        return Optional.ofNullable(this.idInfoMap.get(modelId));
    }
}

