/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resources;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.HataTextureManager;
import com.github.tartaricacid.touhoulittlemaid.proxy.ClientProxy;
import com.github.tartaricacid.touhoulittlemaid.util.GetJarResources;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;

@SideOnly(value=Side.CLIENT)
public class CustomHataTextureLoader {
    private static final Map<Long, Integer> HATA_NAME_MAP = ClientProxy.HATA_NAME_MAP;
    private static final Path CONFIG_HATA_FOLDER = Paths.get(Minecraft.func_71410_x().field_71412_D.getPath(), "config", "touhou_little_maid", "hata_texture");
    private static final String JAR_HATA_FOLDER = "/assets/touhou_little_maid/hata_texture";
    private static final String ACCEPTED_HATA_TEXTURE_SUFFIX = ".png";
    private static HataTextureManager HATA_TEXTURE_MANAGER = ClientProxy.HATA_TEXTURE_MANAGER;

    private static void unzipHataTexture() {
        boolean shouldCopyDir;
        File[] files = CONFIG_HATA_FOLDER.toFile().listFiles((dir, name) -> name.endsWith(ACCEPTED_HATA_TEXTURE_SUFFIX));
        boolean dirNotExist = !Files.isDirectory(CONFIG_HATA_FOLDER, new LinkOption[0]);
        boolean dirIsEmpty = files == null || files.length < 1;
        boolean bl = shouldCopyDir = dirNotExist || dirIsEmpty;
        if (shouldCopyDir) {
            GetJarResources.copyTouhouLittleMaidFolder(JAR_HATA_FOLDER, CONFIG_HATA_FOLDER);
        }
    }

    public static void onHataTextureReload() {
        HATA_TEXTURE_MANAGER.clear();
        HATA_NAME_MAP.clear();
        CustomHataTextureLoader.unzipHataTexture();
        File[] files = CONFIG_HATA_FOLDER.toFile().listFiles((dir, name) -> name.endsWith(ACCEPTED_HATA_TEXTURE_SUFFIX));
        if (files == null || files.length < 1) {
            throw new NullPointerException();
        }
        for (File file : files) {
            try {
                HATA_NAME_MAP.put(FileUtils.checksumCRC32((File)file), HATA_TEXTURE_MANAGER.loadTexture(file.toString()));
            }
            catch (IOException e) {
                TouhouLittleMaid.LOGGER.error((Object)e);
                return;
            }
        }
        TouhouLittleMaid.LOGGER.info("Loaded {} Hata Textures", (Object)HATA_NAME_MAP.size());
    }
}

