/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resources;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.CustomJsAnimationManger;
import com.github.tartaricacid.touhoulittlemaid.client.model.BedrockVersion;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityModelJson;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.CubesItem;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.CustomModelPOJO;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomChairModelResources;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomMaidModelResources;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomSoundResources;
import com.github.tartaricacid.touhoulittlemaid.client.resources.ModelData;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.EasterEgg;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.SoundPackInfo;
import com.github.tartaricacid.touhoulittlemaid.network.serverpack.ClientPackManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@SideOnly(value=Side.CLIENT)
public class CustomResourcesLoader {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(CubesItem.class, (Object)new CubesItem.Deserializer()).create();
    public static final CustomMaidModelResources MAID_MODEL = new CustomMaidModelResources("maid_model.json", Lists.newArrayList(), Maps.newHashMap(), Maps.newHashMap(), Maps.newHashMap());
    public static final CustomChairModelResources CHAIR_MODEL = new CustomChairModelResources("maid_chair.json", Lists.newArrayList(), Maps.newHashMap(), Maps.newHashMap(), Maps.newHashMap());
    public static final CustomSoundResources SOUND_INFO = new CustomSoundResources("maid_sound.json", Lists.newArrayList());
    private static final Logger LOGGER = TouhouLittleMaid.LOGGER;
    private static final Marker MARKER = MarkerManager.getMarker((String)"ResourcesLoader");
    private static IResourceManager manager = Minecraft.func_71410_x().func_110442_L();

    public static void reloadResources() {
        CustomJsAnimationManger.clearAll();
        MAID_MODEL.clearAll();
        CHAIR_MODEL.clearAll();
        SOUND_INFO.clearAll();
        CustomResourcesLoader.loadMaidModelPack();
        CustomResourcesLoader.loadChairModelPack();
        CustomResourcesLoader.loadSoundInfo();
        if (!ClientPackManager.CRC32_LIST_FROM_SERVER.isEmpty()) {
            for (long crc32 : ClientPackManager.CRC32_LIST_FROM_SERVER) {
                ClientPackManager.readModelFromZipFile(ClientPackManager.getCrc32FileMap().get(crc32));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMaidModelPack() {
        LOGGER.info(MARKER, "Touhou little maid mod's model is loading...");
        for (String domain : manager.func_135055_a()) {
            InputStream input = null;
            try {
                ResourceLocation res = new ResourceLocation(domain, MAID_MODEL.getJsonFileName());
                input = manager.func_110536_a(res).func_110527_b();
                CustomModelPack pack = (CustomModelPack)GSON.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), new TypeToken<CustomModelPack<MaidModelInfo>>(){}.getType());
                pack.decorate();
                for (MaidModelInfo maidModelItem : pack.getModelList()) {
                    EntityModelJson modelJson = CustomResourcesLoader.loadModel(maidModelItem.getModel());
                    List<Object> animations = CustomJsAnimationManger.getCustomAnimation(maidModelItem);
                    if (modelJson == null) continue;
                    if (maidModelItem.getEasterEgg() != null && StringUtils.isNotBlank((CharSequence)maidModelItem.getEasterEgg().getTag())) {
                        CustomResourcesLoader.putMaidEasterEggData(maidModelItem, modelJson, animations);
                    } else {
                        CustomResourcesLoader.putMaidModelData(maidModelItem, modelJson, animations);
                    }
                    LOGGER.info(MARKER, "Loaded model: {}", (Object)maidModelItem.getModel());
                }
                pack.getModelList().removeIf(maidModelInfo -> maidModelInfo.getEasterEgg() != null);
                MAID_MODEL.addPack(pack);
            }
            catch (IOException res) {
                IOUtils.closeQuietly(input);
                continue;
            }
            catch (JsonSyntaxException e) {
                try {
                    LOGGER.warn(MARKER, "Fail to parse model pack in domain {}", (Object)domain);
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)input);
                continue;
            }
            IOUtils.closeQuietly((InputStream)input);
        }
        LOGGER.info(MARKER, "Touhou little maid mod's model is loaded");
    }

    private static void putMaidEasterEggData(MaidModelInfo maidModelItem, EntityModelJson modelJson, List<Object> animations) {
        EasterEgg easterEgg = maidModelItem.getEasterEgg();
        ModelData data = new ModelData(modelJson, maidModelItem, animations);
        if (easterEgg.isEncrypt()) {
            MAID_MODEL.putEasterEggEncryptTagModel(easterEgg.getTag(), data);
        } else {
            MAID_MODEL.putEasterEggNormalTagModel(easterEgg.getTag(), data);
        }
    }

    private static void putMaidModelData(MaidModelInfo maidModelItem, EntityModelJson modelJson, List<Object> animations) {
        String id = maidModelItem.getModelId().toString();
        MAID_MODEL.putModel(id, modelJson);
        MAID_MODEL.putInfo(id, maidModelItem);
        if (animations != null && animations.size() > 0) {
            MAID_MODEL.putAnimation(id, animations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadChairModelPack() {
        LOGGER.info(MARKER, "Touhou little maid mod's model is loading...");
        for (String domain : manager.func_135055_a()) {
            InputStream input = null;
            try {
                ResourceLocation res = new ResourceLocation(domain, CHAIR_MODEL.getJsonFileName());
                input = manager.func_110536_a(res).func_110527_b();
                CustomModelPack pack = (CustomModelPack)GSON.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), new TypeToken<CustomModelPack<ChairModelInfo>>(){}.getType());
                pack.decorate();
                for (ChairModelInfo chairModelItem : pack.getModelList()) {
                    EntityModelJson modelJson = CustomResourcesLoader.loadModel(chairModelItem.getModel());
                    List<Object> animations = CustomJsAnimationManger.getCustomAnimation(chairModelItem);
                    if (modelJson == null) continue;
                    String id = chairModelItem.getModelId().toString();
                    CHAIR_MODEL.putModel(id, modelJson);
                    CHAIR_MODEL.putInfo(id, chairModelItem);
                    if (animations != null && animations.size() > 0) {
                        CHAIR_MODEL.putAnimation(id, animations);
                    }
                    LOGGER.info(MARKER, "Loaded model: {}", (Object)chairModelItem.getModel());
                }
                CHAIR_MODEL.addPack(pack);
            }
            catch (IOException res) {
                IOUtils.closeQuietly(input);
                continue;
            }
            catch (JsonSyntaxException e) {
                try {
                    LOGGER.warn(MARKER, "Fail to parse model pack in domain {}", (Object)domain);
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)input);
                continue;
            }
            IOUtils.closeQuietly((InputStream)input);
        }
        LOGGER.info(MARKER, "Touhou little maid mod's model is loaded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public static EntityModelJson loadModel(ResourceLocation modelLocation) {
        block8: {
            block9: {
                block7: {
                    input = null;
                    input = CustomResourcesLoader.manager.func_110536_a(modelLocation).func_110527_b();
                    pojo = (CustomModelPOJO)CustomResourcesLoader.GSON.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), CustomModelPOJO.class);
                    if (!pojo.getFormatVersion().equals(BedrockVersion.LEGACY.getVersion())) ** GOTO lbl13
                    if (pojo.getGeometryModel() == null) break block7;
                    var3_4 = new EntityModelJson(pojo, BedrockVersion.LEGACY);
                    IOUtils.closeQuietly((InputStream)input);
                    return var3_4;
                }
                CustomResourcesLoader.LOGGER.warn(CustomResourcesLoader.MARKER, "{} model file don't have model field", (Object)modelLocation);
lbl13:
                // 2 sources

                if (!pojo.getFormatVersion().equals(BedrockVersion.NEW.getVersion())) break block8;
                if (pojo.getGeometryModelNew() == null) break block9;
                var3_5 = new EntityModelJson(pojo, BedrockVersion.NEW);
                IOUtils.closeQuietly((InputStream)input);
                return var3_5;
            }
            CustomResourcesLoader.LOGGER.warn(CustomResourcesLoader.MARKER, "{} model file don't have model field", (Object)modelLocation);
            var3_6 = null;
            IOUtils.closeQuietly((InputStream)input);
            return var3_6;
        }
        try {
            CustomResourcesLoader.LOGGER.warn(CustomResourcesLoader.MARKER, "{} model version is not 1.10.0 or 1.12.0", (Object)modelLocation);
        }
        catch (IOException ioe) {
            try {
                CustomResourcesLoader.LOGGER.warn(CustomResourcesLoader.MARKER, "Failed to load model: {}", (Object)modelLocation);
                ioe.printStackTrace();
            }
            catch (Throwable var4_7) {
                IOUtils.closeQuietly(input);
                throw var4_7;
            }
            IOUtils.closeQuietly((InputStream)input);
        }
        IOUtils.closeQuietly((InputStream)input);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSoundInfo() {
        LOGGER.info(MARKER, "Touhou little maid mod's sound info is loading...");
        for (String domain : manager.func_135055_a()) {
            InputStream input = null;
            try {
                ResourceLocation res = new ResourceLocation(domain, SOUND_INFO.getJsonFileName());
                input = manager.func_110536_a(res).func_110527_b();
                SoundPackInfo info = (SoundPackInfo)GSON.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), SoundPackInfo.class);
                SOUND_INFO.putInfo(info.decorate());
                LOGGER.info(MARKER, "Loaded sound info from: {}", (Object)domain);
            }
            catch (IOException res) {
                IOUtils.closeQuietly(input);
                continue;
            }
            catch (JsonSyntaxException e) {
                try {
                    LOGGER.warn(MARKER, "Fail to parse sound info from domain {}", (Object)domain);
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)input);
                continue;
            }
            IOUtils.closeQuietly((InputStream)input);
        }
        LOGGER.info(MARKER, "Touhou little maid mod's sound info is loaded");
    }
}

