/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resources;

import com.github.tartaricacid.touhoulittlemaid.client.animation.CustomJsAnimationManger;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityModelJson;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.MaidModelInfo;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PlayerMaidResources {
    private static final Cache<String, GameProfile> GAME_PROFILE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private static final GameProfile EMPTY_GAME_PROFILE = new GameProfile(null, "EMPTY");
    private static final ResourceLocation PLAYER_MAID_MODEL_RES = new ResourceLocation("touhou_little_maid", "models/entity/player_maid.json");
    private static final ResourceLocation PLAYER_MAID_SLIM_MODEL_RES = new ResourceLocation("touhou_little_maid", "models/entity/player_maid_slim.json");
    private static final List<ResourceLocation> PLAYER_MAID_ANIMATION_RES = Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("touhou_little_maid", "animation/maid/default/head/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/head/beg.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/leg/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/player/arm/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/arm/swing.js"), new ResourceLocation("touhou_little_maid", "animation/maid/player/sit/default.js")});
    private static final ResourceLocation TEXTURE_ALEX = new ResourceLocation("textures/entity/alex.png");
    private static final List<Object> PLAYER_MAID_ANIMATIONS = Lists.newArrayList();
    private static final String SLIM_NAME = "slim";
    private static EntityModelJson playerMaidModel;
    private static EntityModelJson playerMaidModelSlim;
    private static MaidModelInfo playerMaidInfo;
    private static ResourceLocation playerSkin;

    public static void reloadResources() {
        playerMaidModel = CustomResourcesLoader.loadModel(PLAYER_MAID_MODEL_RES);
        playerMaidModelSlim = CustomResourcesLoader.loadModel(PLAYER_MAID_SLIM_MODEL_RES);
        PLAYER_MAID_ANIMATIONS.clear();
        for (ResourceLocation res : PLAYER_MAID_ANIMATION_RES) {
            PLAYER_MAID_ANIMATIONS.add(CustomJsAnimationManger.getCustomAnimation(res));
        }
        playerMaidInfo = new MaidModelInfo(){

            @Override
            public ResourceLocation getTexture() {
                return playerSkin;
            }
        };
    }

    public static EntityModelJson getPlayerMaidModel(String name) {
        UUID uuid;
        String skinModel;
        String skinModel2;
        Map map;
        GameProfile newProfile = null;
        Minecraft minecraft = Minecraft.func_71410_x();
        try {
            newProfile = (GameProfile)GAME_PROFILE_CACHE.get((Object)name, () -> {
                THREAD_POOL.submit(() -> {
                    GameProfile profile = new GameProfile(null, name);
                    GameProfile profileNew = TileEntitySkull.func_174884_b((GameProfile)profile);
                    minecraft.func_152344_a(() -> GAME_PROFILE_CACHE.put((Object)name, (Object)profileNew));
                });
                return EMPTY_GAME_PROFILE;
            });
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (newProfile != null && ((map = minecraft.func_152342_ad().func_152788_a(newProfile)).containsKey(MinecraftProfileTexture.Type.SKIN) ? SLIM_NAME.equals(skinModel2 = ((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN)).getMetadata("model")) : SLIM_NAME.equals(skinModel = DefaultPlayerSkin.func_177332_b((UUID)(uuid = EntityPlayer.func_146094_a((GameProfile)newProfile)))))) {
            return playerMaidModelSlim;
        }
        return playerMaidModel;
    }

    public static List<Object> getPlayerMaidAnimations() {
        return PLAYER_MAID_ANIMATIONS;
    }

    public static MaidModelInfo getPlayerMaidInfo(String name) {
        playerSkin = PlayerMaidResources.getPlayerSkin(name);
        return playerMaidInfo;
    }

    public static ResourceLocation getPlayerSkin(String name) {
        GameProfile newProfile = null;
        Minecraft minecraft = Minecraft.func_71410_x();
        try {
            newProfile = (GameProfile)GAME_PROFILE_CACHE.get((Object)name, () -> {
                THREAD_POOL.submit(() -> {
                    GameProfile profile = new GameProfile(null, name);
                    GameProfile profileNew = TileEntitySkull.func_174884_b((GameProfile)profile);
                    minecraft.func_152344_a(() -> GAME_PROFILE_CACHE.put((Object)name, (Object)profileNew));
                });
                return EMPTY_GAME_PROFILE;
            });
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (newProfile != null) {
            Map map = minecraft.func_152342_ad().func_152788_a(newProfile);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                return minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            }
            UUID uuid = EntityPlayer.func_146094_a((GameProfile)newProfile);
            return DefaultPlayerSkin.func_177334_a((UUID)uuid);
        }
        return TEXTURE_ALEX;
    }
}

