/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resources.pojo;

import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.EasterEgg;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.IModelInfo;
import com.google.common.collect.Lists;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class MaidModelInfo
implements IModelInfo {
    private static final float RENDER_ENTITY_SCALE_MIN = 0.2f;
    private static final float RENDER_ENTITY_SCALE_MAX = 2.0f;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="description")
    private List<String> description;
    @SerializedName(value="model")
    private ResourceLocation model;
    @SerializedName(value="texture")
    private ResourceLocation texture;
    @SerializedName(value="model_id")
    private ResourceLocation modelId;
    @SerializedName(value="render_item_scale")
    private float renderItemScale = 1.0f;
    @SerializedName(value="render_entity_scale")
    private float renderEntityScale = 1.0f;
    @SerializedName(value="animation")
    private List<ResourceLocation> animation;
    @SerializedName(value="show_hata")
    private boolean showHata = true;
    @SerializedName(value="show_backpack")
    private boolean showBackpack = true;
    @SerializedName(value="show_custom_head")
    private boolean showCustomHead = true;
    @SerializedName(value="can_hold_trolley")
    private boolean canHoldTrolley = true;
    @SerializedName(value="can_hold_vehicle")
    private boolean canHoldVehicle = true;
    @SerializedName(value="can_riding_broom")
    private boolean canRidingBroom = true;
    @SerializedName(value="easter_egg")
    private EasterEgg easterEgg = null;

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getDescription() {
        return this.description;
    }

    @Override
    public List<ResourceLocation> getAnimation() {
        return this.animation;
    }

    @Override
    public ResourceLocation getModelId() {
        return this.modelId;
    }

    @Override
    public ResourceLocation getModel() {
        return this.model;
    }

    @Override
    public float getRenderItemScale() {
        return this.renderItemScale;
    }

    public float getRenderEntityScale() {
        return this.renderEntityScale;
    }

    public boolean isShowHata() {
        return this.showHata;
    }

    public boolean isShowBackpack() {
        return this.showBackpack;
    }

    public boolean isShowCustomHead() {
        return this.showCustomHead;
    }

    public boolean isCanHoldTrolley() {
        return this.canHoldTrolley;
    }

    public boolean isCanHoldVehicle() {
        return this.canHoldVehicle;
    }

    public boolean isCanRidingBroom() {
        return this.canRidingBroom;
    }

    public EasterEgg getEasterEgg() {
        return this.easterEgg;
    }

    public MaidModelInfo decorate() {
        if (this.description == null) {
            this.description = Collections.EMPTY_LIST;
        }
        if (this.modelId == null) {
            throw new JsonSyntaxException("Expected \"model_id\" in model");
        }
        if (this.model == null) {
            this.model = new ResourceLocation(this.modelId.func_110624_b(), "models/entity/" + this.modelId.func_110623_a() + ".json");
        }
        if (this.texture == null) {
            this.texture = new ResourceLocation(this.modelId.func_110624_b(), "textures/entity/" + this.modelId.func_110623_a() + ".png");
        }
        if (this.name == null) {
            this.name = String.format("{model.%s.%s.name}", this.modelId.func_110624_b(), this.modelId.func_110623_a());
        }
        if (this.animation == null || this.animation.size() == 0) {
            this.animation = Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("touhou_little_maid", "animation/maid/default/head/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/head/blink.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/head/beg.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/head/music_shake.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/leg/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/arm/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/arm/swing.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/arm/vertical.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/sit/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/armor/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/armor/reverse.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/wing/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/tail/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/sit/skirt_rotation.js"), new ResourceLocation("touhou_little_maid", "animation/base/float/default.js")});
        }
        this.renderEntityScale = MathHelper.func_76131_a((float)this.renderEntityScale, (float)0.2f, (float)2.0f);
        return this;
    }
}

