/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.jei.altar;

import com.github.tartaricacid.touhoulittlemaid.compat.jei.altar.AltarRecipeWrapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class AltarRecipeCategory
implements IRecipeCategory<AltarRecipeWrapper> {
    public static final String ALTAR_CRAFTING = String.format("%s.altar", "touhou_little_maid");
    private IDrawableStatic icon;
    private final IDrawableStatic background;
    private final IDrawable slotDrawable;

    public AltarRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, 125);
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawable(new ResourceLocation("touhou_little_maid", "textures/gui/altar_icon.png"), 0, 0, 16, 16, 16, 16);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public String getUid() {
        return ALTAR_CRAFTING;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.touhou_little_maid.altar_craft.title", (Object[])new Object[0]);
    }

    @Nonnull
    public String getModName() {
        return "Touhou Little Maid";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull AltarRecipeWrapper altarRecipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 40, 35);
        guiItemStacks.init(1, true, 40, 55);
        guiItemStacks.init(2, true, 60, 15);
        guiItemStacks.init(3, true, 80, 15);
        guiItemStacks.init(4, true, 100, 35);
        guiItemStacks.init(5, true, 100, 55);
        guiItemStacks.init(6, false, 140, 5);
        guiItemStacks.setBackground(0, this.slotDrawable);
        guiItemStacks.setBackground(1, this.slotDrawable);
        guiItemStacks.setBackground(2, this.slotDrawable);
        guiItemStacks.setBackground(3, this.slotDrawable);
        guiItemStacks.setBackground(4, this.slotDrawable);
        guiItemStacks.setBackground(5, this.slotDrawable);
        guiItemStacks.setBackground(6, this.slotDrawable);
        guiItemStacks.set(ingredients);
    }
}

