/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.config;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="touhou_little_maid", name="TouhouLittleMaid")
public class GeneralConfig {
    @Config.LangKey(value="config.touhou_little_maid.maid_config")
    @Config.Name(value="MaidConfig")
    public static MaidConfig MAID_CONFIG = new MaidConfig();
    @Config.LangKey(value="config.touhou_little_maid.vanilla_config")
    @Config.Name(value="VanillaConfig")
    public static VanillaConfig VANILLA_CONFIG = new VanillaConfig();
    @Config.LangKey(value="config.touhou_little_maid.mob_config")
    @Config.Name(value="MobConfig")
    public static MobConfig MOB_CONFIG = new MobConfig();
    @Config.LangKey(value="config.touhou_little_maid.misc_config")
    @Config.Name(value="MiscConfig")
    public static MiscellaneousConfig MISC_CONFIG = new MiscellaneousConfig();
    @Config.LangKey(value="config.touhou_little_maid.gashapon_config")
    @Config.Name(value="GashaponConfig")
    public static GashaponConfig GASHAPON_CONFIG = new GashaponConfig();
    @Config.LangKey(value="config.touhou_little_maid.music_config")
    @Config.Name(value="MusicConfig")
    public static MusicConfig MUSIC_CONFIG = new MusicConfig();

    @Mod.EventBusSubscriber(modid="touhou_little_maid")
    public static class ConfigSyncHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("touhou_little_maid")) {
                ConfigManager.sync((String)"touhou_little_maid", (Config.Type)Config.Type.INSTANCE);
                TouhouLittleMaid.LOGGER.info("Touhou Little Mod's Config Already Change.");
            }
        }
    }

    public static class MusicConfig {
        @Config.Comment(value={"Players who match this reg can send music messages"})
        @Config.LangKey(value="config.touhou_little_maid.music_config.player_name_reg")
        @Config.Name(value="PlayerNameReg")
        public String playerNameReg = ".*";
        @Config.Comment(value={"Receive music information from the server?"})
        @Config.LangKey(value="config.touhou_little_maid.music_config.receive_music")
        @Config.Name(value="ReceiveMusic")
        public Boolean receiveMusic = true;
        @Config.Comment(value={"Maximum music list count"})
        @Config.LangKey(value="config.touhou_little_maid.music_config.music_list_count")
        @Config.Name(value="MusicListCount")
        @Config.RangeInt(min=6)
        public int musicListCount = 20;
    }

    public static class GashaponConfig {
        @Config.Comment(value={"The item that can purchase for gashapon"})
        @Config.LangKey(value="config.touhou_little_maid.gashapon_config.purchase_gashapon_item")
        @Config.Name(value="PurchaseGashaponItem")
        public String purchaseGashaponItem = "minecraft:emerald";
        @Config.Comment(value={"Gashapon's purchase price"})
        @Config.LangKey(value="config.touhou_little_maid.gashapon_config.purchase_gashapon_price")
        @Config.Name(value="PurchaseGashaponPrice")
        @Config.RangeInt(min=1)
        public int purchaseGashaponPrice = 2;
        @Config.Comment(value={"UR Level Gashapon's Weights"})
        @Config.LangKey(value="config.touhou_little_maid.gashapon_config.gashapon_weights_5")
        @Config.Name(value="GashaponWeights5")
        @Config.RangeInt(min=0)
        public int gashaponWeights5 = 5;
        @Config.Comment(value={"SSR Level Gashapon's Weights"})
        @Config.LangKey(value="config.touhou_little_maid.gashapon_config.gashapon_weights_4")
        @Config.Name(value="GashaponWeights4")
        @Config.RangeInt(min=0)
        public int gashaponWeights4 = 10;
        @Config.Comment(value={"SR Level Gashapon's Weights"})
        @Config.LangKey(value="config.touhou_little_maid.gashapon_config.gashapon_weights_3")
        @Config.Name(value="GashaponWeights3")
        @Config.RangeInt(min=0)
        public int gashaponWeights3 = 20;
        @Config.Comment(value={"R Level Gashapon's Weights"})
        @Config.LangKey(value="config.touhou_little_maid.gashapon_config.gashapon_weights_2")
        @Config.Name(value="GashaponWeights2")
        @Config.RangeInt(min=0)
        public int gashaponWeights2 = 30;
        @Config.Comment(value={"N Level Gashapon's Weights"})
        @Config.LangKey(value="config.touhou_little_maid.gashapon_config.gashapon_weights_1")
        @Config.Name(value="GashaponWeights1")
        @Config.RangeInt(min=0)
        public int gashaponWeights1 = 50;
    }

    public static class MiscellaneousConfig {
        @Config.Comment(value={"Shrine Lamp Effect Cost (Power Point/Per Hour)"})
        @Config.LangKey(value="config.touhou_little_maid.misc_config.shrine_lamp.effect_cost")
        @Config.Name(value="ShrineLampEffectCost")
        @Config.RangeDouble(min=0.0)
        public double shrineLampEffectCost = 0.9;
        @Config.Comment(value={"Shrine Lamp Max Storage Power Point"})
        @Config.LangKey(value="config.touhou_little_maid.misc_config.shrine_lamp.max_storage")
        @Config.Name(value="ShrineLampMaxStorage")
        @Config.RangeDouble(min=0.0)
        public double shrineLampMaxStorage = 100.0;
        @Config.Comment(value={"Shrine Lamp Max Range Of Absorb Power Point"})
        @Config.LangKey(value="config.touhou_little_maid.misc_config.shrine_lamp.max_range")
        @Config.Name(value="ShrineLampMaxRange")
        @Config.RangeInt(min=0)
        public int shrineLampMaxRange = 6;
        @Config.Comment(value={"Loss Power Point After Player Death"})
        @Config.LangKey(value="config.touhou_little_maid.misc_config.player_death_loss_power_point")
        @Config.Name(value="PlayerDeathLossPowerPoint")
        @Config.RangeDouble(min=0.0, max=5.0)
        public double playerDeathLossPowerPoint = 1.0;
        @Config.Comment(value={"Only Creative Player Can Ride Broom"})
        @Config.LangKey(value="config.touhou_little_maid.misc_config.creative_player_can_ride_broom")
        @Config.Name(value="CreativePlayerCanRideBroom")
        public boolean creativePlayerCanRideBroom = true;
        @Config.Comment(value={"Power Point HUD Position X"})
        @Config.LangKey(value="config.touhou_little_maid.misc_config.power_point_hud_x")
        @Config.Name(value="PowerPointHudX")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double PowerPointHudX = 0.0;
        @Config.Comment(value={"Power Point HUD Position Y"})
        @Config.LangKey(value="config.touhou_little_maid.misc_config.power_point_hud_y")
        @Config.Name(value="PowerPointHudY")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double PowerPointHudY = 0.0;
        @Config.Comment(value={"Override the render of Custom NPC mod"})
        @Config.LangKey(value="config.touhou_little_maid.misc_config.override_npc_render")
        @Config.Name(value="OverrideNpcRender")
        @Config.RequiresMcRestart
        public boolean overrideNpcRender = true;
        @Config.Comment(value={"Only creative player can change chair model"})
        @Config.LangKey(value="config.touhou_little_maid.misc_config.chair_cannot_change_model")
        @Config.Name(value="ChairCannotChangeModel")
        public boolean chairCannotChangeModel = false;
        @Config.Comment(value={"Only creative player can destroy chair"})
        @Config.LangKey(value="config.touhou_little_maid.misc_config.chair_cannot_be_destroied")
        @Config.Name(value="ChairCannotBeDestroied")
        public boolean chairCannotBeDestroied = false;
        @Config.Comment(value={"Will the danmaku be affected by the fluid?"})
        @Config.LangKey(value="config.touhou_little_maid.misc_config.danmaku_affected_by_fluid")
        @Config.Name(value="DanmakuAffectedByFluid")
        public boolean danmakuAffectedByFluid = true;
        @Config.Comment(value={"Whether to give guide book when entering the game for the first time?"})
        @Config.LangKey(value="config.touhou_little_maid.misc_config.give_guide_book_first")
        @Config.Name(value="GiveGuideBookFirst")
        public boolean giveGuideBookFirst = true;
        @Config.Comment(value={"Whether to enable fast rendering, the GUI will no longer display 3D icons after enabling?"})
        @Config.LangKey(value="config.touhou_little_maid.misc_config.fast_rendering")
        @Config.Name(value="FastRendering")
        public boolean fastRendering = false;
    }

    public static class MobConfig {
        @Config.Comment(value={"Maid Fairy's Power Point"})
        @Config.LangKey(value="config.touhou_little_maid.mob_config.maid_fairy_power_point")
        @Config.Name(value="MaidFairyPowerPoint")
        @Config.RangeDouble(min=0.0, max=5.0)
        public double maidFairyPowerPoint = 0.16;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Maid Fairy's Spawn Probability (Zombie Is 100, Enderman Is 10)"})
        @Config.LangKey(value="config.touhou_little_maid.mob_config.maid_fairy_spawn_probability")
        @Config.Name(value="MaidFairySpawnProbability")
        @Config.RangeInt(min=0)
        public int maidFairySpawnProbability = 70;
        @Config.Comment(value={"Rinnosuke's Power Point"})
        @Config.LangKey(value="config.touhou_little_maid.mob_config.rinnosuke_power_point")
        @Config.Name(value="RinnosukePowerPoint")
        @Config.RangeDouble(min=0.0, max=5.0)
        public double rinnosukePowerPoint = 0.64;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Rinnosuke's Spawn Probability (Zombie Is 100, Enderman Is 10)"})
        @Config.LangKey(value="config.touhou_little_maid.mob_config.rinnosuke_spawn_probability")
        @Config.Name(value="RinnosukeSpawnProbability")
        @Config.RangeInt(min=0)
        public int rinnosukeSpawnProbability = 30;
    }

    public static class VanillaConfig {
        @Config.Comment(value={"Whether to replace the vanilla xp orb texture with the touhou project's point items."})
        @Config.LangKey(value="config.touhou_little_maid.vanilla_config.change_xp_texture")
        @Config.Name(value="ChangeXPTexture")
        public boolean changeXPTexture = false;
        @Config.Comment(value={"Whether to replace the vanilla slime model with the yukkuri."})
        @Config.LangKey(value="config.touhou_little_maid.vanilla_config.change_slime_model")
        @Config.Name(value="ChangeSlimeTexture")
        public boolean changeSlimeModel = false;
        @Config.Comment(value={"Whether to replace the vanilla totem model with the life point."})
        @Config.LangKey(value="config.touhou_little_maid.vanilla_config.change_totem_model")
        @Config.Name(value="ChangeTotemTexture")
        public boolean changeTotemModel = false;
    }

    public static class MaidConfig {
        @Config.Comment(value={"The item that can tamed maid"})
        @Config.LangKey(value="config.touhou_little_maid.maid_config.maid_tamed_item")
        @Config.Name(value="MaidTamedItem")
        public String maidTamedItem = "minecraft:cake";
        @Config.Comment(value={"The item that can temptation maid"})
        @Config.LangKey(value="config.touhou_little_maid.maid_config.maid_temptation_item")
        @Config.Name(value="MaidTemptationItem")
        public String maidTemptationItem = "minecraft:cake";
        @Config.Comment(value={"Get number of ticks, at least during which the maid will be silent."})
        @Config.LangKey(value="config.touhou_little_maid.maid_config.maid_talk_interval")
        @Config.Name(value="MaidTalkInterval")
        @Config.RangeInt(min=20)
        public int maidTalkInterval = 120;
        @Config.Comment(value={"Get number of count, at least during which the maid will be silent in pickup item."})
        @Config.LangKey(value="config.touhou_little_maid.maid_config.maid_pickup_sound_interval")
        @Config.Name(value="MaidPickupSoundInterval")
        @Config.RangeInt(min=1)
        public int maidPickupSoundInterval = 5;
        @Config.Comment(value={"Get number of ticks, at least during which the maid will be silent in hurt."})
        @Config.LangKey(value="config.touhou_little_maid.maid_config.maid_hurt_sound_interval")
        @Config.Name(value="MaidHurtSoundInterval")
        @Config.RangeInt(min=20)
        public int maidHurtSoundInterval = 120;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Decide which tasks are not enabled."})
        @Config.LangKey(value="config.touhou_little_maid.maid_config.enabled_tasks")
        @Config.Name(value="EnabledTasks")
        public Map<String, Boolean> enabledTasks = new HashMap<String, Boolean>();
        @Config.Comment(value={"Maid cannot switch models freely."})
        @Config.LangKey(value="config.touhou_little_maid.maid_config.maid_cannot_change_model")
        @Config.Name(value="MaidCannotChangeModel")
        public boolean maidCannotChangeModel = false;
        @Config.Comment(value={"The maximum number of maids the player own."})
        @Config.LangKey(value="config.touhou_little_maid.maid_config.owner_max_maid_num")
        @Config.Name(value="OwnerMaxMaidNum")
        @Config.RangeInt(min=0)
        public int ownerMaxMaidNum = Integer.MAX_VALUE;
        @Config.Comment(value={"Give a init maid for player first join."})
        @Config.LangKey(value="config.touhou_little_maid.maid_config.give_init_maid")
        @Config.Name(value="GiveInitMaid")
        public boolean giveInitMaid = true;
        @Config.Comment(value={"Spawn smart slab in loot chest."})
        @Config.LangKey(value="config.touhou_little_maid.maid_config.spawn_slab_in_loot_chest")
        @Config.Name(value="SpawnSlabInLootChest")
        public boolean spawnSlabInLootChest = true;
    }
}

