/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.danmaku;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.danmaku.CustomSpellCardEntry;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import javax.script.Bindings;
import javax.script.ScriptException;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public final class CustomSpellCardManger {
    public static final Map<String, CustomSpellCardEntry> CUSTOM_SPELL_CARD_CLIENT = Maps.newHashMap();
    public static final Map<String, CustomSpellCardEntry> CUSTOM_SPELL_CARD_SERVER = Maps.newHashMap();
    private static final Path CONFIG_SPELL_CARD_FOLDER = Paths.get("config", "touhou_little_maid", "custom_spell_card");
    private static final String JAR_SPELL_CARD_FOLDER = "/assets/touhou_little_maid/custom_spell_card";
    private static final String ACCEPTED_SPELL_CARD_SUFFIX = ".js";
    private static final ResourceLocation DEFAULT = new ResourceLocation("touhou_little_maid", "textures/items/spell_card/spellcard_default.png");

    public static void onCustomSpellCardReload() {
        CUSTOM_SPELL_CARD_SERVER.clear();
        CustomSpellCardManger.checkCustomSpellCardFolder();
        CustomSpellCardManger.loadInternalSpellCard();
        CustomSpellCardManger.loadConfigSpellCard();
        TouhouLittleMaid.LOGGER.info("Loaded {} Custom Spell Cards", (Object)CUSTOM_SPELL_CARD_SERVER.size());
    }

    private static void loadInternalSpellCard() {
        CustomSpellCardManger.loadInternalSpellCard("border_sign.boundary_between_wave_and_particle");
        CustomSpellCardManger.loadInternalSpellCard("border_sign.boundary_between_wave_and_particle_3d");
        CustomSpellCardManger.loadInternalSpellCard("magic_sign.milky_way");
        CustomSpellCardManger.loadInternalSpellCard("metal_sign.metal_fatigue");
        CustomSpellCardManger.loadInternalSpellCard("night_sign.night_bird");
    }

    private static void loadConfigSpellCard() {
        File[] files = CONFIG_SPELL_CARD_FOLDER.toFile().listFiles((dir, name) -> name.endsWith(ACCEPTED_SPELL_CARD_SUFFIX));
        if (files == null || files.length < 1) {
            return;
        }
        for (File file : files) {
            try {
                CustomSpellCardEntry entry = CustomSpellCardManger.loadCustomSpellCard(file);
                if (CUSTOM_SPELL_CARD_SERVER.containsKey(entry.getId())) {
                    TouhouLittleMaid.LOGGER.warn("Have a spell card of the same id: {}", (Object)entry.getId());
                    continue;
                }
                CUSTOM_SPELL_CARD_SERVER.put(entry.getId(), entry);
            }
            catch (IOException | NullPointerException | ScriptException e) {
                TouhouLittleMaid.LOGGER.error("Exception while loading spell in {}:", (Object)file);
                TouhouLittleMaid.LOGGER.catching((Throwable)e);
            }
        }
    }

    private static void loadInternalSpellCard(String spellcardName) {
        InputStream stream = TouhouLittleMaid.class.getResourceAsStream(String.format("%s/%s.js", JAR_SPELL_CARD_FOLDER, spellcardName));
        try {
            CustomSpellCardEntry entry = CustomSpellCardManger.loadCustomSpellCard(stream);
            CUSTOM_SPELL_CARD_SERVER.put(entry.getId(), entry);
        }
        catch (IOException | NullPointerException | ScriptException e) {
            TouhouLittleMaid.LOGGER.error("Exception while loading spell in {}:", (Object)spellcardName);
            TouhouLittleMaid.LOGGER.catching((Throwable)e);
        }
    }

    private static void checkCustomSpellCardFolder() {
        if (!Files.isDirectory(CONFIG_SPELL_CARD_FOLDER, new LinkOption[0])) {
            try {
                Files.createDirectories(CONFIG_SPELL_CARD_FOLDER, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static CustomSpellCardEntry loadCustomSpellCard(File file) throws IOException, ScriptException {
        return CustomSpellCardManger.loadCustomSpellCard(Files.newInputStream(file.toPath(), StandardOpenOption.READ));
    }

    private static CustomSpellCardEntry loadCustomSpellCard(InputStream stream) throws IOException, ScriptException {
        Bindings bindings = CommonProxy.NASHORN.createBindings();
        Object scriptObject = CommonProxy.NASHORN.eval(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), bindings);
        return CustomSpellCardManger.transObjectToEntry(scriptObject);
    }

    private static CustomSpellCardEntry transObjectToEntry(Object scriptObject) {
        Map scriptMaps = (Map)scriptObject;
        String id = (String)scriptMaps.get(Args.ID.getName());
        Objects.requireNonNull(id);
        String descriptionKey = "";
        String author = "";
        String version = "";
        int cooldown = 60;
        ResourceLocation icon = DEFAULT;
        ResourceLocation snapshot = DEFAULT;
        String nameKey = scriptMaps.containsKey(Args.NAME_KEY.getName()) ? (String)scriptMaps.get(Args.NAME_KEY.getName()) : String.format("spell_card.%s.name", id);
        if (scriptMaps.containsKey(Args.DESC_KEY.getName())) {
            descriptionKey = (String)scriptMaps.get(Args.DESC_KEY.getName());
        }
        if (scriptMaps.containsKey(Args.AUTHOR.getName())) {
            author = (String)scriptMaps.get(Args.AUTHOR.getName());
        }
        if (scriptMaps.containsKey(Args.VERSION.getName())) {
            version = (String)scriptMaps.get(Args.VERSION.getName());
        }
        if (scriptMaps.containsKey(Args.COOLDOWN.getName())) {
            cooldown = (Integer)scriptMaps.get(Args.COOLDOWN.getName());
        }
        if (scriptMaps.containsKey(Args.ICON.getName())) {
            icon = new ResourceLocation((String)scriptMaps.get(Args.ICON.getName()));
        }
        if (scriptMaps.containsKey(Args.SNAPSHOT.getName())) {
            snapshot = new ResourceLocation((String)scriptMaps.get(Args.SNAPSHOT.getName()));
        }
        return new CustomSpellCardEntry(id, nameKey, descriptionKey, author, version, scriptObject, cooldown, icon, snapshot);
    }

    static enum Args {
        ID("id"),
        NAME_KEY("nameKey"),
        DESC_KEY("descKey"),
        AUTHOR("author"),
        VERSION("version"),
        COOLDOWN("cooldown"),
        ICON("icon"),
        SNAPSHOT("snapshot");

        private String name;

        private Args(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

