/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.draw;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public final class DrawManger {
    private static final Path CONFIG_DRAW_CSV_FILE = Paths.get("config", "touhou_little_maid", "draw.csv");
    private static final HashMap<String, Integer> MODEL_TO_LEVEL = Maps.newHashMap();
    private static final HashMap<String, Integer> MODEL_TO_WEIGHT = Maps.newHashMap();
    private static final HashMap<Integer, List<String>> LEVEL_TO_MODEL = Maps.newHashMap();
    private static final Random RANDOM = new Random();

    public static int getGashaponLevel() {
        int[] weightArray = new int[]{GeneralConfig.GASHAPON_CONFIG.gashaponWeights1, GeneralConfig.GASHAPON_CONFIG.gashaponWeights2, GeneralConfig.GASHAPON_CONFIG.gashaponWeights3, GeneralConfig.GASHAPON_CONFIG.gashaponWeights4, GeneralConfig.GASHAPON_CONFIG.gashaponWeights5};
        int totalWeight = Arrays.stream(weightArray).sum();
        int randomNum = RANDOM.nextInt(totalWeight);
        int level = 0;
        for (int weight : weightArray) {
            ++level;
            if ((randomNum -= weight) < 0) break;
        }
        return level;
    }

    public static String getCouponModelId(int level) {
        List<String> modelIdList = LEVEL_TO_MODEL.get(level);
        if (modelIdList == null) {
            return "";
        }
        int totalWeight = 0;
        for (String modelId : modelIdList) {
            totalWeight += MODEL_TO_WEIGHT.get(modelId).intValue();
        }
        if (totalWeight > 0) {
            int randomNum = RANDOM.nextInt(totalWeight);
            for (String modelId : modelIdList) {
                if ((randomNum -= MODEL_TO_WEIGHT.get(modelId).intValue()) >= 0) continue;
                return modelId;
            }
        }
        return "";
    }

    private static void clearAllData() {
        MODEL_TO_LEVEL.clear();
        MODEL_TO_WEIGHT.clear();
        LEVEL_TO_MODEL.clear();
    }

    private static void addData(String modelId, int weight, int level) {
        MODEL_TO_LEVEL.put(modelId, level);
        MODEL_TO_WEIGHT.put(modelId, weight);
        if (LEVEL_TO_MODEL.containsKey(level)) {
            LEVEL_TO_MODEL.get(level).add(modelId);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(modelId);
            LEVEL_TO_MODEL.put(level, list);
        }
    }

    public static int getModelLevel(String modelId) {
        if (MODEL_TO_LEVEL.containsKey(modelId)) {
            return MathHelper.func_76125_a((int)MODEL_TO_LEVEL.get(modelId), (int)1, (int)5);
        }
        return 1;
    }

    public static Set<String> getModelIdSet() {
        return MODEL_TO_LEVEL.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readDrawCsvFile(Object clz) {
        DrawManger.clearAllData();
        InputStream input = null;
        try {
            input = CONFIG_DRAW_CSV_FILE.toFile().isFile() ? Files.newInputStream(CONFIG_DRAW_CSV_FILE, new OpenOption[0]) : clz.getClass().getClassLoader().getResourceAsStream("assets/touhou_little_maid/draw.csv");
            if (input != null) {
                List lines = IOUtils.readLines((InputStream)input, (Charset)StandardCharsets.UTF_8);
                for (String line : lines) {
                    String[] data = line.split(",");
                    if (data.length < 3) {
                        throw new IOException();
                    }
                    DrawManger.addData(data[0], Integer.parseInt(StringUtils.deleteWhitespace((String)data[1])), Integer.parseInt(StringUtils.deleteWhitespace((String)data[2])));
                }
            }
            IOUtils.closeQuietly((InputStream)input);
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.warn("Fail to read csv file");
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    public static void writeDrawCsvFile(List<ModelDrawInfo> infos) {
        try (OutputStream stream = Files.newOutputStream(CONFIG_DRAW_CSV_FILE, new OpenOption[0]);){
            for (ModelDrawInfo info : infos) {
                String text = String.format("%s,%s,%s\n", info.getModelId(), info.getWeight(), info.getLevel().getIndex());
                IOUtils.write((String)text, (OutputStream)stream, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HashMap<String, Integer> getModelToLevel() {
        return MODEL_TO_LEVEL;
    }

    public static HashMap<String, Integer> getModelToWeight() {
        return MODEL_TO_WEIGHT;
    }

    public static HashMap<Integer, List<String>> getLevelToModel() {
        return LEVEL_TO_MODEL;
    }

    public static List<ModelDrawInfo> sortModelDrawInfo(List<ModelDrawInfo> modelDrawInfoList) {
        ArrayList out = Lists.newArrayList();
        HashMap levelListHashMap = Maps.newHashMap();
        List levelList = Lists.reverse(Arrays.asList(Level.values()));
        for (Level level : levelList) {
            levelListHashMap.put(level, Lists.newArrayList());
        }
        for (ModelDrawInfo info : modelDrawInfoList) {
            ((List)levelListHashMap.get((Object)info.level)).add(info);
        }
        for (List list : levelListHashMap.values()) {
            list.sort(Comparator.comparingInt(e -> -e.getWeight()));
        }
        for (Level level : levelList) {
            out.addAll((Collection)levelListHashMap.get((Object)level));
        }
        return out;
    }

    public static class ModelDrawInfo {
        private final String modelId;
        private Level level;
        private int weight;

        public ModelDrawInfo(String modelId, Level level, int weight) {
            this.modelId = modelId;
            this.level = level;
            this.weight = weight;
        }

        public String getModelId() {
            return this.modelId;
        }

        public Level getLevel() {
            return this.level;
        }

        public void setLevel(Level level) {
            this.level = level;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }
    }

    public static enum Level {
        N("\u00a7bN"),
        R("\u00a7aR"),
        SR("\u00a7cSR"),
        SSR("\u00a75SSR"),
        UR("\u00a76UR");

        private final String formatText;

        private Level(String formatText) {
            this.formatText = formatText;
        }

        public static String getFormatTextByIndex(int index) {
            return Level.getLevelByIndex((int)index).formatText;
        }

        public static Level getLevelByIndex(int index) {
            return Level.values()[MathHelper.func_76125_a((int)(index - 1), (int)0, (int)(Level.values().length - 1))];
        }

        public String getName() {
            return this.name().toLowerCase(Locale.US);
        }

        public String getFormatText() {
            return this.formatText;
        }

        public int getIndex() {
            return this.ordinal() + 1;
        }
    }
}

