/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.draw;

import com.github.tartaricacid.touhoulittlemaid.client.gui.item.DrawConfigGui;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.draw.DrawManger;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SendToClientDrawMessage
implements IMessage {
    private List<DrawManger.ModelDrawInfo> modelDrawInfoList = Lists.newArrayList();

    public SendToClientDrawMessage() {
    }

    public SendToClientDrawMessage(HashMap<String, Integer> modelToWeight, HashMap<Integer, List<String>> levelToModel, List<CustomModelPack<MaidModelInfo>> maidModelPackInfoList) {
        for (int index : levelToModel.keySet()) {
            DrawManger.Level level = DrawManger.Level.getLevelByIndex(index);
            for (String string : levelToModel.get(index)) {
                int weight = modelToWeight.get(string);
                DrawManger.ModelDrawInfo modelDrawInfo = new DrawManger.ModelDrawInfo(string, level, weight);
                this.modelDrawInfoList.add(modelDrawInfo);
            }
            for (CustomModelPack customModelPack : maidModelPackInfoList) {
                for (MaidModelInfo modelInfo : customModelPack.getModelList()) {
                    String modelId = modelInfo.getModelId().toString();
                    if (modelToWeight.containsKey(modelId)) continue;
                    DrawManger.ModelDrawInfo modelDrawInfo = new DrawManger.ModelDrawInfo(modelId, DrawManger.Level.N, 0);
                    if (!this.modelDrawInfoList.stream().noneMatch(i -> i.getModelId().equals(modelId))) continue;
                    this.modelDrawInfoList.add(modelDrawInfo);
                }
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.modelDrawInfoList.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            String modelId = ByteBufUtils.readUTF8String((ByteBuf)buf);
            byte level = buf.readByte();
            int weight = buf.readInt();
            this.modelDrawInfoList.add(new DrawManger.ModelDrawInfo(modelId, DrawManger.Level.getLevelByIndex(level), weight));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.modelDrawInfoList.size());
        for (DrawManger.ModelDrawInfo info : this.modelDrawInfoList) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)info.getModelId());
            buf.writeByte(info.getLevel().getIndex());
            buf.writeInt(info.getWeight());
        }
    }

    public static class Handler
    implements IMessageHandler<SendToClientDrawMessage, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(SendToClientDrawMessage message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new DrawConfigGui(DrawManger.sortModelDrawInfo(message.modelDrawInfoList))));
            }
            return null;
        }
    }
}

