/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.draw;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.draw.DrawManger;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class SendToServerDrawMessage
implements IMessage {
    private List<DrawManger.ModelDrawInfo> modelDrawInfoList = Lists.newArrayList();
    private boolean isReload;

    public SendToServerDrawMessage() {
    }

    public SendToServerDrawMessage(List<DrawManger.ModelDrawInfo> modelDrawInfoList, boolean isReload) {
        this.modelDrawInfoList = modelDrawInfoList;
        this.isReload = isReload;
    }

    public void fromBytes(ByteBuf buf) {
        this.modelDrawInfoList.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            String modelId = ByteBufUtils.readUTF8String((ByteBuf)buf);
            byte level = buf.readByte();
            int weight = buf.readInt();
            DrawManger.ModelDrawInfo modelDrawInfo = new DrawManger.ModelDrawInfo(modelId, DrawManger.Level.getLevelByIndex(level), weight);
            this.modelDrawInfoList.add(modelDrawInfo);
        }
        this.isReload = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.modelDrawInfoList.size());
        for (DrawManger.ModelDrawInfo info : this.modelDrawInfoList) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)info.getModelId());
            buf.writeByte(info.getLevel().getIndex());
            buf.writeInt(info.getWeight());
        }
        buf.writeBoolean(this.isReload);
    }

    public static class Handler
    implements IMessageHandler<SendToServerDrawMessage, IMessage> {
        public IMessage onMessage(SendToServerDrawMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER && ctx.getServerHandler().field_147369_b.func_70003_b(2, "")) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    DrawManger.writeDrawCsvFile(message.modelDrawInfoList);
                    if (message.isReload) {
                        DrawManger.readDrawCsvFile(TouhouLittleMaid.class);
                    }
                });
            }
            return null;
        }
    }
}

