/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemPotionGuide;
import com.github.tartaricacid.touhoulittlemaid.util.ItemFindUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class EntityMaidBrewing
extends EntityAIMoveToBlock {
    private static final int DISTANCE_SQ = 4;
    private final AbstractEntityMaid maid;

    public EntityMaidBrewing(AbstractEntityMaid entityMaid, float speed) {
        super((EntityCreature)entityMaid, (double)speed, 8);
        this.maid = entityMaid;
    }

    public boolean func_75250_a() {
        if (this.maid.func_70906_o() || this.maid.isSleep() || !this.maid.func_70909_n()) {
            return false;
        }
        if (this.field_179496_a > 0) {
            --this.field_179496_a;
            return false;
        }
        this.field_179496_a = 80 + this.maid.func_70681_au().nextInt(40);
        if (this.maid.func_184614_ca().func_77973_b() == MaidItems.POTION_GUIDE) {
            return this.func_179489_g();
        }
        return false;
    }

    public void func_75246_d() {
        TileEntity te;
        if (this.maid.func_174831_c(this.field_179494_b.func_177984_a()) > 4.0) {
            this.field_179491_g = false;
            ++this.field_179493_e;
            if (this.field_179493_e % 40 == 0) {
                this.maid.func_70661_as().func_75492_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)(this.field_179494_b.func_177956_o() + 1), (double)this.field_179494_b.func_177952_p() + 0.5, this.field_179492_d);
            }
        } else {
            this.field_179491_g = true;
            --this.field_179493_e;
        }
        if (this.func_179487_f() && (te = this.maid.field_70170_p.func_175625_s(this.field_179494_b)) instanceof TileEntityBrewingStand) {
            IItemHandler up;
            int fuel;
            TileEntityBrewingStand brewingStand = (TileEntityBrewingStand)te;
            IItemHandlerModifiable maidInv = this.maid.getAvailableInv(false);
            ItemStack guide = this.maid.func_184614_ca();
            ItemStackHandler guideInv = ItemPotionGuide.getGuideInv(guide);
            BlockPos guidePos = ItemPotionGuide.getGuidePos(guide);
            boolean swingHand = false;
            if (guidePos == null || !guidePos.equals((Object)this.field_179494_b)) {
                ItemPotionGuide.setGuideIndex(guide, 0);
                ItemPotionGuide.setGuidePos(guide, this.field_179494_b);
            }
            if ((fuel = brewingStand.func_174887_a_(1)) <= 0) {
                ItemStack stack = ItemFindUtil.getStack((IItemHandler)maidInv, s -> s.func_77973_b() == Items.field_151065_br);
                if (!stack.func_190926_b()) {
                    brewingStand.func_174885_b(1, 20);
                    stack.func_190918_g(1);
                    brewingStand.func_70296_d();
                    swingHand = true;
                } else {
                    return;
                }
            }
            int index = ItemPotionGuide.getGuideIndex(guide);
            int brewTime = brewingStand.func_174887_a_(0);
            IItemHandler output = (IItemHandler)brewingStand.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
            if (index == 0 && brewTime <= 0 && output != null) {
                for (int i = 0; i < output.getSlots(); ++i) {
                    int afterCount;
                    int beforeCount;
                    ItemStack stack = output.getStackInSlot(i);
                    if (brewingStand.func_180461_b(i, stack, EnumFacing.DOWN) && (beforeCount = stack.func_190916_E()) != (afterCount = ItemHandlerHelper.insertItemStacked((IItemHandler)maidInv, (ItemStack)stack.func_77946_l(), (boolean)false).func_190916_E())) {
                        output.extractItem(i, beforeCount - afterCount, false);
                        swingHand = true;
                    }
                    if (output.getStackInSlot(i).func_190926_b()) continue;
                    return;
                }
            }
            IItemHandler side = (IItemHandler)brewingStand.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH);
            boolean noWaterBottle = true;
            if (index == 0 && side != null) {
                for (int i = 0; i < maidInv.getSlots(); ++i) {
                    int afterCount;
                    int beforeCount;
                    ItemStack stack = maidInv.getStackInSlot(i);
                    if (stack.func_77973_b() != Items.field_151068_bn || PotionUtils.func_185191_c((ItemStack)stack) != PotionTypes.field_185230_b || (beforeCount = stack.func_190916_E()) == (afterCount = ItemHandlerHelper.insertItemStacked((IItemHandler)side, (ItemStack)stack.func_77946_l(), (boolean)false).func_190916_E())) continue;
                    maidInv.extractItem(i, beforeCount - afterCount, false);
                    noWaterBottle = false;
                    swingHand = true;
                }
                if (noWaterBottle) {
                    return;
                }
            }
            if ((up = (IItemHandler)brewingStand.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) != null && up.getStackInSlot(0).func_190926_b()) {
                ItemStack ingredient = guideInv.getStackInSlot(index);
                if (ingredient.func_190926_b()) {
                    ItemPotionGuide.setGuideIndex(guide, (index + 1) % 6);
                    return;
                }
                int findSlot = ItemFindUtil.findStackSlot((IItemHandler)maidInv, s -> s.func_185136_b(ingredient));
                ItemStack findIngredient = maidInv.getStackInSlot(findSlot);
                if (!findIngredient.func_190926_b()) {
                    ItemStack copyFindIngredient = findIngredient.func_77946_l();
                    copyFindIngredient.func_190920_e(1);
                    ItemHandlerHelper.insertItemStacked((IItemHandler)up, (ItemStack)copyFindIngredient, (boolean)false);
                    maidInv.extractItem(findSlot, 1, false);
                    ItemPotionGuide.setGuideIndex(guide, (index + 1) % 6);
                    swingHand = true;
                }
            }
            if (swingHand) {
                this.maid.func_184609_a(EnumHand.MAIN_HAND);
            }
        }
    }

    @ParametersAreNonnullByDefault
    protected boolean func_179488_a(World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityBrewingStand) {
            IBlockState state = worldIn.func_180495_p(pos);
            return state.func_177230_c() == Blocks.field_150382_bo;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.maid.func_70906_o() || this.maid.isSleep()) {
            return false;
        }
        return super.func_75253_b() && this.maid.func_184614_ca().func_77973_b() == MaidItems.POTION_GUIDE;
    }
}

